% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_objects.R
\name{RNA_filter}
\alias{RNA_filter}
\title{RNA Filter Object}
\usage{
RNA_filter(omicsData)
}
\arguments{
\item{omicsData}{an object of the class 'seqData', created by
\code{\link{as.seqData}}}
}
\value{
An S3 object of class 'RNAFilt' (data.frame) that contains the
  sample identifiers, library size, the number of unique biomolecules with
  non-zero observations per sample, and the proportion of non-zero
  observations over the total number of biomolecules.
}
\description{
This function returns a RNAFilt object for use with
\code{\link{applyFilt}}
}
\details{
Filter omicsData samples by library size (number of reads) or number
  of unique non-zero biomolecules per sample. Useful for visualizing if a
  sample contains lower than expected number of reads.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(pmartRdata)
to_filter <- RNA_filter(omicsData = rnaseq_object)
summary(to_filter, size_library = 10000)
summary(to_filter, min_nonzero = 5000)
summary(to_filter, min_nonzero = .2)
\dontshow{\}) # examplesIf}
}
\author{
Rachel Richardson
}
