% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_rs.R
\name{rt_rs}
\alias{rt_rs}
\title{Random Variable From a t Distribution}
\usage{
rt_rs(n = 10, df = 5, pmean = 0, psd = 1)
}
\arguments{
\item{n}{The number of random numbers
to generate.}

\item{df}{\code{df} for \code{\link[stats:TDist]{stats::rt()}}.}

\item{pmean}{Population mean.}

\item{psd}{Population standard
deviation.}
}
\value{
A vector of the generated
random numbers.
}
\description{
Generate random numbers
from a \emph{t} distribution, rescaled to
have user-specified population mean
and standard deviation.
}
\details{
First, specify the parameter \code{df}
and the desired population
mean and standard deviation. The
random numbers, drawn from the
generalized normal distribution by
\code{\link[stats:TDist]{stats::rt()}}, will then be
rescaled with the desired population
mean and standard.
}
\examples{
set.seed(90870962)
x <- rt_rs(n = 5000,
           df = 5,
           pmean = 3,
           psd = 1)
mean(x)
sd(x)
hist(x)

}
