% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine-two-stage.R
\name{brms_inla_power_two_stage}
\alias{brms_inla_power_two_stage}
\title{Two-Stage Bayesian Assurance Simulation (Multi-Effect, User-Friendly API)}
\usage{
brms_inla_power_two_stage(
  formula,
  effect_name,
  effect_grid,
  n_range,
  stage1_k_n = 8,
  stage1_nsims = 100,
  stage2_nsims = 400,
  refine_metric = c("direction", "threshold", "rope"),
  refine_target = 0.8,
  prob_threshold = 0.95,
  effect_threshold = 0,
  obs_per_group = NULL,
  error_sd = NULL,
  group_sd = 0.5,
  band = 0.06,
  expand = 1L,
  inla_num_threads = NULL,
  ...
)
}
\arguments{
\item{formula}{Model formula.}

\item{effect_name}{Character vector of fixed effect names; must match formula terms.}

\item{effect_grid}{Data frame with columns named by effect_name specifying effect values.}

\item{n_range}{Numeric length-2 vector specifying sample size range.}

\item{stage1_k_n}{Number of grid points in stage 1.}

\item{stage1_nsims}{Number of simulations per cell in stage 1.}

\item{stage2_nsims}{Number of simulations per cell in stage 2.}

\item{refine_metric}{Metric used for refinement; one of "direction", "threshold", or "rope".}

\item{refine_target}{Target assurance for refined cells.}

\item{prob_threshold}{Posterior probability threshold for decision.}

\item{effect_threshold}{Effect-size threshold for decision metric.}

\item{obs_per_group}{Number of observations per group for grouping factors.}

\item{error_sd}{Residual standard deviation.}

\item{group_sd}{Standard deviation of random effects.}

\item{band}{Numeric width of the target refinement band.}

\item{expand}{Integer; how much to expand the refinement grid around candidates.}

\item{inla_num_threads}{Character string specifying INLA threading (e.g., "4:1").
If NULL (default), automatically detects optimal setting based on CPU cores.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A list with combined simulation results, summary, and stage parameters.
}
\description{
Runs a two-stage Bayesian assurance simulation with formula-based multi-effect grids and adaptive refinement.
}
\examples{
\dontrun{
# Two-stage design with threading
effect_grid <- expand.grid(
  treatment = c(0.2, 0.5, 0.8),
  covariate = c(0.1, 0.3)
)
results <- brms_inla_power_two_stage(
  formula = outcome ~ treatment + covariate,
  effect_name = c("treatment", "covariate"),
  effect_grid = effect_grid,
  n_range = c(50, 200),
  stage1_nsims = 3,
  stage2_nsims = 3,
   error_sd = 1 
)
print(results$summary)
}
}
