% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest.paired.R
\name{ttest.paired}
\alias{ttest.paired}
\title{Power calculation for paired t test}
\usage{
ttest.paired(
  N = NULL,
  delta = NULL,
  sd1 = 1,
  sd2 = NULL,
  rho = NULL,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{N}{The sample size; if the observations are paired differences, this is the number of pairs.}

\item{delta}{DeltaA (the true mean difference) - Delta0 (the mean difference under the null).}

\item{sd1}{The pre standard deviation; defaults to 1.}

\item{sd2}{The post standard deviation; defaults to the value of sd1.}

\item{rho}{The correlation between pre and post measurements on the same individual.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Performs power and sample size calculations for a paired t test.
Can solve for power, N, delta or alpha.
}
\examples{
ttest.paired(N = NULL, delta = 4, sd1 = 10, sd2 = 10, rho = 0.4, power = 0.8, sides = 2)
}
