% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerscale.R, R/powerscale_sequence.R
\name{powerscale-overview}
\alias{powerscale-overview}
\alias{powerscale}
\alias{powerscale.default}
\alias{powerscale.priorsense_data}
\alias{powerscale_sequence}
\alias{powerscale_sequence.default}
\alias{powerscale_sequence.priorsense_data}
\title{Prior/likelihood power-scaling perturbation}
\usage{
powerscale(x, ...)

\method{powerscale}{default}(
  x,
  component,
  alpha,
  moment_match = FALSE,
  k_threshold = NULL,
  resample = FALSE,
  transform = NULL,
  prediction = NULL,
  variable = NULL,
  variables = NULL,
  selection = NULL,
  log_prior_name = "lprior",
  log_lik_name = "log_lik",
  ...
)

\method{powerscale}{priorsense_data}(
  x,
  component,
  alpha,
  moment_match = FALSE,
  k_threshold = NULL,
  resample = FALSE,
  transform = NULL,
  prediction = NULL,
  variable = NULL,
  variables = NULL,
  selection = NULL,
  log_prior_name = "lprior",
  log_lik_name = "log_lik",
  ...
)

powerscale_sequence(x, ...)

\method{powerscale_sequence}{default}(
  x,
  lower_alpha = 0.8,
  upper_alpha = 1/lower_alpha,
  length = 3,
  variable = NULL,
  variables = NULL,
  component = c("prior", "likelihood"),
  moment_match = FALSE,
  k_threshold = 0.5,
  resample = FALSE,
  transform = NULL,
  prediction = NULL,
  auto_alpha_range = FALSE,
  symmetric = TRUE,
  prior_selection = NULL,
  likelihood_selection = NULL,
  ...
)

\method{powerscale_sequence}{priorsense_data}(
  x,
  lower_alpha = 0.8,
  upper_alpha = 1/lower_alpha,
  length = 3,
  variable = NULL,
  variables = NULL,
  component = c("prior", "likelihood"),
  moment_match = FALSE,
  k_threshold = NULL,
  resample = FALSE,
  transform = NULL,
  prediction = NULL,
  auto_alpha_range = FALSE,
  symmetric = TRUE,
  prior_selection = NULL,
  likelihood_selection = NULL,
  ...
)
}
\arguments{
\item{x}{A fitted model object.}

\item{...}{Further arguments passed to internal functions.}

\item{component}{Component to be power-scaled (either "prior" or
"likelihood"). For powerscale_sequence, this can be both "prior"
and "likelihood".}

\item{alpha}{Value by which to power-scale specified
component. (likelihood/prior).}

\item{moment_match}{Logical; Indicate whether or not moment
matching should be performed. Can only be TRUE if \code{is_method} is
"psis".}

\item{k_threshold}{Threshold value for Pareto k values above which
the moment matching algorithm is used. Default is 0.5.}

\item{resample}{Logical; Indicate whether or not draws should be
resampled based on calculated importance weights.}

\item{transform}{Indicate a transformation of posterior draws to
perform before sensitivity analysis. Either "scale" or "whiten".}

\item{prediction}{Function taking the model fit and returning a
draws_df of predictions to be appended to the posterior draws}

\item{variable}{Vector of variable names to return estimated
posterior draws for. If \code{NULL} all variables will be included.}

\item{variables}{Alias of \code{variable}.}

\item{selection}{Vector specifying partitions of component to be
included in power-scaling. Default is NULL, which takes all
partitions. If this is a character, then it is appended to the
variable name (\code{log_prior_name} or \code{log_lik_name}) with an \verb{_}
between them.}

\item{log_prior_name}{Character (case sensitive) specifying name of the variable storing the log prior evaluations}

\item{log_lik_name}{Character (case sensitive) specifying name of the variable storing the log likelihood evaluations}

\item{lower_alpha}{Lower power-scaling alpha value in sequence.}

\item{upper_alpha}{Upper power-scaling alpha value in sequence.}

\item{length}{Length of alpha sequence.}

\item{auto_alpha_range}{Boolean. Restrict range to ensure Pareto-k
values below threshold?}

\item{symmetric}{Boolean. Should the alpha range be symmetrical
around alpha = 1, on log-space?}

\item{prior_selection}{Vector specifying partitions of component to be
included in power-scaling. Default is NULL, which takes all
partitions. If this is a character, then it is appended to the
variable name (specified by \code{log_prior_name}) with an \verb{_}
between them. If numeric, then it is appended inside \verb{[]}.}

\item{likelihood_selection}{Vector specifying partitions of component to be
included in power-scaling. Default is NULL, which takes all
partitions. If this is a character, then it is appended to the
variable name (specified by \code{log_lik_name}) with an \verb{_}
between them. If numeric, then it is appended inside \verb{[]}.}
}
\value{
A \code{powerscaled_draws} or \code{powerscaled_sequence} object,
which contains the estimated posterior draws resulting from the
power-scaling perturbations and details of the perturbation and
estimation methods.
}
\description{
Estimate posterior draws based on power-scaling perturbations of
prior or likelihood using importance sampling (and optionally
moment matching).
}
\examples{
ex <- example_powerscale_model()

powerscale(ex$draws, component = "prior", alpha = 0.5)

powerscale_sequence(ex$draws)
}
\references{
Kallioinen, N., Paananen, T., Bürkner, P-C., Vehtari, A. (2023).
Detecting and diagnosing prior and likelihood sensitivity with
power-scaling perturbations.  \emph{Statistics and
Computing}. 34(57).  \code{doi:10.1007/s11222-023-10366-5}

Vehtari, A., Simpson, D., Gelman, A., Yao, Y., and Gabry,
J. (2024).  Pareto smoothed importance sampling. \emph{Journal of
Machine Learning Research}. 25(72).
\code{https://jmlr.org/papers/v25/19-556.html}

Paananen, T., Piironen, J., Bürkner, P-C., Vehtari, A. (2021).
Implicitly adaptive importance sampling.  \emph{Statistics and
Computing}. 31(16).  \code{doi:10.1007/s11222-020-09982-2}
}
