% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projoint_data.R
\name{projoint_data}
\alias{projoint_data}
\title{Create a projoint_data Object}
\usage{
projoint_data(labels, data)
}
\arguments{
\item{labels}{A data frame of conjoint attribute–level metadata. Must include
attribute names, attribute IDs (e.g., \code{"att1"}), and level IDs
(e.g., \code{"att1:lev1"}).}

\item{data}{A data frame (typically a tibble) containing the reshaped conjoint
survey responses, one row per respondent–task–profile, with attribute columns,
\code{selected}, \code{agree}, and any covariates.}
}
\value{
A list of length two with class \code{"projoint_data"}, containing:
  \itemize{
    \item \code{$labels}: attribute–level mapping
    \item \code{$data}: respondent–task–profile dataset
  }
}
\description{
Internal constructor for \code{projoint_data} objects.  
Used by \code{\link{reshape_projoint}} and \code{\link{make_projoint_data}} to
bundle conjoint survey labels and response data into a consistent structure.
}
\keyword{internal}
