% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cds_diff.R
\name{cds_diff}
\alias{cds_diff}
\title{Create Mean Standardized Differences from Longitudinal CD4 Data}
\usage{
cds_diff(cd_data)
}
\arguments{
\item{cd_data}{A data frame of longitudinal CD4 count values per individual, where rows represent patients and columns represent sequential measurements across time (e.g., years or visits).}
}
\value{
An object of class \code{"Interaction"} with the following components:
\describe{
\item{cds3_diff}{Mean standardized differences of raw CD4 count values.}
}
}
\description{
This function calculates the mean standardized differences of CD4 counts across time for each individual in the dataset.
}
\examples{
data(cd_3)
cd_data <- cd_3[,-1]
result <- cds_diff(cd_data)
}
