% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class003-subject-internal.R
\name{meta-data}
\alias{meta-data}
\alias{save_meta2}
\alias{load_meta2}
\title{Load or save meta data to 'RAVE' subject}
\usage{
save_meta2(data, meta_type, project_name, subject_code)

load_meta2(
  meta_type = c("electrodes", "frequencies", "time_points", "epoch", "references",
    "time_excluded", "info"),
  project_name,
  subject_code,
  subject_id,
  meta_name
)
}
\arguments{
\item{data}{data table}

\item{meta_type}{see load meta}

\item{project_name}{project name}

\item{subject_code}{subject code}

\item{subject_id}{subject identified, alternative way to specify the project
and subject in one string}

\item{meta_name}{for epoch and reference only, the name the of the table}
}
\value{
The corresponding metadata
}
\description{
Load or save meta data to 'RAVE' subject
}
\examples{


if(has_rave_subject("demo/DemoSubject")) {
  subject <- as_rave_subject("demo/DemoSubject", strict = FALSE)

  electrode_table <- subject$get_electrode_table()

  save_meta2(
    data = electrode_table,
    meta_type = "electrodes",
    project_name = subject$project_name,
    subject_code = subject$subject_code
  )

  load_meta2(meta_type = "electrodes", subject_id = subject)
}

}
