% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R.R
\name{R}
\alias{R}
\title{Create a Result Descriptor by Recording Effects of an Expression Evaluation}
\usage{
R(expr, ..., envir = parent.frame())
}
\arguments{
\item{expr}{expression to be evaluated}

\item{...}{further arguments to be passed to \code{\link{P}}}

\item{envir}{environment where \code{expr} is to be evaluated}
}
\value{
A list of class \code{realtest_descriptor},
see \code{\link{P}}, which this function calls.
The additional named component \code{expr} gives the
expression that generated the \code{value}.
Moreover, \code{args} gives a named list of objects
that appeared in \code{expr} (not including functions called).

If an effect of particular kind does not occur,
it is not included in the resulting list.
\code{stdout}, \code{stderr}, and \code{error} are at most single strings.

When an error occurs, \code{value} is \code{NULL}.
}
\description{
Evaluates an expression and records its direct and indirect effects:
the resulting value as well as the information whether any errors,
warnings, or messages are generated and if anything is printed on
\code{\link[base]{stdout}} or \code{\link[base]{stderr}}.
}
\details{
Note that messages, warnings, and errors are typically written to
\code{\link[base]{stderr}}, but these are considered separately here.
In other words, when testing expectations with \code{\link{E}},
e.g., the reference \code{stderr} should not include the anticipated
diagnostic messages.

There may be other side effects, such as changing the state of
the random number generator, modifying options or environment variables,
modifying the calling or global environment (e.g., creating new global
variables), attaching objects onto the search part (e.g., loading
package namespaces), or plotting, but these will not be captured,
at least, not by the current version of the \pkg{realtest} package.
}
\examples{
y <- 1:10; R(sum(y^2))
R(cat("a bit talkative, innit?"))
R(sqrt(c(-1, 0, 1, 2, 4)))
R(log("aaaargh"))
R({
    cat("STDOUT"); cat("STDERR", file=stderr()); message("MESSAGE");
    warning("WARNING"); warning("WARNING AGAIN"); cat("MORE STDOUT");
    message("ANOTHER MESSAGE"); stop("ERROR"); y; "NO RETURN VALUE"
})

}
\seealso{
The official online manual of \pkg{realtest} at \url{https://realtest.gagolewski.com/}

Related functions:
\code{\link{E}}, \code{\link{P}}
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
