% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.trivRegion.R
\name{plot.trivRegion}
\alias{plot.trivRegion}
\title{Default trivRegion plotting}
\usage{
\method{plot}{trivRegion}(
  x,
  cond = FALSE,
  planes = FALSE,
  newdata = NULL,
  add = FALSE,
  reg.col = NULL,
  incol = "grey",
  legend = FALSE,
  ...
)
}
\arguments{
\item{x}{A trivRegion object.}

\item{cond}{A logical argument, if TRUE a conditional reference region is depicted.}

\item{planes}{Logical; if TRUE, planes are added indicating (x=0,y=0,z=0).}

\item{newdata}{If cond==TRUE, a data frame containing covariate
values for which the reference/probabilistic region will be depicted.}

\item{add}{A logical argument, if TRUE the conditional reference region is depicted over a pre existing plot.}

\item{reg.col}{Region contour colour.}

\item{incol}{Colours for the points included inside the reference region.}

\item{legend}{A logical argument, if TRUE a legend is given along with the reference region.}

\item{...}{Further rgl plot parameters.}
}
\value{
This function return an interactive rgl plot of a bivRegion object.
}
\description{
This function allow to depict in an interactive rgl plot the estimated trivariate reference/probabilistic
region. If cond=FALSE it showes trivariate standarized residuals, while with
cond=TRUE it represents the region shape for any covariate(s) value.
}
