################## Correlation and Effect Sizes ##############################
#' @export
#' @importFrom stats cor
#' @importFrom effsize cohen.d
#' @importFrom formattable formattable formatter
#' @importFrom htmlwidgets saveWidget


cordata <- function(Before, After, within = TRUE, data = NULL) {
  if (!is.null(data)) {
    Before <- data[[Before]]
    After <- data[[After]]
  }
  
  Correlation <- round(cor(Before, After), 2)
  
  if (within) {
    ef_pol <- round(cohen.d(After, Before, paired = TRUE)$estimate, 2)
    ef_std <- round(cohen.d(After, Before, paired = TRUE, pooled = FALSE)$estimate, 2)
  } else {
    ef_pol <- round(cohen.d(After, Before, paired = TRUE, within = FALSE)$estimate, 2)
    ef_std <- round(cohen.d(After, Before, paired = TRUE, pooled = FALSE, within = FALSE)$estimate, 2)
  }
  
  result <- data.frame(
    Correlation = Correlation,
    `Effect size (pooled sd)` = ef_pol,
    `Effect size (based on treatment sd)` = ef_std
  )
  
  # Only show formattable in interactive session
  if (interactive()) {
    formatted <- formattable(result)
    temp_file <- tempfile(fileext = ".html")
    htmlwidgets::saveWidget(formatted, temp_file, selfcontained = TRUE)
    viewer <- getOption("viewer")
    if (!is.null(viewer)) {
      viewer(temp_file)
    } else {
      utils::browseURL(temp_file)
    }
  }
  
  return(result)
}


#' @examples
#' # Lade eingebetteten Beispieldatensatz
#' data(language_test)
#' 
#' # Berechne Korrelation und Effektgrößen
#' cordata("Before", "After", data = language_test)
