% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/py_require.R
\name{uv_run_tool}
\alias{uv_run_tool}
\title{uv run tool}
\usage{
uv_run_tool(
  tool,
  args = character(),
  ...,
  from = NULL,
  with = NULL,
  python_version = NULL,
  exclude_newer = NULL
)
}
\arguments{
\item{tool, args}{A character vector of command and arguments. Arguments are
not quoted for the shell, so you may need to use \code{\link[=shQuote]{shQuote()}}.}

\item{...}{
  Arguments passed on to \code{\link[base:system2]{base::system2}}
  \describe{
    \item{\code{stdout,stderr}}{where output to \file{stdout} or
    \file{stderr} should be sent.  Possible values are \code{""}, to the \R
    console (the default), \code{NULL} or \code{FALSE} (discard output),
    \code{TRUE} (capture the output in a character vector) or a
    character string naming a file.}
    \item{\code{stdin}}{should input be diverted?  \code{""} means the default,
    alternatively a character string naming a file.  Ignored
    if \code{input} is supplied.}
    \item{\code{input}}{if a character vector is supplied, this is copied one
    string per line to a temporary file, and the standard input of
    \code{command} is redirected to the file.}
    \item{\code{env}}{character vector of name=value strings to set environment
    variables.}
    \item{\code{wait}}{a logical (not \code{NA}) indicating whether the \R
    interpreter should wait for the command to finish, or run it
    asynchronously.  This will be ignored (and the interpreter will
    always wait) if \code{stdout = TRUE} or \code{stderr = TRUE}. When
    running the command asynchronously, no output will be displayed on
    the \code{Rgui} console in Windows (it will be dropped, instead).}
    \item{\code{timeout}}{timeout in seconds, ignored if 0.  This is a limit for the
    elapsed time running \code{command} in a separate process.   Fractions
    of seconds are ignored.}
    \item{\code{receive.console.signals}}{a logical (not \code{NA}) indicating whether
    the command should receive events from the terminal/console that \R runs
    from, particularly whether it should be interrupted by \kbd{Ctrl-C}. This
    will be ignored and events will always be received when
    \code{intern = TRUE} or \code{wait = TRUE}.}
    \item{\code{minimized,invisible}}{arguments that are accepted on Windows but
    ignored on this platform, with a warning.}
  }}

\item{from}{Use the given Python package to provide the command.}

\item{with}{Run with the given Python packages installed. You can also
specify version constraints like \code{"ruff>=0.3.0"}.}

\item{python_version}{A Python version string, or character vector of Python
version constraints.}

\item{exclude_newer}{String. Limit package versions to those published before
a specified date. This offers a lightweight alternative to freezing package
versions, helping guard against Python package updates that break a
workflow. Accepts strings formatted as RFC 3339 timestamps (e.g.,
\code{"2006-12-02T02:07:43Z"}) and local dates in the same format (e.g.,
\code{"2006-12-02"}) in your system's configured time zone.}
}
\value{
Return value of \code{\link[=system2]{system2()}}
}
\description{
Run a Command Line Tool distributed as a Python package. Packages are
automatically download and installed into a cached, ephemeral, and isolated
environment on the first run.
}
\details{
\subsection{Examples}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{uv_run_tool("pycowsay", shQuote("hello from reticulate"))
uv_run_tool("markitdown", shQuote(file.path(R.home("doc"), "NEWS.pdf")), stdout = TRUE)
uv_run_tool("kaggle competitions download -c dogs-vs-cats")
uv_run_tool("ruff", "--help")
uv_run_tool("ruff format", shQuote(Sys.glob("**.py")))
uv_run_tool("http", from = "httpie")
uv_run_tool("http", "--version", from = "httpie<3.2.4", stdout = TRUE)
uv_run_tool("saved_model_cli", "--help", from = "tensorflow")
}\if{html}{\out{</div>}}
}
}
\seealso{
\url{https://docs.astral.sh/uv/guides/tools/}
}
