% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.rpm.R
\name{simulate.rpm}
\alias{simulate.rpm}
\title{Simulate a sample of pairs and singles from a Revealed Preference Matchings Model}
\usage{
\method{simulate}{rpm}(
  object,
  nsim = 1,
  seed = NULL,
  ...,
  N = NULL,
  num_women = NULL,
  num_men = NULL,
  pmfW = NULL,
  pmfM = NULL,
  large.population = TRUE,
  num_sampled = NULL,
  bootstrap = FALSE,
  sampling_design = NULL,
  control = control.rpm(),
  verbose = FALSE
)
}
\arguments{
\item{object}{list; an object of class\code{rpm} that is typically the result of a call to \code{rpm()}.}

\item{nsim}{Number of matchings to be randomly drawn from the given
model on the set of all matchings / singles.}

\item{seed}{integer; (Optional) random number seed.}

\item{\dots}{Additional arguments, to be passed to lower-level functions.}

\item{N}{integer; The total population size. This must be set. The number of women and men are derived from the
(weighted) data.}

\item{num_women}{integer; (Optional) The number of women in the population.}

\item{num_men}{integer; (Optional) The number of men in the population.}

\item{pmfW}{vector; (Optional) The population proportions of the numbers of women of each type. 
This should be compatible with the type in the object.}

\item{pmfM}{vector; (Optional) The population proportions of the numbers of men of each type. 
This should be compatible with the type in the object.}

\item{large.population}{logical; If TRUE a large population approximation is used to generate
the matchings (rather than the individual level generation of utilities). This is much faster and
uses a lot less memory. It is TRUE by default. If used, a sample is drawn rather than the
population being returned. The sample size is controlled by \code{num_sampled}.}

\item{num_sampled}{integer; The size of the sample to be drawn. For "stock-stock" sampling this is the 
number of sampled households. For "stock-flow" it is the number of sampled people.
For "census" it is the total population size, N. If NULL the size is the same as
the passed fitted object (that is, the original data), although this is only a guess and it should be explicitly set.}

\item{bootstrap}{logical; If TRUE the original population is sampled from. If FALSE the
population underlying the fitted model is sampled from.}

\item{sampling_design}{string; The name of the sampling protocol used to select the survey data. Valid values are
\code{"stock-flow"} (individuals are sampled, data contains both
singles and couples);
\code{"stock-stock"} (households are sampled, each household can be a single or a couple);
\code{"census"} (the sample is a census of the population of people).
The final option, the default, is NULL whereby the design is taken from the passed object.}

\item{control}{A list of control parameters for algorithm tuning. Constructed using
\code{\link{control.rpm}}, which should be consulted for specifics.}

\item{verbose}{logical; Should verbose messages be printed out.}
}
\value{
A list of data.frame, each a simulation from the population.
}
\description{
\code{\link{simulate.rpm}} simulates a population of the pairs and singles
from a Revealed Preference Matchings Model. It is typically based on the estimate from a \code{rpm()} call.
}
\details{
The function \code{\link{rpm}} is used to fit a revealed preference model
for men and women of certain
characteristics (or shared characteristics) of people of the opposite sex.
The model assumes a one-to-one stable matching using an observed set of
matchings and a set of (possibly dyadic) covariates to 
estimate the parameters for
linear equations of utilities.
It does this using an large-population likelihood based on ideas from Dagsvik (2000), Menzel (2015) and Goyal et al (2023).

The model represents the dyadic utility functions as deterministic linear utility functions of
dyadic variables. These utility functions are functions of observed characteristics of the women
and men.
These functions are entered as terms in the function call
to \code{\link{rpm}}. This function simulates from such a model.
}
\examples{
library(rpm)
\donttest{
data(fauxmatching)
fit <- rpm(~match("edu") + WtoM_diff("edu",3),
          Xdata=fauxmatching$Xdata, Zdata=fauxmatching$Zdata,
          X_w="X_w", Z_w="Z_w",
          pair_w="pair_w", pair_id="pair_id", Xid="pid", Zid="pid",
          sampled="sampled")
a <- simulate(fit)
}
}
\references{
Goyal, Shuchi; Handcock, Mark S.; Jackson, Heide M.; Rendall, Michael S. and Yeung, Fiona C. (2023).
\emph{A Practical Revealed Preference Model for Separating Preferences and Availability Effects in Marriage Formation},
\emph{Journal of the Royal Statistical Society}, A. \doi{10.1093/jrsssa/qnad031} 

Dagsvik, John K. (2000) \emph{Aggregation in Matching Markets} \emph{International Economic Review}, Vol. 41, 27-57.
JSTOR: https://www.jstor.org/stable/2648822, \doi{10.1111/1468-2354.00054}

Menzel, Konrad (2015).
\emph{Large Matching Markets as Two-Sided Demand Systems}
Econometrica, Vol. 83, No. 3 (May, 2015), 897-941. \doi{10.3982/ECTA12299}
}
\keyword{models}
