% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CTS_Server.R
\name{CTS_fetch_ds}
\alias{CTS_fetch_ds}
\title{Fetch Clinical Trial Simulator Module Datasets}
\usage{
CTS_fetch_ds(state)
}
\arguments{
\item{state}{CTS state from \code{CTS_fetch_state()}}
}
\value{
Character object vector with the lines of code

list containing the following elements
\itemize{
\item{isgood:}    Return status of the function.
\item{hasds:}     Boolean indicator if the module has any datasets
\item{msgs:}      Messages to be passed back to the user.
\item{ds:}        List with datasets. Each list element has the name of
the R-object for that dataset. Each element has the following structure:
\itemize{
\item{label: Text label for the dataset}
\item{MOD_TYPE: Short name for the type of module.}
\item{id: module ID}
\item{DS: Dataframe containing the actual dataset.}
\item{DSMETA: Metadata describing DS}
\item{code: Complete code to build dataset.}
\item{checksum: Module checksum.}
\item{DSchecksum: Dataset checksum.}
}
}
}
\description{
Fetches the datasets produced by the module. For each cohort
this will be the simulation timecourse and the event table
}
\examples{
# For more information see the Clinical Trial Simulation vignette:
# https://ruminate.ubiquity.tools/articles/clinical_trial_simulation.html
# None of this will work if rxode2 isn't installed:
\donttest{
library(formods)
if( Sys.getenv("ruminate_rxfamily_found") == "TRUE"){

# This will populate the session variable with the model building (MB) module
sess_res = MB_test_mksession()
session = sess_res[["session"]]

id     = "CTS"
id_ASM = "ASM"
id_MB  = "MB"
input  = list()

# Configuration files
FM_yaml_file  = system.file(package = "formods", "templates", "formods.yaml")
MOD_yaml_file = system.file(package = "ruminate", "templates", "CTS.yaml")

state = CTS_fetch_state(id              = id,
                        id_ASM          = id_ASM,
                        id_MB           = id_MB,
                        input           = input,
                        session         = session,
                        FM_yaml_file    = FM_yaml_file,
                        MOD_yaml_file   = MOD_yaml_file,
                        react_state     = NULL)


# Fetch a list of the current element
current_ele = CTS_fetch_current_element(state)

# You can modify the element
current_ele[["element_name"]] = "A more descriptive name"

# Defining the source model
state[["CTS"]][["ui"]][["source_model"]] = "MB_obj_1_rx"
current_ele = CTS_change_source_model(state, current_ele)

# Single visit
current_ele[["ui"]][["visit_times"]]                 = "0"
current_ele[["ui"]][["cts_config_nsteps"]]           = "5"

# Creating a dosing rule
state[["CTS"]][["ui"]][["rule_condition"]]           = "time == 0"
state[["CTS"]][["ui"]][["rule_type"]]                = "dose"
state[["CTS"]][["ui"]][["action_dosing_state"]]      = "central"
state[["CTS"]][["ui"]][["action_dosing_values"]]     = "c(1)"
state[["CTS"]][["ui"]][["action_dosing_times"]]      = "c(0)"
state[["CTS"]][["ui"]][["action_dosing_durations"]]  = "c(0)"
state[["CTS"]][["ui"]][["rule_name"]]                = "Single_Dose"

# Adding the rule:
current_ele = CTS_add_rule(state, current_ele)

# Appending the plotting details as well
current_ele[["ui"]][["fpage"]]             = "1"
current_ele[["ui"]][["dvcols"]]            = "Cc"

# Reducing the number of subjects and steps to speed things up on CRAN
current_ele[["ui"]][["nsub"]]              = "2"
current_ele[["ui"]][["cts_config_nsteps"]] = "5"

# Putting the element back in the state forcing code generation
state = CTS_set_current_element(
  state   = state,
  element = current_ele)

# Now we pull out the current element, and simulate it
current_ele = CTS_fetch_current_element(state)
#current_ele = CTS_simulate_element(state, current_ele)

# Next we plot the element
current_ele = CTS_plot_element(state, current_ele)

# Now we save those results back into the state:
state = CTS_set_current_element(
  state   = state,
  element = current_ele)

# This will extract the code for the current module
code = CTS_fetch_code(state)
code

# This will update the checksum of the module state
state = CTS_update_checksum(state)


# Access the datasets generated from simulations
ds = CTS_fetch_ds(state)

# CTS_add_covariate
state[["CTS"]][["ui"]][["covariate_value"]]            = "70, .1"
state[["CTS"]][["ui"]][["covariate_type_selected"]]    = "cont_lognormal"
state[["CTS"]][["ui"]][["selected_covariate"]]         = "WT"
current_ele = CTS_add_covariate(state, current_ele)

# Creates a new empty element
state = CTS_new_element(state)

# Delete the current element
state = CTS_del_current_element(state)
}
}
}
