% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Statistics.R
\name{Proportion_Plot}
\alias{Proportion_Plot}
\title{Cell Proportion Plot}
\usage{
Proportion_Plot(
  seurat_object,
  plot_type = "bar",
  plot_scale = "percent",
  group_by_var = deprecated(),
  group.by = "ident",
  split.by = NULL,
  num_columns = NULL,
  x_lab_rotate = TRUE,
  colors_use = NULL,
  ggplot_default_colors = FALSE,
  color_seed = 123
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{plot_type}{whether to plot a pie chart or bar chart; value must be one of \code{"bar"} or \code{"pie"}. Default
is \code{"bar"}}

\item{plot_scale}{whether to plot bar chart as total cell counts or percents, value must be one of \code{"percent"} or
\code{"count"}. Default is \code{"percent"}.}

\item{group_by_var}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} soft-deprecated. See \code{group.by}.}

\item{group.by}{meta data column to classify samples (default = "ident" and will use \code{active.ident}).}

\item{split.by}{meta data variable to use to split plots.  Default is NULL which will plot across entire object.}

\item{num_columns}{number of columns in plot.  Only valid if \code{split.by} is not NULL.}

\item{x_lab_rotate}{Rotate x-axis labels 45 degrees (Default is FALSE). Only valid if \code{plot_type = "bar"}.}

\item{colors_use}{color palette to use for plotting.}

\item{ggplot_default_colors}{logical.  If \code{colors_use = NULL}, Whether or not to return plot using
default ggplot2 "hue" palette instead of default "polychrome" or "varibow" palettes.}

\item{color_seed}{random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}
}
\value{
ggplot2 or patchwork object
}
\description{
Plots the proportion of cells belonging to each identity in \code{active.ident} of Seurat object.
Can plot either the totals or split by a variable in \code{meta.data}.
}
\examples{
#' library(Seurat)
Proportion_Plot(seurat_object = pbmc_small)

}
\concept{stats_plotting}
