% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/LIGER_Utilities.R, R/Utilities.R
\name{Top_Genes_Factor}
\alias{Top_Genes_Factor}
\alias{Top_Genes_Factor.liger}
\alias{Top_Genes_Factor.Seurat}
\title{Extract top loading genes for LIGER factor}
\usage{
Top_Genes_Factor(object, factor = NULL, num_genes = 10, ...)

\method{Top_Genes_Factor}{liger}(object, factor = NULL, num_genes = 10, ...)

\method{Top_Genes_Factor}{Seurat}(object, factor = NULL, num_genes = 10, reduction, ...)
}
\arguments{
\item{object}{object name.}

\item{factor}{factor number to pull genes from. Set to "all" to return top loading
genes from all factors}

\item{num_genes}{number of top loading genes to return as vector, default is 10.}

\item{...}{Arguments passed to other methods}

\item{reduction}{name of reduction containing NMF/iNMF/cNMF data.}
}
\value{
vector of top genes for given factor or data.frame containing top genes
across all factors
}
\description{
Extract vector to the top loading genes for specified LIGER iNMF factor
}
\examples{
\dontrun{
top_genes_factor10 <- Top_Genes_Factor(object = object, factor = 1, num_genes = 10)
}

\dontrun{
top_genes_factor10 <- Top_Genes_Factor(object = object, factor = 1, num_genes = 10,
reduction = "cNMF")
}

}
\concept{liger_object_util}
\concept{marker_annotation_util}
