% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_functions.R
\name{calc_pred_moments}
\alias{calc_pred_moments}
\title{Calculate Predictive Moments}
\usage{
calc_pred_moments(object, newdata, nsamp = 100)
}
\arguments{
\item{object}{A \code{shrinkGPR} object representing the fitted Gaussian process regression model.}

\item{newdata}{\emph{Optional} data frame containing the covariates for the new data points. If missing, the training data is used.}

\item{nsamp}{Positive integer specifying the number of posterior samples to use for the calculation. Default is 100.}
}
\value{
A list with two elements:
\itemize{
\item \code{means}: A matrix of predictive means for each new data point, with the rows being the samples and the columns the data points.
\item \code{vars}: An array of covariance matrices, with the first dimension corresponding to the samples and second and third dimensions to the data points.
}
}
\description{
\code{calc_pred_moments} calculates the predictive means and variances for a fitted \code{shrinkGPR} model at new data points.
}
\details{
This function computes predictive moments by marginalizing over posterior samples from the fitted model. If the mean equation is included in the model, the corresponding covariates are used.
}
\examples{
\donttest{
if (torch::torch_is_installed()) {
  # Simulate data
  set.seed(123)
  torch::torch_manual_seed(123)
  n <- 100
  x <- matrix(runif(n * 2), n, 2)
  y <- sin(2 * pi * x[, 1]) + rnorm(n, sd = 0.1)
  data <- data.frame(y = y, x1 = x[, 1], x2 = x[, 2])

  # Fit GPR model
  res <- shrinkGPR(y ~ x1 + x2, data = data)

  # Calculate predictive moments
  momes <- calc_pred_moments(res, nsamp = 100)
  }
}
}
