% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_data.R
\name{data_gen}
\alias{data_gen}
\title{Generate Synthetic Data with Various Structures}
\usage{
data_gen(type = "all", n = 500, degree = NULL, seed = NULL)
}
\arguments{
\item{type}{Character string. Options:
\itemize{
\item \code{"polynomial"} for orthogonal polynomial features
\item \code{"linear"}, \code{"sine"}, \code{"circle"}, \code{"cluster"}, \code{"snake"}, \code{"outliers"},
\code{"sparse"}, \code{"clumpy"}, \code{"skewed"}, \code{"striated"}, \code{"concave"}, \code{"monotonic"}, \code{"doughnut"},
or \code{"all"} to generate all scatter structures.
}}

\item{n}{Integer. Number of samples to generate. Default is 500.}

\item{degree}{Integer. Degree of polynomial features (only for \code{type = "polynomial"}).}

\item{seed}{Optional integer. Sets random seed for reproducibility.}
}
\value{
\itemize{
\item If \code{type = "polynomial"}, returns a matrix (\code{n} x \code{degree}).
\item Otherwise a tibble with columns:
\item \code{x}: Numeric vector of x-values
\item \code{y}: Numeric vector of y-values
\item \code{structure}: Character name of the structure type
}
}
\description{
Generates either:
\itemize{
\item Structured (x, y) scatter data (linear, sine, circle, etc.), or
\item A matrix of scaled orthogonal polynomial features.
}
}
\examples{
data_gen("linear", n = 200)
data_gen("polynomial", degree = 4, n = 200)
data_gen("all", n = 200)

}
