
# tests/testthat/test-calculate_EF.R

library(testthat)
library(ssebiEF)

test_that("calculate_EF works correctly", {
  albedo_path <- system.file("extdata", "albedo_reduced.tif", package = "ssebiEF")
  TS_TA_path <- system.file("extdata", "TS_TA_reduced.tif", package = "ssebiEF")

  # Check if the files exist
  expect_true(file.exists(albedo_path), "The file albedo_reduced.tif was not found.")
  expect_true(file.exists(TS_TA_path), "The file TS_TA_reduced.tif was not found.")

  # Load the rasters
  albedo <- rast(albedo_path)
  TS_TA <- rast(TS_TA_path)

  # Test the function
  output_path <- tempfile(fileext = ".tif")
  result <- calculate_EF(albedo, TS_TA, output_path, n_intervals = 20, percentile = 0.01)
  expect_true(file.exists(output_path))
})
