% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fra_leaderyears}
\alias{fra_leaderyears}
\title{French Leader-Years, 1874-2015}
\format{
A data frame with 255 observations on the following 10 variables.
\describe{
\item{\code{obsid}}{the unique observation ID in the Archigos data}
\item{\code{ccode}}{the Correlates of War state code for France (220)}
\item{\code{leader}}{a name---typically last name---for the leader}
\item{\code{year}}{an observation year for the leader}
\item{\code{startdate}}{the start date for the leader's period in office}
\item{\code{enddate}}{the end date for the leader's period in office}
\item{\code{gmlmidongoing}}{was there an ongoing inter-state dispute for the leader?}
\item{\code{gmlmidonset}}{was there a new inter-state dispute onset for the leader?}
\item{\code{gmlmidongoing_init}}{was there an ongoing inter-state dispute for the leader that the leader initiated?}
\item{\code{gmlmidonset_init}}{was there a new inter-state dispute onset for the leader that the leader initiated?}
}
}
\usage{
fra_leaderyears
}
\description{
These are data generated in \pkg{peacesciencer} for all French leader-years from 1874 to 2015. I'm going to use
these data for stress-testing the calculation of so-called "peace spells" for data that are decidedly imbalanced,
as these are.
}
\details{
Data are generated in the development version (scheduled release of v. 0.7) of \pkg{peacesciencer}. Conflict data
come from the GML MID data (v. 2.2.1). Leader data come from Archigos (v. 4.1).
}
\references{
Goemans, Henk E., Kristian Skrede Gleditsch, and Giacomo Chiozza. 2009. "Introducing Archigos: A Dataset of Political Leaders"
\emph{Journal of Peace Research} 46(2): 269--83.

Gibler, Douglas M., Steven V. Miller, and Erin K. Little. 2016. “An Analysis of the Militarized
Interstate Dispute (MID) Dataset, 1816-2001.” International Studies Quarterly 60(4): 719-730.
}
\keyword{datasets}
