% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lemmatize.R
\name{lemmatize}
\alias{lemmatize}
\title{Lemmatize Sentences Using a UDPipe Model}
\usage{
lemmatize(
  sentences,
  udpipe_model_file,
  corrections_file,
  language,
  use_seeds = TRUE
)
}
\arguments{
\item{sentences}{A data frame containing sentences, with at least a \code{sentenceid}, \code{sentence}, \code{document},
and \code{submissionid} column.}

\item{udpipe_model_file}{A character string representing the path to the UDPipe model file used for annotation.}

\item{corrections_file}{A character string representing the path to a CSV file containing corrections
to be applied to the lemmas.}

\item{language}{A character string representing the language of the dataset ('nl', 'en', 'de' or 'fr')}

\item{use_seeds}{A logical value indicating whether to use the seeds (e.g. of an educational framework)}
}
\value{
A data frame containing the lemmatized sentences with the following columns:
\itemize{
\item \code{doc_id}: Document identifier.
\item \code{lemma}: The lemmatized form of each word.
\item \code{upos}: Universal part-of-speech tag.
\item \code{sentenceid}: The sentence ID for the sentence from which the lemma was extracted.
\item \code{document}: Document associated with the sentence.
\item \code{submissionid}: Submission ID associated with the sentence.
}
}
\description{
This function processes a dataset of sentences using a UDPipe model to perform
lemmatization, applies corrections to the lemmas, and associates metadata (e.g., submission ID, document)
with the processed sentences. If UDPipie is not available, package NLP is used.
}
\details{
This function loads a UDPipe model, annotates the input sentences, corrects lemmas based on
a provided corrections file, and optionally filters by noun tokens. It returns a data frame with the
sentence-level annotations.
}
