% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losses.R
\name{survdnn_losses}
\alias{survdnn_losses}
\alias{cox_loss}
\alias{cox_l2_loss}
\alias{aft_loss}
\alias{coxtime_loss}
\title{Loss Functions for survdnn Models}
\usage{
cox_loss(pred, true)

cox_l2_loss(pred, true, lambda = 1e-04)

aft_loss(pred, true)

coxtime_loss(pred, true)
}
\arguments{
\item{pred}{A tensor of predicted values (typically linear predictors or log-times).}

\item{true}{A tensor with two columns: observed time and status (1 = event, 0 = censored).}

\item{lambda}{Regularization parameter for `cox_l2_loss` (default: `1e-4`).}
}
\value{
A scalar `torch_tensor` representing the loss value.
}
\description{
These functions define various loss functions used internally by `survdnn()` for training deep neural networks on right-censored survival data.
}
\section{Supported Losses}{

- **Cox partial likelihood loss** (`cox_loss`): Negative partial log-likelihood used in proportional hazards modeling.
- **L2-penalized Cox loss** (`cox_l2_loss`): Adds L2 regularization to the Cox loss.
- **Accelerated Failure Time (AFT) loss** (`aft_loss`): Mean squared error between predicted and log-transformed event times, applied to uncensored observations only.
- **CoxTime loss** (`coxtime_loss`): Implements the partial likelihood loss from Kvamme & Borgan (2019), used in Cox-Time models.
}

\examples{
# Used internally by survdnn()
}
\keyword{internal}
