% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_xgboost.R
\name{learner_xgboost}
\alias{learner_xgboost}
\title{Construct a learner}
\usage{
learner_xgboost(
  formula,
  max_depth = 2L,
  eta = 1,
  nrounds = 2L,
  subsample = 1,
  lambda = 1,
  verbose = 0,
  objective = "reg:squarederror",
  info = paste("xgboost", objective),
  learner.args = NULL,
  ...
)
}
\arguments{
\item{formula}{(formula) Formula specifying response and design matrix.}

\item{max_depth}{(integer) Maximum depth of a tree.}

\item{eta}{(numeric) Learning rate.}

\item{nrounds}{max number of boosting iterations.}

\item{subsample}{(numeric) Subsample ratio of the training instance.}

\item{lambda}{(numeric) L2 regularization term on weights.}

\item{verbose}{If 0, xgboost will stay silent. If 1, it will print information about performance.
If 2, some additional information will be printed out.
Note that setting \code{verbose > 0} automatically engages the
\code{cb.print.evaluation(period=1)} callback function.}

\item{objective}{(character) Specify the learning task and the corresponding
learning objective. See \link[xgboost:xgb.train]{xgboost::xgboost} for all available options.}

\item{info}{(character) Optional information to describe the instantiated
\link{learner} object.}

\item{learner.args}{(list) Additional arguments to
\link[=learner]{learner$new()}.}

\item{...}{Additional arguments to \link[xgboost:xgb.train]{xgboost::xgboost}.}
}
\value{
\link{learner} object.
}
\description{
Constructs a \link{learner} class object for \link[xgboost:xgb.train]{xgboost::xgboost}.
}
\examples{
n  <- 1e3
x1 <- rnorm(n, sd = 2)
x2 <- rnorm(n)
lp <- x2*x1 + cos(x1)
yb <- rbinom(n, 1, lava::expit(lp))
y <-  lp + rnorm(n, sd = 0.5**.5)
d0 <- data.frame(y, yb, x1, x2)

# regression
lr <- learner_xgboost(y ~ x1 + x2, nrounds = 5)
lr$estimate(d0)
lr$predict(head(d0))

# binary classification
lr <- learner_xgboost(yb ~ x1 + x2, nrounds = 5,
 objective = "binary:logistic"
)
lr$estimate(d0)
lr$predict(head(d0))

# multi-class classification
d0 <- iris
d0$y <- as.numeric(d0$Species)- 1

lr <- learner_xgboost(y ~ ., objective = "multi:softprob", num_class = 3)
lr$estimate(d0)
lr$predict(head(d0))
}
