% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_ucarima.R
\name{cwfact}
\alias{cwfact}
\title{Cramer-Wold Factorization}
\usage{
cwfact(
  g,
  th = NULL,
  method = c("roots", "wilson", "best"),
  tol = 1e-08,
  iter.max = 500
)
}
\arguments{
\item{g}{A numeric vector with the autocovariance coefficients \code{c(g0,
g1, ..., gq)}.}

\item{th}{Optional numeric vector with initial values for the MA coefficients
\eqn{\theta(x)}.}

\item{method}{A character string specifying the factorization method to use.
Options are \code{"roots"} (default) and \code{"wilson"}.}

\item{tol}{A numeric tolerance for convergence (only used for \code{method =
"wilson"}). Default is \code{1e-8}.}

\item{iter.max}{Maximum number of iterations for the Wilson method. Default
is \code{100}.}
}
\value{
A numeric vector containing the moving average coefficients
  \code{c(theta_0, ..., theta_q)}.
}
\description{
\code{cwfact} performs the Cramer-Wold factorization of the generating
autocovariance function of a pure moving average (MA) process, expressed as:
\deqn{g(x) = \theta(x)\theta(x^{-1})} where \deqn{g(x) = g_0 + g_1(x +
x^{-1}) + \dots + g_q(x^q + x^{-q})} and \deqn{\theta(x) = \theta_0 +
\theta_1 x + \dots + \theta_q x^q}
}
\details{
The factorization can be computed by finding the roots of the polynomial
\eqn{g(x)}, or using the iterative Wilson (1969) algorithm as implemented by
Laurie (1981).

The implementation for \code{method = "laurie"} is a custom R
adaptation of Algorithm AS 175 from Laurie (1981).
}
\examples{
g <- autocov(um(ma = "1 - 0.8B"), lag.max = 1)
cwfact(g, method = "roots")
cwfact(g, method = "wilson")

}
\references{
Wilson, G. T. (1969). Factorization of the covariance generating
function of a pure moving average process. \emph{SIAM Journal on Numerical
Analysis}, 6(1), 1–7.

Laurie, D. P. (1981). Cramer-Wold Factorization. \emph{Journal of the Royal
Statistical Society Series C: Applied Statistics}, 31(1), 86–93.
}
