% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_report_indiv.R
\name{autoplot.qc_report_indiv}
\alias{autoplot.qc_report_indiv}
\title{Autoplots for \code{qc_report_indiv} objects}
\usage{
\method{autoplot}{qc_report_indiv}(
  object,
  type = c("scatter", "relatedness"),
  miss_threshold = 0.05,
  kings_threshold = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \code{qc_report_indiv}}

\item{type}{the type of plot (\code{scatter},\code{relatedness})}

\item{miss_threshold}{a threshold for the accepted rate of missingness within
individuals}

\item{kings_threshold}{an optional numeric, a threshold of relatedness for
the sample}

\item{...}{not currently used.}
}
\value{
a \code{ggplot2} object
}
\description{
For \code{qc_report_indiv}, the following types of plots are available:
\itemize{
\item \code{scatter}: a plot of missingness and observed heterozygosity within
individuals.
\item \code{relatedness}: a histogram of paired kinship coefficients
}
}
\details{
\code{autoplot} produces simple plots to quickly inspect an object. They are not
customisable; we recommend that you use \code{ggplot2} to produce publication
ready plots.
}
\examples{
# Create a gen_tibble of lobster genotypes
bed_file <-
  system.file("extdata", "lobster", "lobster.bed", package = "tidypopgen")
example_gt <- gen_tibble(bed_file,
  backingfile = tempfile("lobsters"),
  quiet = TRUE
)

# Create QC report for individuals
indiv_report <- example_gt \%>\% qc_report_indiv()

# Autoplot missingness and observed heterozygosity
autoplot(indiv_report, type = "scatter", miss_threshold = 0.1)

# Create QC report with kinship filtering
indiv_report_rel <-
  example_gt \%>\% qc_report_indiv(kings_threshold = "second")

# Autoplot relatedness
autoplot(indiv_report_rel, type = "relatedness", kings_threshold = "second")

}
