% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select}
\alias{select}
\title{Select bands from ee$Image or ee$ImageCollection}
\arguments{
\item{.data}{tidyee class object containing ee$ImageCollection or ee$Image}

\item{...}{one or more quoted or unquoted expressions separated by commas.}
}
\value{
tidyee class object with specified (...) bands selected
}
\description{
Select bands from ee$Image or ee$ImageCollection
}
\examples{
\dontrun{
library(tidyrgee)
ee_Initialize()
modis_ic <- ee$ImageCollection("MODIS/006/MOD13Q1")
modis_ic_tidy <- as_tidyee(modis_ic)

# select NDVI band
modis_ndvi <- modis_ic_tidy |>
   select("NDVI")

# select NDVI band, but change band to new name
modis_ndvi_renamed <- modis_ic_tidy |>
   select(ndvi_new= "NDVI")


}
}
\seealso{
\code{\link[dplyr]{select}} for information about select on normal data tables.
}
