% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bscpp}
\alias{bscpp}
\title{B-Spline Basis for Polynomial Splines}
\usage{
bscpp(
  x = NA_real_,
  df = NA_integer_,
  knots = NA_real_,
  degree = 3L,
  intercept = 0L,
  boundary_knots = NA_real_,
  warn_outside = 1L
)
}
\arguments{
\item{x}{A numeric vector representing the predictor variable.}

\item{df}{Degrees of freedom, specifying the number of columns in the
basis matrix. If \code{df} is provided, the function automatically
selects \code{df - degree - intercept} internal knots based on
appropriate quantiles of \code{x}, ignoring any missing values.}

\item{knots}{A numeric vector specifying the internal breakpoints
that define the spline. If not provided, \code{df} must be specified.}

\item{degree}{An integer specifying the degree of the piecewise
polynomial. The default value is \code{3}, which corresponds to
cubic splines.}

\item{intercept}{A logical value indicating whether to include an
intercept in the basis. The default is \code{FALSE}.}

\item{boundary_knots}{A numeric vector of length 2 specifying the
boundary points where the B-spline basis should be anchored.
If not supplied, the default is the range of non-missing values
in \code{x}.}

\item{warn_outside}{A logical value indicating whether a warning
should be issued if any values of \code{x} fall outside the
specified boundary knots.}
}
\value{
A matrix with dimensions \code{c(length(x), df)}. If
\code{df} is provided, the matrix will have \code{df} columns.
Alternatively, if \code{knots} are supplied, the number of columns
will be \code{length(knots) + degree + intercept}. The matrix
contains attributes that correspond to the arguments
passed to the \code{bscpp} function.
}
\description{
Computes the B-spline basis matrix for a given polynomial
spline.
}
\examples{

bscpp(women$height, df = 5)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
