% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_send_sticker}
\alias{whapi_send_sticker}
\title{Send a STICKER via Whapi.Cloud (file, url, or base64)}
\usage{
whapi_send_sticker(
  to,
  sticker,
  type = c("file", "url", "base64"),
  token = Sys.getenv("WHAPI_TOKEN", unset = ""),
  timeout = 30,
  verbose = TRUE
)
}
\arguments{
\item{to}{Character(1). WhatsApp target (E.164 digits only, no "+") or chat id.}

\item{sticker}{Character(1).
\itemize{
\item If type = "file": local \code{.webp} file path (will be read and encoded to Base64 data-URI).
\item If type = "url": direct http(s) URL to the \code{.webp} file.
\item If type = "base64": full data-URI string (e.g. "data:image/webp;name=st.webp;base64,<...>").
}}

\item{type}{One of c("file","url","base64"). Default = "file".}

\item{token}{Bearer token (env var WHAPI_TOKEN if not provided).}

\item{timeout}{Numeric. Request timeout (seconds). Default 30.}

\item{verbose}{Logical. Print CLI messages? Default TRUE.}
}
\value{
tibble with id, to, status, timestamp, and raw response in \code{resp}.
}
\description{
Sends a WhatsApp sticker via \code{POST /messages/sticker}.
The sticker must be in WebP format (\code{image/webp}).
}
\examples{
\dontrun{
Sys.setenv(WHAPI_TOKEN = "your_token_here")

# 1) Local file
 whapi_send_sticker("558191812121",
   sticker = "sticker.webp", type = "file")

# 2) Remote URL
 whapi_send_sticker("558191812121",
   sticker = "https://example.com/condepe.webp", type = "url")

# 3) Pre-encoded Base64
 b64 <- openssl::base64_encode(readBin("sticker.webp","raw",file.info("sticker.webp")$size))
 data_uri <- sprintf("data:image/webp;name=\%s;base64,\%s", basename("sticker.webp"), b64)
 whapi_send_sticker("558191812121", sticker = data_uri, type = "base64")
 }
}
