## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  out.width = "100%"
)

## ----datagen------------------------------------------------------------------
library(netseer)
library(igraph)

set.seed(2024)
edge_increase_val <- new_nodes_val <- del_edge_val <- 0.1
graphlist <- list()
graphlist[[1]] <- gr <-  igraph::sample_pa(5, directed = FALSE)
for(i in 2:15){
gr <-  generate_graph_exp(gr,
                          del_edge = del_edge_val,
                          new_nodes = new_nodes_val,
                          edge_increase = edge_increase_val )
graphlist[[i]] <- gr
}

## ----plotdata-----------------------------------------------------------------
plot(graphlist[[1]])

plot(graphlist[[8]])

plot(graphlist[[15]])

## ----grpred1------------------------------------------------------------------
grpred <- predict_graph(graphlist[1:15],h = 1)
grpred

plot(grpred$graph_mean)
ecount(grpred$graph_mean)
vcount(grpred$graph_mean)

## ----grpred2------------------------------------------------------------------
grpred2 <- predict_graph(graphlist[1:15], h = 2)
grpred2

plot(grpred2$graph_mean)
ecount(grpred2$graph_mean)
vcount(grpred2$graph_mean)

## ----grpred3------------------------------------------------------------------
grpred3 <- predict_graph(graphlist[1:15], h = 3)
grpred3

plot(grpred3$graph_mean)
ecount(grpred3$graph_mean)
vcount(grpred3$graph_mean)

