/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.clusterers.RandomizableClusterer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class sIB
extends RandomizableClusterer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -8652125897352654213L;
    private Instances m_data;
    private int m_numCluster = 2;
    private int m_numRestarts = 5;
    private boolean m_verbose = false;
    private boolean m_uniformPrior = true;
    private int m_maxLoop = 100;
    private int m_minChange = 0;
    private ReplaceMissingValues m_replaceMissing;
    private int m_numInstances;
    private int m_numAttributes;
    private Random random;
    private Partition bestT;
    private Input input;

    @Override
    public void buildClusterer(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_replaceMissing = new ReplaceMissingValues();
        Instances instances = new Instances(data);
        instances.setClassIndex(-1);
        this.m_replaceMissing.setInputFormat(instances);
        data = Filter.useFilter(instances, this.m_replaceMissing);
        instances = null;
        this.m_data = data;
        this.m_numInstances = this.m_data.numInstances();
        this.m_numAttributes = this.m_data.numAttributes();
        this.random = new Random(this.getSeed());
        this.input = this.sIB_ProcessInput();
        this.bestT = new Partition();
        double bestL = Double.NEGATIVE_INFINITY;
        int k = 0;
        while (k < this.m_numRestarts) {
            if (this.m_verbose) {
                System.out.format("restart number %s...\n", k);
            }
            Partition tmpT = this.sIB_InitT(this.input);
            if ((tmpT = this.sIB_OptimizeT(tmpT, this.input)).L > bestL) {
                tmpT.copy(this.bestT);
                bestL = this.bestT.L;
            }
            if (this.m_verbose) {
                System.out.println("\nPartition status : ");
                System.out.println("------------------");
                System.out.println(String.valueOf(tmpT.toString()) + "\n");
            }
            ++k;
        }
        if (this.m_verbose) {
            System.out.println("\nBest Partition");
            System.out.println("===============");
            System.out.println(this.bestT.toString());
        }
        this.m_data = new Instances(this.m_data, 0);
    }

    @Override
    public int clusterInstance(Instance instance) throws Exception {
        double prior = 1.0 / this.input.sumVals;
        double[] distances = new double[this.m_numCluster];
        int i = 0;
        while (i < this.m_numCluster) {
            double Pnew = this.bestT.Pt[i] + prior;
            double pi1 = prior / Pnew;
            double pi2 = this.bestT.Pt[i] / Pnew;
            distances[i] = Pnew * this.JS(instance, i, pi1, pi2);
            ++i;
        }
        return Utils.minIndex(distances);
    }

    private Input sIB_ProcessInput() {
        int j;
        double valSum = 0.0;
        int i = 0;
        while (i < this.m_numInstances) {
            valSum = 0.0;
            int v = 0;
            while (v < this.m_data.instance(i).numValues()) {
                valSum += this.m_data.instance(i).valueSparse(v);
                ++v;
            }
            if (valSum <= 0.0) {
                if (this.m_verbose) {
                    System.out.format("Instance %s sum of value = %s <= 0, removed.\n", i, valSum);
                }
                this.m_data.delete(i);
                --this.m_numInstances;
            }
            ++i;
        }
        Input input = new Input();
        input.Py_x = this.getTransposedNormedMatrix(this.m_data);
        if (this.m_uniformPrior) {
            input.Pyx = input.Py_x.copy();
            this.normalizePrior(this.m_data);
        } else {
            input.Pyx = this.getTransposedMatrix(this.m_data);
        }
        input.sumVals = this.getTotalSum(this.m_data);
        input.Pyx.timesEquals(1.0 / input.sumVals);
        input.Px = new double[this.m_numInstances];
        int i2 = 0;
        while (i2 < this.m_numInstances) {
            j = 0;
            while (j < this.m_numAttributes) {
                double[] dArray = input.Px;
                int n = i2;
                dArray[n] = dArray[n] + input.Pyx.get(j, i2);
                ++j;
            }
            ++i2;
        }
        input.Py = new double[this.m_numAttributes];
        i2 = 0;
        while (i2 < input.Pyx.getRowDimension()) {
            j = 0;
            while (j < input.Pyx.getColumnDimension()) {
                double[] dArray = input.Py;
                int n = i2;
                dArray[n] = dArray[n] + input.Pyx.get(i2, j);
                ++j;
            }
            ++i2;
        }
        this.MI(input.Pyx, input);
        return input;
    }

    private Partition sIB_InitT(Input input) {
        Partition T = new Partition();
        int avgSize = (int)Math.ceil((double)this.m_numInstances / (double)this.m_numCluster);
        ArrayList<Integer> permInstsIdx = new ArrayList<Integer>();
        ArrayList<Integer> unassigned = new ArrayList<Integer>();
        int i = 0;
        while (i < this.m_numInstances) {
            unassigned.add(i);
            ++i;
        }
        while (unassigned.size() != 0) {
            int t = this.random.nextInt(unassigned.size());
            permInstsIdx.add((Integer)unassigned.get(t));
            unassigned.remove(t);
        }
        i = 0;
        while (i < this.m_numCluster) {
            int r2 = avgSize > permInstsIdx.size() ? permInstsIdx.size() : avgSize;
            int j = 0;
            while (j < r2) {
                ((Partition)T).Pt_x[((Integer)permInstsIdx.get((int)j)).intValue()] = i;
                ++j;
            }
            j = 0;
            while (j < r2) {
                permInstsIdx.remove(0);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numCluster) {
            ArrayList indices = T.find(i);
            int j = 0;
            while (j < indices.size()) {
                double[] dArray = T.Pt;
                int n = i;
                dArray[n] = dArray[n] + input.Px[(Integer)indices.get(j)];
                ++j;
            }
            double[][] mArray = input.Pyx.getArray();
            int j2 = 0;
            while (j2 < this.m_numAttributes) {
                double sum = 0.0;
                int k = 0;
                while (k < indices.size()) {
                    sum += mArray[j2][(Integer)indices.get(k)];
                    ++k;
                }
                T.Py_t.set(j2, i, sum /= T.Pt[i]);
                ++j2;
            }
            ++i;
        }
        if (this.m_verbose) {
            System.out.println("Initializing...");
        }
        return T;
    }

    private Partition sIB_OptimizeT(Partition tmpT, Input input) {
        boolean done = false;
        int change = 0;
        int loopCounter = 0;
        if (this.m_verbose) {
            System.out.println("Optimizing...");
            System.out.println("-------------");
        }
        while (!done) {
            change = 0;
            int i = 0;
            while (i < this.m_numInstances) {
                int old_t = tmpT.Pt_x[i];
                if (tmpT.size(old_t) == 1) {
                    if (this.m_verbose) {
                        System.out.format("cluster %s has only 1 doc remain\n", old_t);
                    }
                } else {
                    this.reduce_x(i, old_t, tmpT, input);
                    int new_t = this.clusterInstance(i, input, tmpT);
                    if (new_t != old_t) {
                        ++change;
                        this.updateAssignment(i, new_t, tmpT, input.Px[i], input.Py_x);
                    }
                }
                ++i;
            }
            Partition partition = tmpT;
            partition.counter = partition.counter + change;
            if (this.m_verbose) {
                System.out.format("iteration %s , changes : %s\n", loopCounter, change);
            }
            done = this.checkConvergence(change, loopCounter);
            ++loopCounter;
        }
        tmpT.L = this.sIB_local_MI(tmpT.Py_t, tmpT.Pt);
        if (this.m_verbose) {
            System.out.format("score (L) : %s \n", Utils.doubleToString(tmpT.L, 4));
        }
        return tmpT;
    }

    private void reduce_x(int instIdx, int t, Partition T, Input input) {
        ArrayList indices = T.find(t);
        double sum = 0.0;
        int i = 0;
        while (i < indices.size()) {
            if ((Integer)indices.get(i) != instIdx) {
                sum += input.Px[(Integer)indices.get(i)];
            }
            ++i;
        }
        ((Partition)T).Pt[t] = sum;
        if (T.Pt[t] < 0.0) {
            System.out.format("Warning: probability < 0 (%s)\n", T.Pt[t]);
            ((Partition)T).Pt[t] = 0.0;
        }
        double[][] mArray = input.Pyx.getArray();
        int i2 = 0;
        while (i2 < this.m_numAttributes) {
            sum = 0.0;
            int j = 0;
            while (j < indices.size()) {
                if ((Integer)indices.get(j) != instIdx) {
                    sum += mArray[i2][(Integer)indices.get(j)];
                }
                ++j;
            }
            T.Py_t.set(i2, t, sum / T.Pt[t]);
            ++i2;
        }
    }

    private void updateAssignment(int instIdx, int newt, Partition T, double Px, Matrix Py_x) {
        ((Partition)T).Pt_x[instIdx] = newt;
        double mass = Px + T.Pt[newt];
        double pi1 = Px / mass;
        double pi2 = T.Pt[newt] / mass;
        int i = 0;
        while (i < this.m_numAttributes) {
            T.Py_t.set(i, newt, pi1 * Py_x.get(i, instIdx) + pi2 * T.Py_t.get(i, newt));
            ++i;
        }
        ((Partition)T).Pt[newt] = mass;
    }

    private boolean checkConvergence(int change, int loops) {
        if (change <= this.m_minChange || loops >= this.m_maxLoop) {
            if (this.m_verbose) {
                System.out.format("\nsIB converged after %s iterations with %s changes\n", loops, change);
            }
            return true;
        }
        return false;
    }

    private int clusterInstance(int instIdx, Input input, Partition T) {
        double[] distances = new double[this.m_numCluster];
        int i = 0;
        while (i < this.m_numCluster) {
            double Pnew = input.Px[instIdx] + T.Pt[i];
            double pi1 = input.Px[instIdx] / Pnew;
            double pi2 = T.Pt[i] / Pnew;
            distances[i] = Pnew * this.JS(instIdx, input, T, i, pi1, pi2);
            ++i;
        }
        return Utils.minIndex(distances);
    }

    private double JS(int instIdx, Input input, Partition T, int t, double pi1, double pi2) {
        if (Math.min(pi1, pi2) <= 0.0) {
            System.out.format("Warning: zero or negative weights in JS calculation! (pi1 %s, pi2 %s)\n", pi1, pi2);
            return 0.0;
        }
        Instance inst = this.m_data.instance(instIdx);
        double kl1 = 0.0;
        double kl2 = 0.0;
        double tmp = 0.0;
        int i = 0;
        while (i < inst.numValues()) {
            tmp = input.Py_x.get(inst.index(i), instIdx);
            if (tmp != 0.0) {
                kl1 += tmp * Math.log(tmp / (tmp * pi1 + pi2 * T.Py_t.get(inst.index(i), t)));
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numAttributes) {
            tmp = T.Py_t.get(i, t);
            if (tmp != 0.0) {
                kl2 += tmp * Math.log(tmp / (input.Py_x.get(i, instIdx) * pi1 + pi2 * tmp));
            }
            ++i;
        }
        return pi1 * kl1 + pi2 * kl2;
    }

    private double JS(Instance inst, int t, double pi1, double pi2) {
        if (Math.min(pi1, pi2) <= 0.0) {
            System.out.format("Warning: zero or negative weights in JS calculation! (pi1 %s, pi2 %s)\n", pi1, pi2);
            return 0.0;
        }
        double sum = Utils.sum(inst.toDoubleArray());
        double kl1 = 0.0;
        double kl2 = 0.0;
        double tmp = 0.0;
        int i = 0;
        while (i < inst.numValues()) {
            tmp = inst.valueSparse(i) / sum;
            if (tmp != 0.0) {
                kl1 += tmp * Math.log(tmp / (tmp * pi1 + pi2 * this.bestT.Py_t.get(inst.index(i), t)));
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numAttributes) {
            tmp = this.bestT.Py_t.get(i, t);
            if (tmp != 0.0) {
                kl2 += tmp * Math.log(tmp / (inst.value(i) * pi1 / sum + pi2 * tmp));
            }
            ++i;
        }
        return pi1 * kl1 + pi2 * kl2;
    }

    private double sIB_local_MI(Matrix m, double[] Pt) {
        double Hy = 0.0;
        double Ht = 0.0;
        int i = 0;
        while (i < Pt.length) {
            Ht += Pt[i] * Math.log(Pt[i]);
            ++i;
        }
        Ht = -Ht;
        i = 0;
        while (i < this.m_numAttributes) {
            double Py = 0.0;
            int j = 0;
            while (j < this.m_numCluster) {
                Py += m.get(i, j) * Pt[j];
                ++j;
            }
            if (Py != 0.0) {
                Hy += Py * Math.log(Py);
            }
            ++i;
        }
        Hy = -Hy;
        double Hyt = 0.0;
        double tmp = 0.0;
        int i2 = 0;
        while (i2 < m.getRowDimension()) {
            int j = 0;
            while (j < m.getColumnDimension()) {
                tmp = m.get(i2, j);
                if (tmp != 0.0 && Pt[j] != 0.0) {
                    Hyt += (tmp *= Pt[j]) * Math.log(tmp);
                }
                ++j;
            }
            ++i2;
        }
        return Hy + Ht + Hyt;
    }

    private double getTotalSum(Instances data) {
        double sum = 0.0;
        int i = 0;
        while (i < data.numInstances()) {
            int v = 0;
            while (v < data.instance(i).numValues()) {
                sum += data.instance(i).valueSparse(v);
                ++v;
            }
            ++i;
        }
        return sum;
    }

    private Matrix getTransposedMatrix(Instances data) {
        double[][] temp = new double[data.numAttributes()][data.numInstances()];
        int i = 0;
        while (i < data.numInstances()) {
            Instance inst = data.instance(i);
            int v = 0;
            while (v < inst.numValues()) {
                temp[inst.index((int)v)][i] = inst.valueSparse(v);
                ++v;
            }
            ++i;
        }
        Matrix My_x = new Matrix(temp);
        return My_x;
    }

    private void normalizePrior(Instances data) {
        int i = 0;
        while (i < data.numInstances()) {
            this.normalizeInstance(data.instance(i));
            ++i;
        }
    }

    private Instance normalizeInstance(Instance inst) {
        double[] vals = inst.toDoubleArray();
        double sum = Utils.sum(vals);
        int i = 0;
        while (i < vals.length) {
            int n = i++;
            vals[n] = vals[n] / sum;
        }
        return new Instance(inst.weight(), vals);
    }

    private Matrix getTransposedNormedMatrix(Instances data) {
        Matrix matrix = new Matrix(data.numAttributes(), data.numInstances());
        int i = 0;
        while (i < data.numInstances()) {
            double[] vals = data.instance(i).toDoubleArray();
            double sum = Utils.sum(vals);
            int v = 0;
            while (v < vals.length) {
                int n = v;
                vals[n] = vals[n] / sum;
                matrix.set(v, i, vals[v]);
                ++v;
            }
            ++i;
        }
        return matrix;
    }

    private void MI(Matrix m, Input input) {
        int minDimSize;
        int n = minDimSize = m.getColumnDimension() < m.getRowDimension() ? m.getColumnDimension() : m.getRowDimension();
        if (minDimSize < 2) {
            System.err.println("Warning : This is not a JOINT distribution");
            input.Hx = this.Entropy(m);
            input.Hy = 0.0;
            input.Ixy = 0.0;
            return;
        }
        input.Hx = this.Entropy(input.Px);
        input.Hy = this.Entropy(input.Py);
        double entropy = input.Hx + input.Hy;
        int i = 0;
        while (i < this.m_numInstances) {
            Instance inst = this.m_data.instance(i);
            int v = 0;
            while (v < inst.numValues()) {
                double tmp = m.get(inst.index(v), i);
                if (!(tmp <= 0.0)) {
                    entropy += tmp * Math.log(tmp);
                }
                ++v;
            }
            ++i;
        }
        input.Ixy = entropy;
        if (this.m_verbose) {
            System.out.println("Ixy = " + input.Ixy);
        }
    }

    private double Entropy(double[] probs) {
        int i = 0;
        while (i < probs.length) {
            if (probs[i] <= 0.0) {
                if (this.m_verbose) {
                    System.out.println("Warning: Negative probability.");
                }
                return Double.NaN;
            }
            ++i;
        }
        if (Math.abs(Utils.sum(probs) - 1.0) >= 1.0E-6) {
            if (this.m_verbose) {
                System.out.println("Warning: Not normalized.");
            }
            return Double.NaN;
        }
        double mi = 0.0;
        int i2 = 0;
        while (i2 < probs.length) {
            mi += probs[i2] * Math.log(probs[i2]);
            ++i2;
        }
        mi = -mi;
        return mi;
    }

    private double Entropy(Matrix p) {
        double mi = 0.0;
        int i = 0;
        while (i < p.getRowDimension()) {
            int j = 0;
            while (j < p.getColumnDimension()) {
                if (p.get(i, j) != 0.0) {
                    mi += p.get(i, j) + Math.log(p.get(i, j));
                }
                ++j;
            }
            ++i;
        }
        mi = -mi;
        return mi;
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String optionString = Utils.getOption('I', options);
        if (optionString.length() != 0) {
            this.setMaxIterations(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('M', options)).length() != 0) {
            this.setMinChange(new Integer(optionString));
        }
        if ((optionString = Utils.getOption('N', options)).length() != 0) {
            this.setNumClusters(Integer.parseInt(optionString));
        }
        if ((optionString = Utils.getOption('R', options)).length() != 0) {
            this.setNumRestarts(new Integer(optionString));
        }
        this.setNotUnifyNorm(Utils.getFlag('U', options));
        this.setDebug(Utils.getFlag('V', options));
        super.setOptions(options);
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tmaximum number of iterations\n\t(default 100).", "I", 1, "-I <num>"));
        result.addElement(new Option("\tminimum number of changes in a single iteration\n\t(default 0).", "M", 1, "-M <num>"));
        result.addElement(new Option("\tnumber of clusters.\n\t(default 2).", "N", 1, "-N <num>"));
        result.addElement(new Option("\tnumber of restarts.\n\t(default 5).", "R", 1, "-R <num>"));
        result.addElement(new Option("\tset not to normalize the data\n\t(default true).", "U", 0, "-U"));
        result.addElement(new Option("\tset to output debug info\n\t(default false).", "V", 0, "-V"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-I");
        result.add("" + this.getMaxIterations());
        result.add("-M");
        result.add("" + this.getMinChange());
        result.add("-N");
        result.add("" + this.getNumClusters());
        result.add("-R");
        result.add("" + this.getNumRestarts());
        if (this.getNotUnifyNorm()) {
            result.add("-U");
        }
        if (this.getDebug()) {
            result.add("-V");
        }
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public String debugTipText() {
        return "If set to true, clusterer may output additional info to the console.";
    }

    public void setDebug(boolean v) {
        this.m_verbose = v;
    }

    public boolean getDebug() {
        return this.m_verbose;
    }

    public String maxIterationsTipText() {
        return "set maximum number of iterations (default 100)";
    }

    public void setMaxIterations(int i) {
        this.m_maxLoop = i;
    }

    public int getMaxIterations() {
        return this.m_maxLoop;
    }

    public String minChangeTipText() {
        return "set minimum number of changes (default 0)";
    }

    public void setMinChange(int m) {
        this.m_minChange = m;
    }

    public int getMinChange() {
        return this.m_minChange;
    }

    public String numClustersTipText() {
        return "set number of clusters (default 2)";
    }

    public void setNumClusters(int n) {
        this.m_numCluster = n;
    }

    public int getNumClusters() {
        return this.m_numCluster;
    }

    @Override
    public int numberOfClusters() {
        return this.m_numCluster;
    }

    public String numRestartsTipText() {
        return "set number of restarts (default 5)";
    }

    public void setNumRestarts(int i) {
        this.m_numRestarts = i;
    }

    public int getNumRestarts() {
        return this.m_numRestarts;
    }

    public String notUnifyNormTipText() {
        return "set whether to normalize each instance to a unify prior probability (eg. 1).";
    }

    public void setNotUnifyNorm(boolean b) {
        this.m_uniformPrior = !b;
    }

    public boolean getNotUnifyNorm() {
        return !this.m_uniformPrior;
    }

    public String globalInfo() {
        return "Cluster data using the sequential information bottleneck algorithm.\n\nNote: only hard clustering scheme is supported. sIB assign for each instance the cluster that have the minimum cost/distance to the instance. The trade-off beta is set to infinite so 1/beta is zero.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Noam Slonim and Nir Friedman and Naftali Tishby");
        result.setValue(TechnicalInformation.Field.YEAR, "2002");
        result.setValue(TechnicalInformation.Field.TITLE, "Unsupervised document classification using sequential information maximization");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the 25th International ACM SIGIR Conference on Research and Development in Information Retrieval");
        result.setValue(TechnicalInformation.Field.PAGES, "129-136");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        return result;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("\nsIB\n===\n");
        text.append("\nNumber of clusters: " + this.m_numCluster + "\n");
        int j = 0;
        while (j < this.m_numCluster) {
            text.append("\nCluster: " + j + " Size : " + this.bestT.size(j) + " Prior probability: " + Utils.doubleToString(this.bestT.Pt[j], 4) + "\n\n");
            int i = 0;
            while (i < this.m_numAttributes) {
                text.append("Attribute: " + this.m_data.attribute(i).name() + "\n");
                text.append("Probability given the cluster = " + Utils.doubleToString(this.bestT.Py_t.get(i, j), 4) + "\n");
                ++i;
            }
            ++j;
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5538 $");
    }

    public static void main(String[] argv) {
        sIB.runClusterer(new sIB(), argv);
    }

    private class Input
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -2464453171263384037L;
        private double[] Px;
        private double[] Py;
        private Matrix Pyx;
        private Matrix Py_x;
        private double Ixy;
        private double Hy;
        private double Hx;
        private double sumVals;

        private Input() {
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5538 $");
        }
    }

    private class Partition
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 4957194978951259946L;
        private int[] Pt_x;
        private double[] Pt;
        private double L;
        private int counter;
        private Matrix Py_t;

        public Partition() {
            this.Pt_x = new int[sIB.this.m_numInstances];
            int i = 0;
            while (i < sIB.this.m_numInstances) {
                this.Pt_x[i] = -1;
                ++i;
            }
            this.Pt = new double[sIB.this.m_numCluster];
            this.Py_t = new Matrix(sIB.this.m_numAttributes, sIB.this.m_numCluster);
            this.counter = 0;
        }

        private ArrayList<Integer> find(int i) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            int x = 0;
            while (x < this.Pt_x.length) {
                if (this.Pt_x[x] == i) {
                    indices.add(x);
                }
                ++x;
            }
            return indices;
        }

        private int size(int i) {
            int count = 0;
            int x = 0;
            while (x < this.Pt_x.length) {
                if (this.Pt_x[x] == i) {
                    ++count;
                }
                ++x;
            }
            return count;
        }

        private void copy(Partition T) {
            if (T == null) {
                T = new Partition();
            }
            System.arraycopy(this.Pt_x, 0, T.Pt_x, 0, this.Pt_x.length);
            System.arraycopy(this.Pt, 0, T.Pt, 0, this.Pt.length);
            T.L = this.L;
            T.counter = this.counter;
            double[][] mArray = this.Py_t.getArray();
            double[][] tgtArray = T.Py_t.getArray();
            int i = 0;
            while (i < mArray.length) {
                System.arraycopy(mArray[i], 0, tgtArray[i], 0, mArray[0].length);
                ++i;
            }
        }

        public String toString() {
            StringBuffer text = new StringBuffer();
            text.append("score (L) : " + Utils.doubleToString(this.L, 4) + "\n");
            text.append("number of changes : " + this.counter + "\n");
            int i = 0;
            while (i < sIB.this.m_numCluster) {
                text.append("\nCluster " + i + "\n");
                text.append("size : " + this.size(i) + "\n");
                text.append("prior prob : " + Utils.doubleToString(this.Pt[i], 4) + "\n");
                ++i;
            }
            return text.toString();
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5538 $");
        }
    }
}

