/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common;

import keel.Algorithms.Neural_Networks.NNEP_Common.INeuralNetSpecies;
import keel.Algorithms.Neural_Networks.NNEP_Common.NeuralNetIndividual;
import keel.Algorithms.Neural_Networks.NNEP_Common.initiators.IInitiator;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.ILayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.INeuralNet;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.InputNeuron;
import net.sf.jclec.ISpecies;
import net.sf.jclec.base.AbstractCreator;
import org.apache.commons.lang.builder.EqualsBuilder;

public class NeuralNetCreator<I extends NeuralNetIndividual>
extends AbstractCreator<I> {
    private static final long serialVersionUID = -2638928425169895614L;
    protected INeuralNetSpecies<I> species;
    protected IInitiator[] initiators;

    @Override
    protected void prepareCreation() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof INeuralNetSpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (INeuralNetSpecies)spc;
        this.initiators = new IInitiator[this.species.getNOfHiddenLayers() + 1];
        try {
            for (int i = 0; i < this.species.getNOfHiddenLayers(); ++i) {
                this.initiators[i] = (IInitiator)Class.forName(this.species.getHiddenLayerInitiator(i)).newInstance();
                this.initiators[i].contextualize(this.context);
            }
            this.initiators[this.species.getNOfHiddenLayers()] = (IInitiator)Class.forName(this.species.getOutputLayerInitiator()).newInstance();
            this.initiators[this.species.getNOfHiddenLayers()].contextualize(this.context);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void createNext() {
        INeuralNet genotype = this.species.createGenotype();
        this.initiateNeuralNet(genotype);
        I individual = this.species.createIndividual(genotype);
        this.createdBuffer.add(individual);
    }

    private void initiateNeuralNet(INeuralNet neuralNet) {
        ILayer<InputNeuron> previousLayer = neuralNet.getInputLayer();
        for (int i = 0; i < neuralNet.getNofhlayers(); ++i) {
            this.initiators[i].initiate(neuralNet.getHlayer(i), previousLayer, i, 0);
            previousLayer = neuralNet.getHlayer(i);
        }
        this.initiators[neuralNet.getNofhlayers()].initiate(neuralNet.getOutputLayer(), previousLayer, neuralNet.getNofhlayers(), 0);
    }

    public boolean equals(Object other) {
        if (other instanceof NeuralNetCreator) {
            NeuralNetCreator nother = (NeuralNetCreator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.randgen, nother.randgen);
            return eb.isEquals();
        }
        return false;
    }
}

