/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.exprtree;

import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import net.sf.jclec.IData;
import net.sf.jclec.exprtree.IContext;
import net.sf.jclec.exprtree.IPrimitive;

public class ExprTree
implements IData {
    protected static final XmlFormat<ExprTree> EXPR_TREE_XML = new XmlFormat<ExprTree>(ExprTree.class){

        @Override
        public void format(ExprTree source, XmlElement xml) {
            xml.setAttribute("size", source.blockIndex);
            IPrimitive[] iPrimitiveArray = source.blocks;
            int n = 0;
            int n2 = iPrimitiveArray.length;
            while (n < n2) {
                IPrimitive block = iPrimitiveArray[n];
                xml.add(block, "block");
                ++n;
            }
        }

        @Override
        public ExprTree parse(XmlElement xml) {
            int size = xml.getAttribute("size", 0);
            IPrimitive[] blocks = new IPrimitive[size];
            int i = 0;
            while (i < size) {
                blocks[i] = (IPrimitive)xml.get("block");
                ++i;
            }
            ExprTree result = new ExprTree();
            result.blockIndex = size;
            result.blocks = blocks;
            return result;
        }

        @Override
        public String defaultName() {
            return "expr-tree";
        }
    };
    private static final long serialVersionUID = -6257654283422181797L;
    private IPrimitive[] blocks = new IPrimitive[10];
    private int blockIndex = 0;

    public void addBlock(IPrimitive block) {
        if (this.blockIndex == this.blocks.length) {
            IPrimitive[] aux = new IPrimitive[2 * this.blockIndex];
            int i = 0;
            while (i < this.blockIndex) {
                aux[i] = this.blocks[i];
                ++i;
            }
            this.blocks = aux;
        }
        this.blocks[this.blockIndex++] = block;
    }

    public IPrimitive getBlock(int blockIndex) {
        return this.blocks[blockIndex];
    }

    public void setBlock(IPrimitive block, int blockIndex) {
        this.blocks[blockIndex] = block;
    }

    public int size() {
        return this.blockIndex;
    }

    public ExprTree copy() {
        IPrimitive[] codeCopy = new IPrimitive[this.blocks.length];
        int i = 0;
        while (i < this.blockIndex) {
            codeCopy[i] = this.blocks[i].copy();
            ++i;
        }
        ExprTree result = new ExprTree();
        result.blockIndex = this.blockIndex;
        result.blocks = codeCopy;
        return result;
    }

    public int subTree(int blockIndex) {
        int resultIndex = blockIndex;
        int aux = 0;
        do {
            aux += this.blocks[resultIndex].argumentTypes().length;
            ++resultIndex;
        } while (aux-- != 0);
        return resultIndex;
    }

    public Object evaluate(IContext context) {
        int i = this.blockIndex;
        while (i > 0) {
            this.blocks[--i].evaluate(context);
        }
        return context.pop();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("(");
        int i = 0;
        while (i < this.blockIndex) {
            sb.append(this.blocks[i]);
            if (i != this.blockIndex - 1) {
                sb.append(" ");
            } else {
                sb.append(")");
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof ExprTree) {
            ExprTree cother = (ExprTree)other;
            if (this.blockIndex == cother.blockIndex) {
                int i = 0;
                while (i < this.blockIndex) {
                    if (!this.blocks[i].equals(cother.blocks[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

