/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.graph.LaTeXTool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class VariablePanel
extends JPanel {
    Object[] variables;
    List<JTextField> jtlVar = new Vector<JTextField>();
    Element oldElement = null;

    public VariablePanel(Set<String> v) {
        this.variables = v.toArray();
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu";
        for (Object s : this.variables) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        this.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.jtlVar = new Vector<JTextField>();
        for (Object s : this.variables) {
            JTextField jt = new JTextField("0");
            if (s.equals("\u03b5")) {
                jt.setText("" + Configuration.getInstance().getGeneralConfig().getEpsilon());
            } else {
                jt.setText("" + Configuration.getInstance().getGeneralConfig().getVariable(s.toString()));
            }
            this.add((Component)new JLabel("Value for '" + s + "':"), cc.xy(2, row));
            this.add((Component)jt, cc.xy(4, row));
            this.jtlVar.add(jt);
            row += 2;
        }
    }

    public String getVariables() {
        if (this.jtlVar.size() > 0) {
            String s = "list(";
            for (int i = 0; i < this.variables.length; ++i) {
                s = s + LaTeXTool.UTF2LaTeX(this.variables[i].toString().charAt(0)) + " = c(" + this.jtlVar.get(i).getText() + ")";
                if (i == this.variables.length - 1) continue;
                s = s + ", ";
            }
            return s + ")";
        }
        return "";
    }

    public Element getConfigNode(Document document) {
        Element e = document.createElement("variablePanel");
        if (this.oldElement != null) {
            NamedNodeMap attributes = this.oldElement.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                e.setAttribute(attributes.item(j).getNodeName(), attributes.item(j).getNodeValue());
            }
        }
        for (int i = 0; i < this.jtlVar.size(); ++i) {
            e.setAttribute(this.variables[i].toString(), this.jtlVar.get(i).getText());
        }
        return e;
    }

    public void loadConfig(Element e) {
        this.oldElement = e;
        for (int i = 0; i < this.jtlVar.size(); ++i) {
            String value = e.getAttribute(this.variables[i].toString());
            if (value == "") {
                value = "0.5";
            }
            this.jtlVar.get(i).setText(value);
        }
    }
}

