/*
 * Decompiled with CFR 0.152.
 */
package mrmc.core;

import javax.swing.JFrame;
import mrmc.chart.exploreExpSize;
import mrmc.core.DBRecord;
import mrmc.core.MRMC;
import mrmc.core.commandStartFunction;
import mrmc.gui.SizePanel;
import roemetz.core.RoeMetz;
import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.probdist.FisherFDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdist.StudentDist;

public class StatTest {
    DBRecord DBRecordStat;
    DBRecord DBRecordSize;
    private final int INFINITY = 500;
    private final double ZERO = 1.0E-300;
    private static final int NO_MLE = 0;
    public double tStatEst = 0.0;
    public double effSize;
    public double sigLevel;
    public double tStatCalc;
    public double DF_BDG;
    public double DF_Hillis;
    public double pValNormal;
    public double pValBDG;
    public double pValHillis;
    public double cutoffNormal;
    public double cutoffBDG;
    public double cutoffHillis;
    public double lambdaBDG;
    public double lambdaHillis;
    public double powerNormal;
    public double powerBDG;
    public double powerHillis;
    public double ciBotNormal;
    public double ciBotBDG;
    public double ciBotHillis;
    public double ciTopNormal;
    public double ciTopBDG;
    public double ciTopHillis;
    public double rejectNormal;
    public double rejectBDG;
    public double rejectHillis;

    public StatTest(DBRecord DBRecordStatTemp) {
        StudentDist tdist;
        double meanCI;
        this.DBRecordStat = DBRecordStatTemp;
        double sig = 0.05;
        if (this.DBRecordStat.selectedMod == 1 || this.DBRecordStat.selectedMod == 0) {
            meanCI = this.DBRecordStat.AUCsReaderAvg[this.DBRecordStat.selectedMod];
            this.tStatEst = Math.sqrt(Math.pow(meanCI - 0.5, 2.0) / this.DBRecordStat.totalVar);
        } else {
            meanCI = this.DBRecordStat.AUCsReaderAvg[0] - this.DBRecordStat.AUCsReaderAvg[1];
            this.tStatEst = Math.sqrt(Math.pow(meanCI, 2.0) / this.DBRecordStat.totalVar);
        }
        this.DF_BDG = this.calcDF_BDGms(this.DBRecordStat);
        NormalDist ndist = new NormalDist();
        this.pValNormal = 2.0 * (1.0 - ndist.cdf(this.tStatEst));
        this.cutoffNormal = ndist.inverseF(1.0 - sig / 2.0);
        if (this.DF_BDG >= 50.0) {
            this.pValBDG = this.pValNormal;
            this.cutoffBDG = this.cutoffNormal;
        } else {
            tdist = new StudentDist((int)this.DF_BDG);
            this.pValBDG = 2.0 * (1.0 - tdist.cdf(this.tStatEst));
            this.cutoffBDG = tdist.inverseF(1.0 - sig / 2.0);
        }
        this.ciBotNormal = meanCI - Math.sqrt(this.DBRecordStat.totalVar) * this.cutoffNormal;
        this.ciTopNormal = meanCI + Math.sqrt(this.DBRecordStat.totalVar) * this.cutoffNormal;
        this.ciBotBDG = meanCI - Math.sqrt(this.DBRecordStat.totalVar) * this.cutoffBDG;
        this.ciTopBDG = meanCI + Math.sqrt(this.DBRecordStat.totalVar) * this.cutoffBDG;
        if (this.pValNormal < sig) {
            this.rejectNormal = 1.0;
        }
        if (this.pValBDG < sig) {
            this.rejectBDG = 1.0;
        }
        if (this.DBRecordStat.flagFullyCrossed) {
            this.DF_Hillis = this.calcDF_Hillis(this.DBRecordStat);
            if (this.DF_Hillis >= 50.0) {
                this.pValHillis = this.pValNormal;
                this.cutoffHillis = this.cutoffNormal;
            } else {
                tdist = new StudentDist((int)this.DF_Hillis);
                this.pValHillis = 2.0 * (1.0 - tdist.cdf(this.tStatEst));
                this.cutoffHillis = tdist.inverseF(1.0 - sig / 2.0);
            }
            this.ciBotHillis = meanCI - Math.sqrt(this.DBRecordStat.totalVar) * this.cutoffHillis;
            this.ciTopHillis = meanCI + Math.sqrt(this.DBRecordStat.totalVar) * this.cutoffHillis;
            if (this.pValHillis < sig) {
                this.rejectHillis = 1.0;
            }
        } else {
            this.rejectHillis = Double.NaN;
        }
        if (this.DBRecordStat.verbose) {
            System.out.println("NR=" + this.DBRecordStat.Nreader + ",  N0=" + this.DBRecordStat.Nnormal + ",  N1=" + this.DBRecordStat.Ndisease);
            System.out.println("auc0=" + this.DBRecordStat.AUCsReaderAvg[0] + "  auc1=" + this.DBRecordStat.AUCsReaderAvg[1]);
            System.out.println("auc0-auc1=" + meanCI);
            System.out.println("totalVar=" + this.DBRecordStat.totalVar);
            System.out.println("varA=" + this.DBRecordStat.varA);
            System.out.println("varB=" + this.DBRecordStat.varB);
            System.out.println("tStatEst=" + this.tStatEst);
            System.out.println("Normal approx:  pValF=" + this.pValNormal + "  cutoffNormal=" + this.cutoffNormal + "  ci=" + this.ciBotNormal + "," + this.ciTopNormal);
            System.out.println("DF_BDG=" + this.DF_BDG + "  pValBDG=" + this.pValBDG + "  cutoffBDG=" + this.cutoffBDG + "  ci=" + this.ciBotBDG + "," + this.ciTopBDG);
            if (this.DBRecordStat.flagFullyCrossed) {
                System.out.println("DF_Hillis=" + this.DF_Hillis + "  pValHillis=" + this.pValHillis + "  cutoffHillis=" + this.cutoffHillis + "  ci=" + this.ciBotHillis + "," + this.ciTopHillis);
            }
        }
    }

    public StatTest(SizePanel SizePanel2, DBRecord DBRecordStat, DBRecord DBRecordSize) {
        this.DBRecordStat = DBRecordStat;
        this.DBRecordSize = DBRecordSize;
        int selectedMod = DBRecordSize.selectedMod;
        this.effSize = SizePanel2.effSize;
        this.sigLevel = SizePanel2.sigLevel;
        this.tStatCalc = this.effSize / Math.sqrt(DBRecordSize.totalVar);
        System.out.println("\nBegin Sizing Analysis");
        System.out.println("effSize= " + this.effSize + " totalVar= " + DBRecordSize.totalVar + " tStatCalc=" + this.tStatCalc);
        this.DF_BDG = this.calcDF_BDGms(DBRecordSize);
        this.lambdaBDG = this.tStatCalc * this.tStatCalc;
        double[][] OR = DBRecordStat.OR;
        double dnr = DBRecordSize.Nreader;
        double resizeFactor = (double)(DBRecordStat.Nnormal + DBRecordStat.Ndisease) / (double)(DBRecordSize.Nnormal + DBRecordSize.Ndisease);
        if (selectedMod == 3) {
            double var_tr = DBRecordStat.ms_tr - OR[3][5] + OR[3][2] + Math.max(OR[3][3] - OR[3][4], 0.0);
            double bracket1 = OR[3][5] - OR[3][2] + (dnr - 1.0) * Math.max(OR[3][3] - OR[3][4], 0.0);
            double variance = 2.0 / dnr * (var_tr + resizeFactor * bracket1);
            this.lambdaHillis = this.effSize * this.effSize / variance;
            double bracket2 = OR[3][5] - OR[3][2] - Math.max(OR[3][3] - OR[3][4], 0.0);
            this.DF_Hillis = (dnr - 1.0) * dnr * dnr * variance * variance / 2.0 / 2.0 / (var_tr + resizeFactor * bracket2) / (var_tr + resizeFactor * bracket2);
        } else {
            double ms_r = 0.0;
            if (selectedMod == 0) {
                ms_r = DBRecordStat.ms_rA;
            }
            if (selectedMod == 1) {
                ms_r = DBRecordStat.ms_rB;
            }
            double var_r = ms_r - OR[selectedMod][5] + OR[selectedMod][3];
            double bracket1 = OR[selectedMod][5] + (dnr - 1.0) * OR[selectedMod][3];
            double variance = 1.0 / dnr * (var_r + resizeFactor * bracket1);
            this.lambdaHillis = this.effSize * this.effSize / variance;
            double bracket2 = OR[selectedMod][5] - OR[selectedMod][3];
            this.DF_Hillis = (dnr - 1.0) * dnr * dnr * variance * variance / (var_r + resizeFactor * bracket2) / (var_r + resizeFactor * bracket2);
        }
        if (this.DF_Hillis < 2.0) {
            if (!exploreExpSize.doFullSize) {
                JFrame frame = new JFrame();
                String warningStr = "DF_Hillis was calculated to be " + this.DF_Hillis + "\nDF_Hillis less than 2 cannot be handled" + "\nTherefore, it is being set to 2";
                commandStartFunction.displayConsoleWarning(frame, warningStr);
            }
            this.DF_Hillis = 2.0;
        }
        double[] result = new double[4];
        result = this.PowerZtest();
        this.cutoffNormal = result[0];
        this.powerNormal = result[1];
        System.out.println("Normal power analysis:");
        System.out.println("cutoff=" + result[0] + ", power=" + result[1]);
        result = this.PowerFtest(this.DF_BDG, this.lambdaBDG);
        this.cutoffBDG = result[0];
        this.powerBDG = result[1];
        System.out.println("BDG power analysis (t):");
        System.out.println("DF_BDG=" + this.DF_BDG + ", cutoff=" + result[0] + ", noncentrality=" + this.lambdaBDG + ", power=" + result[1]);
        result = this.PowerFtest(this.DF_Hillis, this.lambdaHillis);
        this.cutoffHillis = result[0];
        this.powerHillis = result[1];
        System.out.println("Hillis power analysis (t):");
        System.out.println("DF_Hillis=" + this.DF_Hillis + ", cutoff=" + result[0] + ", noncentrality=" + this.lambdaHillis + ", power=" + result[1]);
    }

    public double doVar(double a, double b) {
        double mean = (a + b) / 2.0;
        double var = (a - mean) * (a - mean) + (b - mean) * (b - mean);
        return var;
    }

    public double calcDF_BDGbckIndep(DBRecord curRecord) {
        String warningStr;
        double componentDF;
        int i;
        double DFreader;
        double DFdisease;
        double DFnormal;
        boolean verbose = curRecord.verbose;
        int selectedMod = curRecord.selectedMod;
        double totalVar = curRecord.totalVar;
        double[][] tempBCK = curRecord.BCK;
        double[][] tempBCKcoeff = curRecord.BCKcoeff;
        double DF_min = 0.0;
        double DF_denom = 0.0;
        if (selectedMod == 0) {
            DFnormal = 1.0 / tempBCKcoeff[selectedMod][0] - 1.0;
            DFdisease = 1.0 / tempBCKcoeff[selectedMod][1] - 1.0;
            DFreader = 1.0 / tempBCKcoeff[selectedMod][3] - 1.0;
            DF_min = DFnormal;
            DF_min = Math.min(DFdisease, DF_min);
            DF_min = Math.min(DFreader, DF_min);
            i = 0;
            while (i < 7) {
                componentDF = 1.0 / tempBCKcoeff[selectedMod][i] - 1.0;
                DF_denom += Math.pow(tempBCKcoeff[selectedMod][i] * tempBCK[selectedMod][i], 2.0) / componentDF;
                ++i;
            }
        }
        if (selectedMod == 1) {
            DFnormal = 1.0 / tempBCKcoeff[selectedMod][0] - 1.0;
            DFdisease = 1.0 / tempBCKcoeff[selectedMod][1] - 1.0;
            DFreader = 1.0 / tempBCKcoeff[selectedMod][3] - 1.0;
            DF_min = DFnormal;
            DF_min = Math.min(DFdisease, DF_min);
            DF_min = Math.min(DFreader, DF_min);
            i = 0;
            while (i < 7) {
                componentDF = 1.0 / tempBCKcoeff[selectedMod][i] - 1.0;
                DF_denom += Math.pow(tempBCKcoeff[selectedMod][i] * tempBCK[selectedMod][i], 2.0) / componentDF;
                ++i;
            }
        }
        if (selectedMod == 3) {
            double DFnormalA = 1.0 / tempBCKcoeff[0][0] - 1.0;
            double DFnormalB = 1.0 / tempBCKcoeff[1][0] - 1.0;
            double DFdiseaseA = 1.0 / tempBCKcoeff[0][1] - 1.0;
            double DFdiseaseB = 1.0 / tempBCKcoeff[1][1] - 1.0;
            double DFreaderA = 1.0 / tempBCKcoeff[0][3] - 1.0;
            double DFreaderB = 1.0 / tempBCKcoeff[1][3] - 1.0;
            double DFnormal2 = DFnormalA / 2.0 + DFnormalB / 2.0;
            double DFdisease2 = DFdiseaseA / 2.0 + DFdiseaseB / 2.0;
            double DFreader2 = DFreaderA / 2.0 + DFreaderB / 2.0;
            DF_min = DFnormal2;
            DF_min = Math.min(DFdisease2, DF_min);
            DF_min = Math.min(DFreader2, DF_min);
            int i2 = 0;
            while (i2 < 7) {
                double componentDF_A = 1.0 / tempBCKcoeff[0][i2] - 1.0;
                double componentDF_B = 1.0 / tempBCKcoeff[1][i2] - 1.0;
                DF_denom = DF_denom + Math.pow(tempBCKcoeff[0][i2] * tempBCK[0][i2], 2.0) / componentDF_A + Math.pow(tempBCKcoeff[1][i2] * tempBCK[1][i2], 2.0) / componentDF_B;
                if (tempBCKcoeff[2][i2] > 0.0) {
                    double componentDF_AB = 1.0 / tempBCKcoeff[2][i2] - 1.0;
                    DF_denom += Math.pow(2.0 * tempBCKcoeff[2][i2] * tempBCK[2][i2], 2.0) / componentDF_AB;
                }
                ++i2;
            }
        }
        this.DF_BDG = Math.pow(totalVar, 2.0) / DF_denom;
        if (this.DF_BDG < DF_min) {
            if (verbose && !MRMC.commandStart) {
                JFrame frame = new JFrame();
                warningStr = "DF_BDG is below a minimum.\nDF_BDG was calculated to be " + this.DF_BDG + "\nIt is being set to DF_min = " + DF_min + "\nThis follows Gaylor1969_Technometrics_v4p691" + "\nand indicates that your data is very limited";
                commandStartFunction.displayConsoleWarning(frame, warningStr);
            }
            this.DF_BDG = DF_min;
        }
        if (this.DF_BDG < 2.0) {
            if (verbose && !MRMC.commandStart) {
                JFrame frame = new JFrame();
                warningStr = "DF_BDG is below a minimum.\nDF_BDG was calculated to be " + this.DF_BDG + "\nDF_BDG less than 2 cannot be handled" + "\nTherefore, it is being set to 2";
                commandStartFunction.displayConsoleWarning(frame, warningStr);
            }
            this.DF_BDG = 2.0;
        }
        return this.DF_BDG;
    }

    public double calcDF_BDGbckGroup(DBRecord curRecord) {
        String warningStr;
        double componentDF;
        int i;
        double DFreader;
        double DFdisease;
        double DFnormal;
        boolean verbose = curRecord.verbose;
        int selectedMod = curRecord.selectedMod;
        double totalVar = curRecord.totalVar;
        double[][] tempBCK = curRecord.BCK;
        double[][] tempBCKcoeff = curRecord.BCKcoeff;
        double DF_min = 0.0;
        double DF_denom = 0.0;
        if (selectedMod == 0) {
            DFnormal = 1.0 / tempBCKcoeff[selectedMod][0] - 1.0;
            DFdisease = 1.0 / tempBCKcoeff[selectedMod][1] - 1.0;
            DFreader = 1.0 / tempBCKcoeff[selectedMod][3] - 1.0;
            DF_min = DFnormal;
            DF_min = Math.min(DFdisease, DF_min);
            DF_min = Math.min(DFreader, DF_min);
            i = 0;
            while (i < 7) {
                componentDF = 1.0 / tempBCKcoeff[selectedMod][i] - 1.0;
                DF_denom += Math.pow(tempBCKcoeff[selectedMod][i] * tempBCK[selectedMod][i], 2.0) / componentDF;
                ++i;
            }
        }
        if (selectedMod == 1) {
            DFnormal = 1.0 / tempBCKcoeff[selectedMod][0] - 1.0;
            DFdisease = 1.0 / tempBCKcoeff[selectedMod][1] - 1.0;
            DFreader = 1.0 / tempBCKcoeff[selectedMod][3] - 1.0;
            DF_min = DFnormal;
            DF_min = Math.min(DFdisease, DF_min);
            DF_min = Math.min(DFreader, DF_min);
            i = 0;
            while (i < 7) {
                componentDF = 1.0 / tempBCKcoeff[selectedMod][i] - 1.0;
                DF_denom += Math.pow(tempBCKcoeff[selectedMod][i] * tempBCK[selectedMod][i], 2.0) / componentDF;
                ++i;
            }
        }
        if (selectedMod == 3) {
            double DFnormalA = 1.0 / tempBCKcoeff[0][0] - 1.0;
            double DFnormalB = 1.0 / tempBCKcoeff[1][0] - 1.0;
            double DFdiseaseA = 1.0 / tempBCKcoeff[0][1] - 1.0;
            double DFdiseaseB = 1.0 / tempBCKcoeff[1][1] - 1.0;
            double DFreaderA = 1.0 / tempBCKcoeff[0][3] - 1.0;
            double DFreaderB = 1.0 / tempBCKcoeff[1][3] - 1.0;
            double DFnormal2 = DFnormalA / 2.0 + DFnormalB / 2.0;
            double DFdisease2 = DFdiseaseA / 2.0 + DFdiseaseB / 2.0;
            double DFreader2 = DFreaderA / 2.0 + DFreaderB / 2.0;
            DF_min = DFnormal2;
            DF_min = Math.min(DFdisease2, DF_min);
            DF_min = Math.min(DFreader2, DF_min);
            int i2 = 0;
            while (i2 < 7) {
                if (tempBCKcoeff[2][i2] > 0.0) {
                    double currContributionToVariance = tempBCKcoeff[0][i2] * tempBCK[0][i2] + tempBCKcoeff[1][i2] * tempBCK[1][i2] - 2.0 * tempBCKcoeff[2][i2] * tempBCK[2][i2];
                    double currContributionToVarianceDF = (1.0 / tempBCKcoeff[0][i2] - 1.0) / 2.0 + (1.0 / tempBCKcoeff[1][i2] - 1.0) / 2.0;
                    DF_denom += Math.pow(currContributionToVariance, 2.0) / currContributionToVarianceDF;
                } else {
                    DF_denom = DF_denom + Math.pow(tempBCKcoeff[0][i2] * tempBCK[0][i2], 2.0) / (1.0 / tempBCKcoeff[0][i2] - 1.0) + Math.pow(tempBCKcoeff[1][i2] * tempBCK[1][i2], 2.0) / (1.0 / tempBCKcoeff[1][i2] - 1.0);
                }
                ++i2;
            }
        }
        this.DF_BDG = Math.pow(totalVar, 2.0) / DF_denom;
        if (this.DF_BDG < DF_min) {
            if (verbose && !MRMC.commandStart) {
                JFrame frame = new JFrame();
                warningStr = "DF_BDG is below a minimum.\nDF_BDG was calculated to be " + this.DF_BDG + "\nIt is being set to DF_min = " + DF_min + "\nThis follows Gaylor1969_Technometrics_v4p691" + "\nand indicates that your data is very limited";
                commandStartFunction.displayConsoleWarning(frame, warningStr);
            }
            this.DF_BDG = DF_min;
        }
        if (this.DF_BDG < 2.0) {
            if (verbose && !MRMC.commandStart) {
                JFrame frame = new JFrame();
                warningStr = "DF_BDG is below a minimum.\nDF_BDG was calculated to be " + this.DF_BDG + "\nDF_BDG less than 2 cannot be handled" + "\nTherefore, it is being set to 2";
                commandStartFunction.displayConsoleWarning(frame, warningStr);
            }
            this.DF_BDG = 2.0;
        }
        return this.DF_BDG;
    }

    public double calcDF_BDGms(DBRecord curRecord) {
        String warningStr;
        boolean verbose = curRecord.verbose;
        int selectedMod = curRecord.selectedMod;
        double totalVar = curRecord.totalVar;
        double[][] tempBCKbias = curRecord.BCKbias;
        double[][] tempBCKcoeff = curRecord.BCKcoeff;
        double DFnormalA = Math.round(1.0 / tempBCKcoeff[0][0] - 1.0);
        double DFnormalB = Math.round(1.0 / tempBCKcoeff[1][0] - 1.0);
        double DFdiseaseA = Math.round(1.0 / tempBCKcoeff[0][1] - 1.0);
        double DFdiseaseB = Math.round(1.0 / tempBCKcoeff[1][1] - 1.0);
        double DFreaderA = Math.round(1.0 / tempBCKcoeff[0][3] - 1.0);
        double DFreaderB = Math.round(1.0 / tempBCKcoeff[1][3] - 1.0);
        double MSnormalA = tempBCKbias[0][0];
        double MSnormalB = tempBCKbias[1][0];
        double MSnormal = tempBCKbias[0][0] + tempBCKbias[1][0] - 2.0 * tempBCKbias[2][0];
        double MSdiseaseA = tempBCKbias[0][1];
        double MSdiseaseB = tempBCKbias[1][1];
        double MSdisease = tempBCKbias[0][1] + tempBCKbias[1][1] - 2.0 * tempBCKbias[2][1];
        double MSreaderA = tempBCKbias[0][3];
        double MSreaderB = tempBCKbias[1][3];
        double MSreader = tempBCKbias[0][3] + tempBCKbias[1][3] - 2.0 * tempBCKbias[2][3];
        double DF_denom = 0.0;
        double DF_min = 0.0;
        if (selectedMod == 0) {
            DF_denom = Math.pow(MSnormalA / DFnormalA, 2.0) / DFnormalA + Math.pow(MSdiseaseA / DFdiseaseA, 2.0) / DFdiseaseA + Math.pow(MSreaderA / DFreaderA, 2.0) / DFreaderA;
            DF_min = Math.min(DFnormalA, DFdiseaseA);
            DF_min = Math.min(DF_min, DFreaderA);
        }
        if (selectedMod == 1) {
            DF_denom = Math.pow(MSnormalB / DFnormalB, 2.0) / DFnormalB + Math.pow(MSdiseaseB / DFdiseaseB, 2.0) / DFdiseaseB + Math.pow(MSreaderB / DFreaderB, 2.0) / DFreaderB;
            DF_min = Math.min(DFnormalB, DFdiseaseB);
            DF_min = Math.min(DF_min, DFreaderB);
        }
        if (selectedMod == 3) {
            double DFnormal = Math.min(DFnormalA, DFnormalB);
            double DFdisease = Math.min(DFdiseaseA, DFdiseaseB);
            double DFreader = Math.min(DFreaderA, DFreaderB);
            DF_min = Math.min(DFnormal, DFdisease);
            DF_min = Math.min(DF_min, DFreader);
            DF_denom = tempBCKcoeff[2][0] > 0.0 ? (DF_denom += Math.pow(MSnormal / DFnormal, 2.0) / DFnormal) : DF_denom + Math.pow(MSnormalA / DFnormalA, 2.0) / DFnormalA + Math.pow(MSnormalB / DFnormalB, 2.0) / DFnormalB;
            DF_denom = tempBCKcoeff[2][1] > 0.0 ? (DF_denom += Math.pow(MSdisease / DFdisease, 2.0) / DFdisease) : DF_denom + Math.pow(MSdiseaseA / DFdiseaseA, 2.0) / DFdiseaseA + Math.pow(MSdiseaseB / DFdiseaseB, 2.0) / DFdiseaseB;
            DF_denom = tempBCKcoeff[2][3] > 0.0 ? (DF_denom += Math.pow(MSreader / DFreader, 2.0) / DFreader) : DF_denom + Math.pow(MSreaderA / DFreaderA, 2.0) / DFreaderA + Math.pow(MSreaderB / DFreaderB, 2.0) / DFreaderB;
        }
        this.DF_BDG = Math.pow(totalVar, 2.0) / DF_denom;
        if (this.DF_BDG < DF_min) {
            if (verbose && !RoeMetz.doValidation && !exploreExpSize.doFullSize && !MRMC.commandStart) {
                JFrame frame = new JFrame();
                warningStr = "DF_BDG is below a minimum.\nDF_BDG was calculated to be " + this.DF_BDG + "\nIt is being set to DF_min = " + DF_min + "\nThis follows Gaylor1969_Technometrics_v4p691" + "\nand indicates that your data is very limited";
                commandStartFunction.displayConsoleWarning(frame, warningStr);
            }
            this.DF_BDG = DF_min;
        }
        if (this.DF_BDG < 2.0) {
            if (verbose && !RoeMetz.doValidation && !exploreExpSize.doFullSize && !MRMC.commandStart) {
                JFrame frame = new JFrame();
                warningStr = "DF_BDG is below a minimum.\nDF_BDG was calculated to be " + this.DF_BDG + "\nDF_BDG less than 2 cannot be handled" + "\nTherefore, it is being set to 2";
                commandStartFunction.displayConsoleWarning(frame, warningStr);
            }
            this.DF_BDG = 2.0;
        }
        return this.DF_BDG;
    }

    public double calcDF_Hillis(DBRecord curRecord) {
        String warningStr;
        double[] AUCsReaderAvg = curRecord.AUCsReaderAvg;
        double dnm = 2.0;
        double dnr = curRecord.Nreader;
        double[][] OR = curRecord.OR;
        if (curRecord.selectedMod == 3) {
            double denom = curRecord.ms_tr + Math.max(dnr * (OR[3][3] - OR[3][4]), 0.0);
            this.DF_Hillis = (dnr - 1.0) * (dnm - 1.0) * denom * denom / curRecord.ms_tr / curRecord.ms_tr;
        } else {
            double ms_r = 0.0;
            if (curRecord.selectedMod == 0) {
                ms_r = curRecord.ms_rA;
            }
            if (curRecord.selectedMod == 1) {
                ms_r = curRecord.ms_rB;
            }
            double denom = ms_r + Math.max(dnr * OR[curRecord.selectedMod][3], 0.0);
            this.DF_Hillis = (dnr - 1.0) * denom * denom / ms_r / ms_r;
        }
        if (this.DF_Hillis < 2.0) {
            if (!RoeMetz.doValidation && !MRMC.commandStart) {
                JFrame frame = new JFrame();
                warningStr = "DF_Hillis was calculated to be " + this.DF_Hillis + "\nIt is being set to 2";
                commandStartFunction.displayConsoleWarning(frame, warningStr);
            }
            this.DF_Hillis = 2.0;
        }
        if (Double.isInfinite(this.DF_Hillis)) {
            if (!RoeMetz.doValidation && !MRMC.commandStart) {
                JFrame frame = new JFrame();
                warningStr = "DF_Hillis was calculated to be infinite.\nIt is likely due to ms_tr = 0.0 (difference in modalities analysis)\n    or ms_r = 0.0 (single modality analysis).\nDF_Hillis is being set to 50.\nPlease check your data.";
                commandStartFunction.displayConsoleWarning(frame, warningStr);
            }
            this.DF_Hillis = 50.0;
        }
        return this.DF_Hillis;
    }

    public double[] PowerFtest(double df, double lambda) {
        double power;
        double cutoff;
        double[] result = new double[4];
        if (df >= 50.0) {
            cutoff = NormalDist.inverseF(0.0, 1.0, 1.0 - this.sigLevel / 2.0);
            power = 1.0 - NormalDist.cdf(Math.sqrt(lambda), 1.0, cutoff);
            result = this.PowerZtest();
        } else {
            FisherFDist fdist = new FisherFDist(1, (int)df);
            cutoff = fdist.inverseF(1.0 - this.sigLevel);
            power = 1.0 - this.cdfNonCentralF(1, (int)df - 1, lambda, cutoff);
        }
        result[0] = cutoff;
        result[1] = power;
        return result;
    }

    public double cdfNonCentralF(int df1, int df2, double delta, double x) {
        double cdf = 0.0;
        int j = 0;
        while (j < 500) {
            double tempF = BetaDist.cdf((double)df1 / 2.0 + (double)j, (double)df2 / 2.0, (double)df1 * x / ((double)df2 + (double)df1 * x));
            double sfactor = 1.0;
            int k = j;
            while (k > 0) {
                sfactor = sfactor * (0.5 * delta) / (double)k;
                --k;
            }
            tempF = sfactor * Math.exp(-delta / 2.0) * tempF;
            cdf += tempF;
            if (tempF > -1.0E-300 && tempF < 1.0E-300) break;
            ++j;
        }
        return cdf;
    }

    public double[] PowerZtest() {
        double cutoff = NormalDist.inverseF(0.0, 1.0, 1.0 - this.sigLevel / 2.0);
        double power = 1.0 - NormalDist.cdf(this.tStatCalc, 1.0, cutoff);
        double ciBot = this.effSize - NormalDist.inverseF(0.0, 1.0, this.sigLevel / 2.0);
        double ciTop = this.effSize + NormalDist.inverseF(0.0, 1.0, this.sigLevel / 2.0);
        double[] result = new double[]{cutoff, power, ciBot, ciTop};
        return result;
    }
}

