/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.freehep.util.io.ASCII85;
import org.freehep.util.io.EncodingException;

public class ASCII85InputStream
extends InputStream
implements ASCII85 {
    private boolean endReached;
    private int[] b = new int[4];
    private int bIndex;
    private int bLength;
    private int[] c = new int[5];
    private int lineNo;
    private int prev;
    private InputStream in;

    public ASCII85InputStream(InputStream input) {
        this.in = input;
        this.bIndex = 0;
        this.bLength = 0;
        this.endReached = false;
        this.prev = -1;
        this.lineNo = 1;
    }

    @Override
    public int read() throws IOException {
        if (this.bIndex >= this.bLength) {
            if (this.endReached) {
                return -1;
            }
            this.bLength = this.readTuple();
            if (this.bLength < 0) {
                return -1;
            }
            this.bIndex = 0;
        }
        int a = this.b[this.bIndex];
        ++this.bIndex;
        return a;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    private int readTuple() throws IOException, EncodingException {
        int cIndex = 0;
        int ch = -1;
        block8: while (!this.endReached && cIndex < 5) {
            this.prev = ch;
            ch = this.in.read();
            switch (ch) {
                case -1: {
                    throw new EncodingException("missing '~>' at end of ASCII85 stream");
                }
                case 122: {
                    this.b[3] = 33;
                    this.b[2] = 33;
                    this.b[1] = 33;
                    this.b[0] = 33;
                    return 4;
                }
                case 126: {
                    if (this.in.read() != 62) {
                        throw new EncodingException("Invalid ASCII85 EOD");
                    }
                    this.endReached = true;
                    continue block8;
                }
                case 13: {
                    ++this.lineNo;
                    continue block8;
                }
                case 10: {
                    if (this.prev == 13) continue block8;
                    ++this.lineNo;
                    continue block8;
                }
                case 0: 
                case 9: 
                case 12: 
                case 32: {
                    continue block8;
                }
            }
            this.c[cIndex] = ch;
            ++cIndex;
        }
        if (cIndex > 0) {
            for (int i = 0; i < this.c.length; ++i) {
                if (i >= cIndex) {
                    this.c[i] = 33;
                    continue;
                }
                int n = i;
                this.c[n] = this.c[n] - 33;
            }
            long d = (long)this.c[0] * 52200625L + (long)this.c[1] * 614125L + (long)this.c[2] * 7225L + (long)this.c[3] * 85L + (long)this.c[4] & 0xFFFFFFFFL;
            this.b[0] = (int)(d >> 24 & 0xFFL);
            this.b[1] = (int)(d >> 16 & 0xFFL);
            this.b[2] = (int)(d >> 8 & 0xFFL);
            this.b[3] = (int)(d & 0xFFL);
        }
        return cIndex - 1;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: ASCII85InputStream filename");
            System.exit(1);
        }
        ASCII85InputStream in = new ASCII85InputStream(new FileInputStream(args[0]));
        int b = in.read();
        while (b != -1) {
            System.out.write(b);
            b = in.read();
        }
        in.close();
        System.out.flush();
    }
}

