/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SimpleChemFormatMatcher;

public class PDBFormat
extends SimpleChemFormatMatcher
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new PDBFormat();
        }
        return myself;
    }

    public String getFormatName() {
        return "Protein Brookhave Database (PDB)";
    }

    public String getMIMEType() {
        return "chemical/x-pdb";
    }

    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    public String[] getNameExtensions() {
        return new String[]{"pdb", "ent"};
    }

    public String getReaderClassName() {
        return "org.openscience.cdk.io.PDBReader";
    }

    public String getWriterClassName() {
        return "org.openscience.cdk.io.PDBWriter";
    }

    @Override
    public boolean matches(int lineNumber, String line) {
        return line.startsWith("HEADER") || line.startsWith("HETATM ") || line.startsWith("ATOM  ");
    }

    public boolean isXMLBased() {
        return false;
    }

    public int getSupportedDataFeatures() {
        return 4 | this.getRequiredDataFeatures();
    }

    public int getRequiredDataFeatures() {
        return 10;
    }
}

