/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.knapsack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.knapsack.structure.ComputingLossWeightTree;
import org.chocosolver.solver.constraints.nary.knapsack.structure.Info;
import org.chocosolver.solver.constraints.nary.knapsack.structure.ItemFindingSearchTree;
import org.chocosolver.solver.constraints.nary.knapsack.structure.KPItem;
import org.chocosolver.solver.constraints.nary.knapsack.structure.SearchInfos;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.sort.ArraySort;
import org.chocosolver.util.tools.ArrayUtils;

public class PropKnapsackKatriel01
extends Propagator<IntVar> {
    static final int ADDED = 1;
    static final int REMOVED = -1;
    static final int NOT_DEFINED = 0;
    private final int[] order;
    private final int[] reverseOrder;
    private final int n;
    private final IntVar capacity;
    private final IntVar power;
    private final int[] itemState;
    private final ItemFindingSearchTree findingTree;
    private final ComputingLossWeightTree computingTree;
    private Info criticalItemInfos;
    private int usedCapacity;
    private int powerCreated;
    private boolean mustRecomputeCriticalInfos;
    private int lastWorld = -1;
    private long lastNbOfBacktracks = -1L;
    private long lastNbOfRestarts = -1L;

    public PropKnapsackKatriel01(BoolVar[] itemOccurence, IntVar capacity, IntVar power, int[] weight, int[] energy) {
        super((Variable[])ArrayUtils.append(new IntVar[][]{itemOccurence, {capacity, power}}), (Priority)PropagatorPriority.QUADRATIC, true);
        this.n = itemOccurence.length;
        this.itemState = new int[this.n];
        this.reverseOrder = new int[this.n];
        this.capacity = capacity;
        this.power = power;
        this.usedCapacity = 0;
        this.powerCreated = 0;
        Arrays.fill(this.itemState, 0);
        this.order = ArrayUtils.array(0, this.n - 1);
        ArraySort sorter = new ArraySort(this.n, false, true);
        sorter.sort(this.order, this.n, (i1, i2) -> {
            long comparaison = (long)energy[i2] * (long)weight[i1] - (long)energy[i1] * (long)weight[i2];
            if (comparaison == 0L) {
                comparaison = weight[i1] * weight[i2] == 0 ? (long)energy[i2] - (long)energy[i1] : (long)weight[i2] - (long)weight[i1];
            }
            return Long.signum(comparaison);
        });
        ArrayList<KPItem> orderedItems = new ArrayList<KPItem>();
        orderedItems.ensureCapacity(this.n);
        for (int i = 0; i < this.n; ++i) {
            orderedItems.add(new KPItem(energy[this.order[i]], weight[this.order[i]]));
            this.reverseOrder[this.order[i]] = i;
        }
        this.findingTree = new ItemFindingSearchTree((List<KPItem>)orderedItems);
        this.computingTree = new ComputingLossWeightTree((List<KPItem>)orderedItems);
        this.mustRecomputeCriticalInfos = true;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx < this.n) {
            return IntEventType.boundAndInst();
        }
        if (vIdx == this.n) {
            return IntEventType.combine(IntEventType.DECUPP, IntEventType.INSTANTIATE);
        }
        return IntEventType.combine(IntEventType.INCLOW, IntEventType.INSTANTIATE);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.checkWorld();
        if (this.mustRecomputeCriticalInfos()) {
            this.criticalItemInfos = this.computingTree.findCriticalItem(this.capacity.getUB() - this.usedCapacity);
            this.mustRecomputeCriticalInfos = false;
        }
        if (this.criticalItemInfos.profit + (double)this.powerCreated >= (double)this.power.getLB()) {
            List<Integer> mandatoryList = this.findMandatoryItems();
            List<Integer> forbiddenList = this.findForbiddenItems();
            for (int unorderedLeafIdx : mandatoryList) {
                this.addItemToSolution(unorderedLeafIdx, true);
                this.mustRecomputeCriticalInfos = true;
            }
            for (int unorderedLeafIdx : forbiddenList) {
                this.removeItemFromProblem(unorderedLeafIdx, true);
                this.mustRecomputeCriticalInfos = true;
            }
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (varIdx < this.n) {
            if (((IntVar[])this.vars)[varIdx].isInstantiatedTo(0)) {
                this.removeItemFromProblem(varIdx, false);
            } else if (((IntVar[])this.vars)[varIdx].isInstantiatedTo(1)) {
                this.addItemToSolution(varIdx, false);
            }
        }
        this.mustRecomputeCriticalInfos |= varIdx < this.n + 1;
        this.forcePropagate(PropagatorEventType.FULL_PROPAGATION);
    }

    private boolean mustRecomputeCriticalInfos() {
        this.checkWorld();
        return this.mustRecomputeCriticalInfos;
    }

    private void checkWorld() {
        int currentworld = this.model.getEnvironment().getWorldIndex();
        long currentbt = this.model.getSolver().getBackTrackCount();
        long currentrestart = this.model.getSolver().getRestartCount();
        if (currentworld < this.lastWorld || currentbt != this.lastNbOfBacktracks || currentrestart > this.lastNbOfRestarts) {
            this.mustRecomputeCriticalInfos = true;
        }
        this.lastWorld = currentworld;
        this.lastNbOfBacktracks = currentbt;
        this.lastNbOfRestarts = currentrestart;
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }

    private void addItemToSolution(int i, boolean removeVarValue) throws ContradictionException {
        if (this.itemState[i] == 0) {
            this.itemState[i] = 1;
            int sortedGlobalIndex = this.computingTree.leafToGlobalIndex(this.reverseOrder[i]);
            this.computingTree.removeLeaf(sortedGlobalIndex);
            this.findingTree.removeLeaf(sortedGlobalIndex);
            if (removeVarValue) {
                ((IntVar[])this.vars)[i].removeValue(0, (ICause)this);
            }
            this.getEnvironment().save(() -> this.activateItemToProblem(i, 1));
            this.usedCapacity += ((KPItem)this.computingTree.getLeaf(sortedGlobalIndex)).getActivatedWeight();
            this.powerCreated += ((KPItem)this.computingTree.getLeaf(sortedGlobalIndex)).getActivatedProfit();
        }
    }

    private void removeItemFromProblem(int i, boolean removeVarValue) throws ContradictionException {
        if (this.itemState[i] == 0) {
            this.itemState[i] = -1;
            int sortedGlobalIndex = this.computingTree.leafToGlobalIndex(this.reverseOrder[i]);
            this.computingTree.removeLeaf(sortedGlobalIndex);
            this.findingTree.removeLeaf(sortedGlobalIndex);
            if (removeVarValue) {
                ((IntVar[])this.vars)[i].removeValue(1, (ICause)this);
            }
            this.getEnvironment().save(() -> this.activateItemToProblem(i, -1));
        }
    }

    private void activateItemToProblem(int i, int expectedState) {
        if (this.itemState[i] == expectedState) {
            int sortedGlobalIndex = this.computingTree.leafToGlobalIndex(this.reverseOrder[i]);
            this.computingTree.activateLeaf(sortedGlobalIndex);
            this.findingTree.activateLeaf(sortedGlobalIndex);
            if (this.itemState[i] == 1) {
                this.usedCapacity -= ((KPItem)this.computingTree.getLeaf(sortedGlobalIndex)).getActivatedWeight();
                this.powerCreated -= ((KPItem)this.computingTree.getLeaf(sortedGlobalIndex)).getActivatedProfit();
            }
            this.itemState[i] = 0;
        } else if (this.itemState[i] != 0) {
            throw new RuntimeException("the item reverted does not have the expected state");
        }
    }

    private List<Integer> findMandatoryItems() {
        LinkedList<Integer> mandatoryList = new LinkedList<Integer>();
        double allowedProfitLoss = this.criticalItemInfos.profit + (double)this.powerCreated - (double)this.power.getLB();
        int index = this.computingTree.leafToGlobalIndex(0);
        if (index != -1) {
            if (!((KPItem)this.computingTree.getLeaf(index)).isActive()) {
                index = this.findingTree.findNextRightItem(index, this.criticalItemInfos.index, 0);
            }
            int maxWeight = 0;
            double criticalItemWeightNotInDantzig = 0.0;
            if (this.computingTree.isLeaf(this.criticalItemInfos.index)) {
                criticalItemWeightNotInDantzig = this.computingTree.getNodeWeight(this.criticalItemInfos.index) - (this.criticalItemInfos.weight - this.criticalItemInfos.weightWithoutCriticalItem);
            }
            SearchInfos infos = new SearchInfos(false, this.criticalItemInfos.index, 0.0, 0.0, criticalItemWeightNotInDantzig);
            while (index != -1) {
                infos = this.computingTree.computeLimitWeightMandatory(this.criticalItemInfos, index, infos.endItem, infos.profitAccumulated, infos.weightAccumulated, allowedProfitLoss, infos.remainingWeightEndItem);
                if (infos.decision) {
                    mandatoryList.add(this.order[this.computingTree.globalToLeaf(index)]);
                } else {
                    maxWeight = Math.max(maxWeight, this.computingTree.getNodeWeight(index));
                    maxWeight = Math.max(maxWeight, (int)infos.weightAccumulated);
                }
                index = this.findingTree.findNextRightItem(index, this.criticalItemInfos.index, maxWeight);
            }
        }
        return mandatoryList;
    }

    private List<Integer> findForbiddenItems() {
        LinkedList<Integer> forbiddenList = new LinkedList<Integer>();
        double allowedProfitLoss = this.criticalItemInfos.profit + (double)this.powerCreated - (double)this.power.getLB();
        int index = this.criticalItemInfos.index;
        if (index != -1 && this.criticalItemInfos.index != this.computingTree.getNumberNodes()) {
            int maxWeight = 0;
            double criticalItemWeightInDantzig = this.criticalItemInfos.weight - this.criticalItemInfos.weightWithoutCriticalItem;
            if (!((KPItem)this.computingTree.getLeaf(index)).isActive()) {
                index = this.findingTree.findNextRightItem(index, this.computingTree.getNumberNodes() - 1, maxWeight);
            }
            SearchInfos infos = new SearchInfos(false, this.criticalItemInfos.index, 0.0, 0.0, criticalItemWeightInDantzig);
            while (index != -1) {
                infos = this.computingTree.computeLimitWeightForbidden(this.criticalItemInfos, index, infos.endItem, infos.profitAccumulated, infos.weightAccumulated, allowedProfitLoss, infos.remainingWeightEndItem);
                if (infos.decision) {
                    forbiddenList.add(this.order[this.computingTree.globalToLeaf(index)]);
                } else {
                    maxWeight = Math.max(maxWeight, (int)infos.weightAccumulated);
                    maxWeight = Math.max(maxWeight, this.computingTree.getNodeWeight(index));
                }
                index = this.findingTree.findNextRightItem(index, this.computingTree.getNumberNodes() - 1, maxWeight);
            }
        }
        return forbiddenList;
    }

    private IEnvironment getEnvironment() {
        return this.getModel().getEnvironment();
    }
}

