/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.vikamine.kernel.util.Group;

public class GroupReader {
    private static final int maxDepth = 10;
    private final List<Group<String>> allGroups;
    private final Reader dashTreeReader;
    private final List<Group<String>> rootGroups;

    public GroupReader(String dashTreeString) {
        this(new StringReader(dashTreeString));
    }

    public GroupReader(File f) throws FileNotFoundException {
        this(new FileReader(f));
    }

    public GroupReader(Reader dashTreeReader) {
        this.dashTreeReader = dashTreeReader;
        this.rootGroups = new ArrayList<Group<String>>();
        this.allGroups = new ArrayList<Group<String>>();
        this.init();
    }

    private boolean dashesEndWithPlus(String line) {
        int noDashes = this.numberOfLeadingDashes(line);
        if (line.length() <= noDashes) {
            return false;
        }
        char c = line.charAt(noDashes);
        return c == '+';
    }

    public List<Group<String>> getAllGroups() {
        return this.allGroups;
    }

    public List<Group<String>> getRootGroups() {
        return this.rootGroups;
    }

    private int numberOfLeadingDashes(String line) {
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) != '-') {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void init() {
        Group[] lastGroups = new Group[10];
        try {
            String line;
            BufferedReader br = new BufferedReader(this.dashTreeReader);
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("//") || line.startsWith("#")) continue;
                int noDashes = this.numberOfLeadingDashes(line);
                if (!this.dashesEndWithPlus(line)) {
                    Group g = new Group(line.substring(noDashes).trim());
                    this.allGroups.add(g);
                    lastGroups[noDashes] = g;
                    if (noDashes == 0) {
                        this.rootGroups.add(g);
                        continue;
                    }
                    lastGroups[noDashes - 1].addSubset(g);
                    continue;
                }
                lastGroups[noDashes].addElement(line.substring(noDashes + 1).trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Group<String> getGroup(String string) {
        for (Group<String> g : this.allGroups) {
            if (!g.getId().equals(string)) continue;
            return g;
        }
        return null;
    }
}

