/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.ConstantPopulation;
import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.util.Units;

public class LinearGrowth
extends ConstantPopulation {
    private double N0;

    public LinearGrowth(Units.Type type) {
        super(type);
    }

    @Override
    public double getN0() {
        return this.N0;
    }

    @Override
    public void setN0(double d) {
        this.N0 = d;
    }

    @Override
    public double getDemographic(double d) {
        if (d > 0.0) {
            throw new RuntimeException("Negative times only!");
        }
        return -this.getN0() * d;
    }

    @Override
    public double getIntensity(double d) {
        throw new RuntimeException("getIntensity is not implemented (and not finite); use getIntegral instead");
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double getIntegral(double d, double d2) {
        return 1.0 / this.getN0() * Math.log(-d / -d2);
    }

    public double getInverseIntegral(double d, double d2) {
        return d2 * Math.exp(-(d * this.getN0()));
    }

    @Override
    public int getNumArguments() {
        return 1;
    }

    @Override
    public String getArgumentName(int n) {
        return "N0";
    }

    @Override
    public double getArgument(int n) {
        return this.getN0();
    }

    @Override
    public void setArgument(int n, double d) {
        this.setN0(d);
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public DemographicFunction getCopy() {
        LinearGrowth linearGrowth = new LinearGrowth(this.getUnits());
        linearGrowth.N0 = this.N0;
        return linearGrowth;
    }
}

