/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SelectedDenseIntMatrix1D;

class SelectedDenseIntMatrix2D
extends IntMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] elements;
    protected int[] rowOffsets;
    protected int[] columnOffsets;
    protected int offset;

    protected SelectedDenseIntMatrix2D(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        this(nArray2.length, nArray3.length, nArray, 0, 0, 1, 1, nArray2, nArray3, n);
    }

    protected SelectedDenseIntMatrix2D(int n, int n2, int[] nArray, int n3, int n4, int n5, int n6, int[] nArray2, int[] nArray3, int n7) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = nArray;
        this.rowOffsets = nArray2;
        this.columnOffsets = nArray3;
        this.offset = n7;
        this.isNoView = false;
    }

    public int[] elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public int getQuick(int n, int n2) {
        return this.elements[this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride]];
    }

    public long index(int n, int n2) {
        return this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride];
    }

    public IntMatrix2D like(int n, int n2) {
        return new DenseIntMatrix2D(n, n2);
    }

    public IntMatrix1D like1D(int n) {
        return new DenseIntMatrix1D(n);
    }

    public void setQuick(int n, int n2, int n3) {
        this.elements[this.offset + this.rowOffsets[this.rowZero + n * this.rowStride] + this.columnOffsets[this.columnZero + n2 * this.columnStride]] = n3;
    }

    public IntMatrix1D vectorize() {
        DenseIntMatrix1D denseIntMatrix1D = new DenseIntMatrix1D((int)this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                denseIntMatrix1D.setQuick(n++, this.getQuick(i, j));
            }
        }
        return denseIntMatrix1D;
    }

    public IntMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = this.rowZero;
        int n4 = this.rowStride;
        int[] nArray = this.rowOffsets;
        int n5 = this.offset + this._columnOffset(this._columnRank(n));
        return new SelectedDenseIntMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    public IntMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = this.columnZero;
        int n4 = this.columnStride;
        int[] nArray = this.columnOffsets;
        int n5 = this.offset + this._rowOffset(this._rowRank(n));
        return new SelectedDenseIntMatrix1D(n2, this.elements, n3, n4, nArray, n5);
    }

    protected int _columnOffset(int n) {
        return this.columnOffsets[n];
    }

    protected int _rowOffset(int n) {
        return this.rowOffsets[n];
    }

    protected boolean haveSharedCellsRaw(IntMatrix2D intMatrix2D) {
        if (intMatrix2D instanceof SelectedDenseIntMatrix2D) {
            SelectedDenseIntMatrix2D selectedDenseIntMatrix2D = (SelectedDenseIntMatrix2D)intMatrix2D;
            return this.elements == selectedDenseIntMatrix2D.elements;
        }
        if (intMatrix2D instanceof DenseIntMatrix2D) {
            DenseIntMatrix2D denseIntMatrix2D = (DenseIntMatrix2D)intMatrix2D;
            return this.elements == denseIntMatrix2D.elements;
        }
        return false;
    }

    protected IntMatrix1D like1D(int n, int n2, int n3) {
        throw new InternalError();
    }

    protected void setUp(int n, int n2) {
        super.setUp(n, n2);
        this.rowStride = 1;
        this.columnStride = 1;
        this.offset = 0;
    }

    protected AbstractMatrix2D vDice() {
        super.vDice();
        int[] nArray = this.rowOffsets;
        this.rowOffsets = this.columnOffsets;
        this.columnOffsets = nArray;
        this.isNoView = false;
        return this;
    }

    protected IntMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseIntMatrix2D(this.elements, nArray, nArray2, this.offset);
    }
}

