/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCriteriaCheck;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.operations.Execution;
import org.ohdsi.circe.check.operations.Operations;
import org.ohdsi.circe.check.utils.CriteriaNameHelper;
import org.ohdsi.circe.cohortdefinition.CohortExpression;
import org.ohdsi.circe.cohortdefinition.ConditionOccurrence;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.Death;
import org.ohdsi.circe.cohortdefinition.DeviceExposure;
import org.ohdsi.circe.cohortdefinition.DrugExposure;
import org.ohdsi.circe.cohortdefinition.Measurement;
import org.ohdsi.circe.cohortdefinition.Observation;
import org.ohdsi.circe.cohortdefinition.ProcedureOccurrence;
import org.ohdsi.circe.cohortdefinition.Specimen;
import org.ohdsi.circe.cohortdefinition.VisitDetail;
import org.ohdsi.circe.cohortdefinition.VisitOccurrence;

public class DomainTypeCheck
extends BaseCriteriaCheck {
    private static final String WARNING = "It's not specified what type of records to look for in %s";
    private List<String> warnNames = new ArrayList<String>();

    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.INFO;
    }

    @Override
    protected void checkCriteria(Criteria criteria, String groupName, WarningReporter reporter) {
        String name = CriteriaNameHelper.getCriteriaName(criteria);
        Execution addWarning = () -> this.warnNames.add(name + " at " + groupName);
        Operations.match(criteria).isA(ConditionOccurrence.class).then(c -> Operations.match((ConditionOccurrence)c).when(conditionOccurrence -> Objects.isNull(conditionOccurrence.conditionType)).then(addWarning)).isA(Death.class).then(c -> Operations.match((Death)c).when(death -> Objects.isNull(death.deathType)).then(addWarning)).isA(DeviceExposure.class).then(c -> Operations.match((DeviceExposure)c).when(deviceExposure -> Objects.isNull(deviceExposure.deviceType)).then(addWarning)).isA(DrugExposure.class).then(c -> Operations.match((DrugExposure)c).when(drugExposure -> Objects.isNull(drugExposure.drugType)).then(addWarning)).isA(Measurement.class).then(c -> Operations.match((Measurement)c).when(measurement -> Objects.isNull(measurement.measurementType)).then(addWarning)).isA(Observation.class).then(c -> Operations.match((Observation)c).when(observation -> Objects.isNull(observation.observationType)).then(addWarning)).isA(ProcedureOccurrence.class).then(c -> Operations.match((ProcedureOccurrence)c).when(procedureOccurrence -> Objects.isNull(procedureOccurrence.procedureType)).then(addWarning)).isA(Specimen.class).then(c -> Operations.match((Specimen)c).when(specimen -> Objects.isNull(specimen.specimenType)).then(addWarning)).isA(VisitOccurrence.class).then(c -> Operations.match((VisitOccurrence)c).when(visitOccurrence -> Objects.isNull(visitOccurrence.visitType)).then(addWarning)).isA(VisitDetail.class).then(c -> Operations.match((VisitDetail)c).when(visitDetail -> Objects.isNull(visitDetail.visitDetailTypeCS)).then(addWarning));
    }

    @Override
    protected void afterCheck(WarningReporter reporter, CohortExpression expression) {
        if (!this.warnNames.isEmpty()) {
            reporter.add(WARNING, this.warnNames.stream().collect(Collectors.joining(", ")));
        }
    }
}

