/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.regarima;

import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.jdr.mapping.LikelihoodStatisticsInfo;
import ec.tstoolkit.jdr.mapping.ResidualsInfo;
import ec.tstoolkit.jdr.mapping.SarimaInfo;
import ec.tstoolkit.jdr.regarima.RegArimaInfo;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.tramo.TramoSpecification;
import ec.tstoolkit.modelling.arima.x13.RegArimaSpecification;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.LinkedHashMap;
import java.util.Map;
import jd2.algorithm.IProcResults;
import jd2.information.InformationMapping;
import jdr.spec.ts.Utility;
import lombok.Generated;

public final class Processor {
    public static Results tramo(TsData s, TramoSpecification spec, Utility.Dictionary dic) {
        s = s.cleanExtremities();
        ProcessingContext context = null;
        if (dic != null) {
            context = dic.toContext();
        }
        PreprocessingModel model = spec.build(context).process(s, null);
        return new Results(model);
    }

    public static Results x12(TsData s, RegArimaSpecification spec, Utility.Dictionary dic) {
        s = s.cleanExtremities();
        ProcessingContext context = null;
        if (dic != null) {
            context = dic.toContext();
        }
        PreprocessingModel model = spec.build(context).process(s, null);
        return new Results(model);
    }

    @Generated
    private Processor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Results
    implements IProcResults {
        private final PreprocessingModel model;
        static final InformationMapping<Results> MAPPING = new InformationMapping<Results>(Results.class);

        public InformationMapping<Results> getMapping() {
            return MAPPING;
        }

        @Override
        public boolean contains(String id) {
            return MAPPING.contains(id);
        }

        @Override
        public Map<String, Class> getDictionary() {
            LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
            MAPPING.fillDictionary(null, dic, true);
            return dic;
        }

        @Override
        public <T> T getData(String id, Class<T> tclass) {
            return MAPPING.getData(this, id, tclass);
        }

        @Generated
        public Results(PreprocessingModel model) {
            this.model = model;
        }

        @Generated
        public PreprocessingModel getModel() {
            return this.model;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Results)) {
                return false;
            }
            Results other = (Results)o;
            PreprocessingModel this$model = this.getModel();
            PreprocessingModel other$model = other.getModel();
            return !(this$model == null ? other$model != null : !this$model.equals(other$model));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PreprocessingModel $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Processor.Results(model=" + this.getModel() + ")";
        }

        static {
            MAPPING.delegate("model", RegArimaInfo.getMapping(), source -> source.getModel());
            MAPPING.delegate("arima", SarimaInfo.getMapping(), source -> source.getModel().estimation.getArima());
            MAPPING.delegate("likelihood", LikelihoodStatisticsInfo.getMapping(), source -> source.getModel().estimation.getStatistics());
            MAPPING.delegate("residuals", ResidualsInfo.getMapping(), source -> source.getModel().estimation.getNiidTests());
        }
    }
}

