/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Shared.ClassicalOptim;

import keel.Algorithms.Shared.ClassicalOptim.ConjGradQUAD;
import keel.Algorithms.Shared.ClassicalOptim.OPV;
import keel.Algorithms.Shared.ClassicalOptim.SquaresErrorQUAD;
import org.core.Randomize;

public class GCQuad {
    static final int MAX_ITER = 10000;
    static final double TOL_ERR = 1.0E-8;
    static final double MIN_DELTAGC = 1.0E-5;
    ConjGradQUAD Cua;
    double[] max_x;
    double[] min_x;
    double[] max_y;
    double[] min_y;
    double[] averageX;
    double[] averageY;
    double[][] inputs;
    double[][] outputs;
    double[][][] weights;

    public double cuatrain(int nInputs, int nOutputs, double[][] vInputs, double[][] vOutputs, Randomize r) {
        int i;
        int nElements = vInputs.length;
        System.out.println("Numero entradas=" + nInputs);
        System.out.println("Numero salidas=" + nOutputs);
        System.out.println("Numero ejemplos=" + nElements);
        this.inputs = ConjGradQUAD.duplicate(vInputs);
        this.outputs = ConjGradQUAD.duplicate(vOutputs);
        this.scale();
        this.averageX = ConjGradQUAD.duplicate(this.inputs[0]);
        this.averageY = ConjGradQUAD.duplicate(this.outputs[0]);
        for (i = 1; i < this.inputs.length; ++i) {
            this.averageX = OPV.sum(this.averageX, this.inputs[i]);
            this.averageY = OPV.sum(this.averageY, this.outputs[i]);
        }
        this.averageX = OPV.multiply(1.0 / (double)this.inputs.length, this.averageX);
        this.averageY = OPV.multiply(1.0 / (double)this.inputs.length, this.averageY);
        for (i = 0; i < this.inputs.length; ++i) {
            this.inputs[i] = OPV.subtract(this.inputs[i], this.averageX);
            this.outputs[i] = OPV.subtract(this.outputs[i], this.averageY);
        }
        this.Cua = new ConjGradQUAD(this.inputs, this.outputs, r);
        SquaresErrorQUAD Err = new SquaresErrorQUAD(this.Cua, this.inputs, this.outputs);
        this.weights = this.Cua.conjugatedGradient(Err, 1.0E-8, 1.0E-5, 10000);
        double RMS = 0.0;
        for (int i2 = 0; i2 < this.inputs.length; ++i2) {
            double[] s = this.cuaoutput(vInputs[i2]);
            double[] error = OPV.subtract(vOutputs[i2], s);
            RMS += OPV.multiply(error, error);
        }
        System.out.println("RMS train=" + (RMS /= (double)this.inputs.length));
        return RMS;
    }

    public double[] cuaoutput(double[] x) {
        double[] xScale = OPV.scale(x, this.max_x, this.min_x);
        double[] xAveScale = OPV.subtract(xScale, this.averageX);
        double[] output = this.Cua.quadraticModelOutput(xAveScale, this.weights);
        double[] aveOutput = OPV.sum(output, this.averageY);
        return OPV.invScale(aveOutput, this.max_y, this.min_y);
    }

    public void scale() {
        int i;
        for (i = 0; i < this.inputs.length; ++i) {
            if (i == 0) {
                this.max_x = ConjGradQUAD.duplicate(this.inputs[i]);
                this.max_y = ConjGradQUAD.duplicate(this.outputs[i]);
                this.min_x = ConjGradQUAD.duplicate(this.inputs[i]);
                this.min_y = ConjGradQUAD.duplicate(this.outputs[i]);
                continue;
            }
            this.max_x = OPV.maximum(this.max_x, this.inputs[i]);
            this.max_y = OPV.maximum(this.max_y, this.outputs[i]);
            this.min_x = OPV.minimum(this.min_x, this.inputs[i]);
            this.min_y = OPV.minimum(this.min_y, this.outputs[i]);
        }
        for (i = 0; i < this.inputs.length; ++i) {
            this.inputs[i] = OPV.scale(this.inputs[i], this.max_x, this.min_x);
        }
        for (i = 0; i < this.inputs.length; ++i) {
            this.outputs[i] = OPV.scale(this.outputs[i], this.max_y, this.min_y);
        }
    }
}

