/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOPNAR;

import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOPNAR.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOPNAR.Chromosome;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOPNAR.Gene;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.MOPNAR.myDataset;
import org.core.Randomize;

public class MOPNARProcess {
    private final int UPDATE_SOLUTION_NEIGHBOR = 1;
    private final int UPDATE_SOLUTION_WHOLEPOP = 2;
    private String paretos;
    private myDataset dataset;
    private int numObjectives;
    private int nTrials;
    private int H;
    private int T;
    private double probDelta;
    private int nr;
    private double pm;
    private double af;
    private int max_rank;
    private int updatePop;
    private double minSupport;
    private double percentUpdate;
    private int nAttr;
    private int nTrans;
    private int trials;
    private ArrayList<Chromosome> uPop;
    private ArrayList<Chromosome> EP;
    private double[] Z;
    private double[] Z_min;

    public MOPNARProcess(myDataset dataset, int numObjectives, int nTrials, int H, int T, double probDelta, int nr, double pm, double af, double percentUpdate) {
        this.dataset = dataset;
        this.nTrials = nTrials;
        this.H = H;
        this.T = T;
        this.probDelta = probDelta;
        this.nr = nr;
        this.pm = pm;
        this.af = af;
        this.minSupport = 0.01;
        this.percentUpdate = percentUpdate;
        this.numObjectives = numObjectives;
        this.nAttr = this.dataset.getnVars();
        this.nTrans = this.dataset.getnTrans();
        this.trials = 0;
        this.paretos = new String("");
        this.uPop = new ArrayList();
        this.EP = new ArrayList();
        this.Z = new double[this.numObjectives];
        this.Z_min = new double[this.numObjectives];
    }

    public void run() {
        int nGn = 0;
        this.trials = 0;
        this.paretos = new String("");
        System.out.println("Initialization");
        this.initializePopulation();
        do {
            System.out.println("Computing Generation " + (nGn + 1));
            this.updatePop = 0;
            this.diffEvolution();
            this.verifyRestartPop();
            ++nGn;
        } while (this.trials < this.nTrials);
        this.removeRedundant(this.EP);
        this.printPareto();
        System.out.println("done.\n");
    }

    private void verifyRestartPop() {
        double percentUpdate = (double)this.uPop.size() * this.percentUpdate / 100.0;
        if ((double)this.updatePop < percentUpdate) {
            this.restartPop();
        }
    }

    private ArrayList<Chromosome> nonDominateSelection(ArrayList<Chromosome> collection) {
        int counter = 1;
        ArrayList<Chromosome> result = new ArrayList<Chromosome>();
        result.add(collection.get(0));
        block0: while (counter < collection.size()) {
            Chromosome chromosome2 = collection.get(counter);
            int resultsize = result.size();
            boolean[] remove = new boolean[resultsize];
            for (int jj = 0; jj < resultsize; ++jj) {
                Chromosome chromosome1 = result.get(jj);
                int dominance = this.check_dominance(chromosome2, chromosome1);
                if (dominance == 1) {
                    remove[jj] = true;
                    continue;
                }
                if (dominance != -1) continue;
                ++counter;
                continue block0;
            }
            for (int i = remove.length - 1; i >= 0; --i) {
                if (!remove[i]) continue;
                result.remove(i);
            }
            result.add(chromosome2);
            ++counter;
        }
        return result;
    }

    private void updateEP(Chromosome child) {
        boolean add = true;
        for (int i = 0; i < this.EP.size(); ++i) {
            Chromosome chromosome1 = this.EP.get(i);
            int dominance = this.check_dominance(child, chromosome1);
            if (dominance == 1) {
                this.EP.remove(i);
                continue;
            }
            if (dominance != -1) continue;
            add = false;
        }
        if (add && !this.equalChromotoPop(child, this.EP)) {
            this.EP.add(child);
        }
    }

    private void diffEvolution() {
        int i;
        for (i = 0; i < this.uPop.size(); ++i) {
            int type = Randomize.Rand() < this.probDelta ? this.UPDATE_SOLUTION_NEIGHBOR : this.UPDATE_SOLUTION_WHOLEPOP;
            this.crossover(this.uPop.get(i), this.uPop.get(this.matingselection(i, type)), type, i);
        }
        for (i = 0; i < this.uPop.size(); ++i) {
            this.updateEP(this.uPop.get(i));
        }
        this.removeRedundant(this.EP);
    }

    private void crossover(Chromosome dad, Chromosome mom, int type, int pos_chromo) {
        int i;
        Gene[] genesSon1 = new Gene[this.nAttr];
        Gene[] genesSon2 = new Gene[this.nAttr];
        for (i = 0; i < this.nAttr; ++i) {
            if (dad.getGene(i).getActAs() != 1 && mom.getGene(i).getActAs() != 1) continue;
            genesSon1[i] = dad.getGene(i).copy();
            genesSon2[i] = mom.getGene(i).copy();
        }
        for (i = 0; i < this.nAttr; ++i) {
            if (dad.getGene(i).getActAs() == 1 || mom.getGene(i).getActAs() == 1) continue;
            if (Randomize.Rand() < 0.5) {
                genesSon1[i] = dad.getGene(i).copy();
                genesSon2[i] = mom.getGene(i).copy();
                continue;
            }
            genesSon1[i] = mom.getGene(i).copy();
            genesSon2[i] = dad.getGene(i).copy();
        }
        Chromosome son1 = new Chromosome(genesSon1, this.numObjectives, this.T);
        Chromosome son2 = new Chromosome(genesSon2, this.numObjectives, this.T);
        if (Randomize.Rand() < this.pm) {
            this.mutate(son1);
        }
        if (Randomize.Rand() < this.pm) {
            this.mutate(son2);
        }
        son1.forceConsistency();
        son2.forceConsistency();
        son1.computeObjetives(this.dataset);
        son2.computeObjetives(this.dataset);
        this.trials += 2;
        if (!this.equalChromotoPop(son1, this.uPop) && son1.getSupport() > this.minSupport && !(son1.getSupport() > 1.0 - this.minSupport) && son1.getCF() > 0.0) {
            this.update_Z(son1);
            this.updateSolutions(son1, type, pos_chromo);
        }
        if (!this.equalChromotoPop(son2, this.uPop) && son2.getSupport() > this.minSupport && !(son2.getSupport() > 1.0 - this.minSupport) && son2.getCF() > 0.0) {
            this.update_Z(son2);
            this.updateSolutions(son2, type, pos_chromo);
        }
    }

    private void mutate(Chromosome chr) {
        int i = Randomize.Randint(0, this.nAttr);
        Gene gene = chr.getGene(i);
        double type_attr = this.dataset.getAttributeType(i);
        double min_attr = this.dataset.getMin(i);
        double max_attr = this.dataset.getMax(i);
        if (type_attr != 0.0) {
            if (type_attr == 2.0) {
                if (Randomize.Rand() < 0.5) {
                    if (Randomize.Rand() < 0.5) {
                        double top = Math.max(gene.getUpperBound() - this.dataset.getAmplitude(i) / this.af, min_attr);
                        gene.setLowerBound(Randomize.RanddoubleClosed(top, gene.getLowerBound()));
                    } else {
                        gene.setLowerBound(Randomize.Randdouble(gene.getLowerBound(), gene.getUpperBound()));
                    }
                } else if (Randomize.Rand() < 0.5) {
                    double top = Math.min(gene.getLowerBound() + this.dataset.getAmplitude(i) / this.af, max_attr);
                    gene.setUpperBound(Randomize.RanddoubleClosed(gene.getUpperBound(), top));
                } else {
                    gene.setUpperBound(Randomize.RanddoubleClosed(gene.getLowerBound() + 1.0E-4, gene.getUpperBound()));
                }
            } else if (Randomize.Rand() < 0.5) {
                if (Randomize.Rand() < 0.5) {
                    double top = Math.max(gene.getUpperBound() - this.dataset.getAmplitude(i) / this.af, min_attr);
                    gene.setLowerBound(Randomize.RandintClosed((int)top, (int)gene.getLowerBound()));
                } else {
                    gene.setLowerBound(Randomize.Randint((int)gene.getLowerBound(), (int)gene.getUpperBound()));
                }
            } else if (Randomize.Rand() < 0.5) {
                double top = Math.min(gene.getLowerBound() + this.dataset.getAmplitude(i) / this.af, max_attr);
                gene.setUpperBound(Randomize.RandintClosed((int)gene.getUpperBound(), (int)top));
            } else {
                gene.setUpperBound(Randomize.RandintClosed((int)gene.getLowerBound() + 1, (int)gene.getUpperBound()));
            }
        } else {
            double top = Randomize.RandintClosed((int)min_attr, (int)max_attr);
            gene.setLowerBound(top);
            gene.setUpperBound(top);
        }
        gene.setIsPositiveInterval(Randomize.RandintClosed(0, 1) == 1);
        gene.setActAs(gene.randAct());
    }

    private int matingselection(int pos_chr, int type) {
        if (type == this.UPDATE_SOLUTION_NEIGHBOR) {
            return Randomize.Randint(0, this.T);
        }
        return Randomize.Randint(0, this.uPop.size());
    }

    private int[] random_permutation(int size) {
        int i;
        int[] index = new int[size];
        for (i = 0; i < size; ++i) {
            index[i] = i;
        }
        for (i = 0; i < size; ++i) {
            int j = Randomize.Randint(0, size);
            int tmp = index[i];
            index[i] = index[j];
            index[j] = tmp;
        }
        return index;
    }

    private void setWeightVectorsToEachChromo() {
        int i;
        Gene[] rnd_genes = new Gene[this.nAttr];
        double[] weightVector = new double[this.numObjectives];
        for (i = 0; i < this.nAttr; ++i) {
            rnd_genes[i] = new Gene();
        }
        for (i = 0; i <= this.H; ++i) {
            for (int j = 0; j <= this.H - i; ++j) {
                weightVector[0] = 1.0 * (double)i / (1.0 * (double)this.H);
                weightVector[1] = 1.0 * (double)j / (1.0 * (double)this.H);
                weightVector[2] = 1.0 * (double)(this.H - i - j) / (1.0 * (double)this.H);
                Chromosome chr = new Chromosome(rnd_genes, this.numObjectives, this.T);
                chr.setWeightVector(weightVector);
                this.uPop.add(chr);
            }
        }
    }

    private double[][] computeEuclidean() {
        int i;
        double[][] distance = new double[this.uPop.size()][this.uPop.size()];
        for (i = 0; i < this.uPop.size(); ++i) {
            distance[i][i] = 0.0;
        }
        for (i = 0; i < this.uPop.size(); ++i) {
            for (int j = i + 1; j < this.uPop.size(); ++j) {
                double d = this.uPop.get(i).computeDistance(this.uPop.get(j).getWeightVector());
                distance[j][i] = d;
                distance[i][j] = d;
            }
        }
        return distance;
    }

    private int[] closestVector(double[] dist, int vector) {
        int j;
        int i;
        int[] closest = new int[this.T];
        int[] index = new int[dist.length];
        for (i = 0; i < index.length; ++i) {
            index[i] = i;
        }
        for (i = 1; i < index.length; ++i) {
            for (j = 0; j < index.length - i; ++j) {
                if (!(dist[index[j + 1]] < dist[index[j]])) continue;
                int temp = index[j + 1];
                index[j + 1] = index[j];
                index[j] = temp;
            }
        }
        i = 0;
        j = 0;
        while (i < this.T) {
            if (index[j] != vector) {
                closest[i] = index[j];
                ++i;
            }
            ++j;
        }
        return closest;
    }

    private void computeWeightVectorsNeighbors() {
        double[][] distance = this.computeEuclidean();
        for (int i = 0; i < this.uPop.size(); ++i) {
            this.uPop.get(i).setVectorsNeighbors(this.closestVector(distance[i], i));
        }
    }

    private double bestObjectiveValue(int numberObj) {
        double bestValue;
        int i = 0;
        if (numberObj > 0) {
            bestValue = 1.0;
        } else {
            bestValue = this.uPop.get(0).getObjective(numberObj);
            for (i = 1; i < this.uPop.size(); ++i) {
                if (!(bestValue < this.uPop.get(i).getObjective(numberObj))) continue;
                bestValue = this.uPop.get(i).getObjective(numberObj);
            }
        }
        return bestValue;
    }

    private double minObjectiveValue(int numberObj) {
        double minValue = numberObj == 1 ? -1.0 : 0.0;
        return minValue;
    }

    private void initialize_Z() {
        for (int i = 0; i < this.numObjectives; ++i) {
            this.Z[i] = this.bestObjectiveValue(i);
            this.Z_min[i] = this.minObjectiveValue(i);
        }
    }

    private void initializePopulation() {
        int i;
        this.uPop.clear();
        this.setWeightVectorsToEachChromo();
        this.computeWeightVectorsNeighbors();
        ArrayList<Integer> tr_not_marked = new ArrayList<Integer>();
        this.trials = 0;
        for (i = 0; i < this.nTrans; ++i) {
            tr_not_marked.add(i);
        }
        int k = 0;
        while (k < this.uPop.size()) {
            if (tr_not_marked.size() == 0) {
                for (i = 0; i < this.nTrans; ++i) {
                    tr_not_marked.add(i);
                }
            }
            int pos = (Integer)tr_not_marked.get(Randomize.Randint(0, tr_not_marked.size()));
            Chromosome chromo = this.generateChromoCoveredPosNeg(pos);
            chromo.setWeightVector(this.uPop.get(k).getWeightVector());
            chromo.setVectorsNeighbors(this.uPop.get(k).getVectorsNeighbors());
            if (this.equalChromotoPop(chromo, this.uPop) || !(chromo.getSupport() > this.minSupport) || chromo.getSupport() > 1.0 - this.minSupport || !(chromo.getCF() > 0.0)) continue;
            this.uPop.set(k, chromo.copy());
            this.deleteTransCovered(this.uPop.get(k), tr_not_marked);
            ++k;
        }
        this.initialize_Z();
        this.EP = this.nonDominateSelection(this.uPop);
    }

    private Chromosome generateChromoCoveredPosNeg(int pos_example) {
        double ub;
        double lb;
        double value;
        int i;
        double[] example = this.dataset.getExample(pos_example);
        Gene[] rnd_genes = new Gene[this.nAttr];
        int[] sample = new int[this.nAttr];
        for (i = 0; i < this.nAttr; ++i) {
            rnd_genes[i] = new Gene();
        }
        for (i = 0; i < this.nAttr; ++i) {
            sample[i] = i;
        }
        rnd_genes = new Gene[this.nAttr];
        for (i = 0; i < this.nAttr; ++i) {
            rnd_genes[i] = new Gene();
        }
        for (i = 0; i < this.nAttr; ++i) {
            int j = Randomize.Randint(0, this.nAttr);
            int tmp = sample[i];
            sample[i] = sample[j];
            sample[j] = tmp;
        }
        int nAnts = Randomize.Randint(1, this.nAttr);
        for (i = 0; i < nAnts; ++i) {
            rnd_genes[sample[i]].setAttr(sample[i]);
            rnd_genes[sample[i]].setActAs(0);
            rnd_genes[sample[i]].setIsPositiveInterval(Randomize.RandintClosed(0, 1) == 1);
            value = example[sample[i]];
            if (this.dataset.getAttributeType(sample[i]) != 0) {
                if (this.dataset.getAttributeType(sample[i]) == 2) {
                    if (rnd_genes[sample[i]].getIsPositiveInterval()) {
                        lb = Math.max(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMin(sample[i]));
                        ub = Math.min(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMax(sample[i]));
                    } else if (value - this.dataset.getMin(sample[i]) > this.dataset.getMax(sample[i]) - value) {
                        lb = value - (value - this.dataset.getMin(sample[i]) - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0));
                        ub = this.dataset.getMin(sample[i]) + (value - this.dataset.getMin(sample[i]) - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0));
                    } else {
                        lb = this.dataset.getMax(sample[i]) - (this.dataset.getMax(sample[i]) - value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0));
                        ub = value + (this.dataset.getMax(sample[i]) - value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0));
                    }
                } else if (rnd_genes[sample[i]].getIsPositiveInterval()) {
                    lb = Math.max((double)((int)(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMin(sample[i]));
                    ub = Math.min((double)((int)(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMax(sample[i]));
                } else if (value - this.dataset.getMin(sample[i]) > this.dataset.getMax(sample[i]) - value) {
                    lb = (double)((int)value) - (value - this.dataset.getMin(sample[i]) - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0));
                    ub = (double)((int)this.dataset.getMin(sample[i])) + (value - this.dataset.getMin(sample[i]) - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0));
                } else {
                    lb = (double)((int)this.dataset.getMax(sample[i])) - (this.dataset.getMax(sample[i]) - value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0));
                    ub = (double)((int)value) + (this.dataset.getMax(sample[i]) - value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0));
                }
            } else {
                lb = ub = (double)((int)value);
            }
            rnd_genes[sample[i]].setLowerBound(lb);
            rnd_genes[sample[i]].setUpperBound(ub);
            rnd_genes[sample[i]].setType(this.dataset.getAttributeType(sample[i]));
            rnd_genes[sample[i]].setMin_attr(this.dataset.getMin(sample[i]));
            rnd_genes[sample[i]].setMax_attr(this.dataset.getMax(sample[i]));
        }
        rnd_genes[sample[i]].setAttr(sample[i]);
        rnd_genes[sample[i]].setActAs(1);
        value = example[sample[i]];
        if (this.dataset.getAttributeType(sample[i]) != 0) {
            if (this.dataset.getAttributeType(sample[i]) == 2) {
                lb = Math.max(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMin(sample[i]));
                ub = Math.min(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMax(sample[i]));
            } else {
                lb = Math.max((double)((int)(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMin(sample[i]));
                ub = Math.min((double)((int)(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMax(sample[i]));
            }
        } else {
            lb = ub = (double)((int)value);
        }
        rnd_genes[sample[i]].setLowerBound(lb);
        rnd_genes[sample[i]].setUpperBound(ub);
        rnd_genes[sample[i]].setType(this.dataset.getAttributeType(sample[i]));
        rnd_genes[sample[i]].setMin_attr(this.dataset.getMin(sample[i]));
        rnd_genes[sample[i]].setMax_attr(this.dataset.getMax(sample[i]));
        rnd_genes[sample[i]].setIsPositiveInterval(Randomize.RandintClosed(0, 1) == 1);
        for (i = nAnts + 1; i < this.nAttr; ++i) {
            rnd_genes[sample[i]].setAttr(sample[i]);
            rnd_genes[sample[i]].setActAs(-1);
            if (this.dataset.getAttributeType(sample[i]) != 0) {
                if (this.dataset.getAttributeType(sample[i]) == 2) {
                    value = Randomize.RanddoubleClosed(this.dataset.getMin(sample[i]), this.dataset.getMax(sample[i]));
                    lb = Math.max(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMin(sample[i]));
                    ub = Math.min(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0), this.dataset.getMax(sample[i]));
                } else {
                    value = Randomize.RandintClosed((int)this.dataset.getMin(sample[i]), (int)this.dataset.getMax(sample[i]));
                    lb = (int)Math.max((double)((int)(value - this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMin(sample[i]));
                    ub = (int)Math.min((double)((int)(value + this.dataset.getAmplitude(sample[i]) / (this.af * 4.0))), this.dataset.getMax(sample[i]));
                }
            } else {
                value = Randomize.RandintClosed((int)this.dataset.getMin(sample[i]), (int)this.dataset.getMax(sample[i]));
                lb = ub = (double)((int)value);
            }
            rnd_genes[sample[i]].setLowerBound(lb);
            rnd_genes[sample[i]].setUpperBound(ub);
            rnd_genes[sample[i]].setType(this.dataset.getAttributeType(sample[i]));
            rnd_genes[sample[i]].setMin_attr(this.dataset.getMin(sample[i]));
            rnd_genes[sample[i]].setMax_attr(this.dataset.getMax(sample[i]));
            rnd_genes[sample[i]].setIsPositiveInterval(Randomize.RandintClosed(0, 1) == 1);
        }
        Chromosome chromo = new Chromosome(rnd_genes, this.numObjectives, this.T);
        chromo.computeObjetives(this.dataset);
        ++this.trials;
        return chromo;
    }

    private void deleteTransCovered(Chromosome chromo, ArrayList<Integer> tr_not_marked) {
        for (int i = tr_not_marked.size() - 1; i >= 0; --i) {
            double[] example = this.dataset.getExample(tr_not_marked.get(i));
            if (!chromo.isCovered(example)) continue;
            tr_not_marked.remove(i);
        }
    }

    private ArrayList<Integer> tr_notCovered_NoDominateSolutions() {
        int i;
        ArrayList<Integer> tr_not_marked = new ArrayList<Integer>();
        for (i = 0; i < this.nTrans; ++i) {
            tr_not_marked.add(i);
        }
        for (i = 0; i < this.EP.size(); ++i) {
            this.deleteTransCovered(this.EP.get(i), tr_not_marked);
        }
        return tr_not_marked;
    }

    private void restartPop() {
        ArrayList<Integer> tr_not_marked = this.tr_notCovered_NoDominateSolutions();
        this.uPop.clear();
        this.setWeightVectorsToEachChromo();
        this.computeWeightVectorsNeighbors();
        int k = 0;
        int cont = 0;
        while (k < this.uPop.size()) {
            if (tr_not_marked.size() == 0) {
                for (int i = 0; i < this.nTrans; ++i) {
                    tr_not_marked.add(i);
                }
            }
            int pos = tr_not_marked.get(Randomize.Randint(0, tr_not_marked.size()));
            Chromosome chromo = this.generateChromoCoveredPosNeg(pos);
            chromo.setWeightVector(this.uPop.get(k).getWeightVector());
            chromo.setVectorsNeighbors(this.uPop.get(k).getVectorsNeighbors());
            if (!this.equalChromotoPop(chromo, this.uPop) && chromo.getSupport() > this.minSupport && !(chromo.getSupport() > 1.0 - this.minSupport) && chromo.getCF() > 0.0) {
                this.uPop.set(k, chromo.copy());
                this.deleteTransCovered(this.uPop.get(k), tr_not_marked);
                this.update_Z(chromo);
                this.updateEP(chromo);
                ++k;
                cont = 0;
                continue;
            }
            if (cont > 1000) {
                tr_not_marked.clear();
                cont = 0;
                continue;
            }
            ++cont;
        }
    }

    private void update_Z(Chromosome chr) {
        for (int i = 0; i < this.numObjectives; ++i) {
            if (this.Z[i] < chr.getObjective(i)) {
                this.Z[i] = chr.getObjective(i);
            }
            if (!(this.Z_min[i] > chr.getObjective(i))) continue;
            this.Z_min[i] = chr.getObjective(i);
        }
    }

    private void updateSolutions(Chromosome child, int type, int r1) {
        int numIndP = type == this.UPDATE_SOLUTION_NEIGHBOR ? this.T : this.uPop.size();
        int[] perm = this.random_permutation(numIndP);
        int c = 0;
        for (int i = 0; c <= this.nr && i < numIndP; ++i) {
            int l = type == this.UPDATE_SOLUTION_NEIGHBOR ? this.uPop.get(r1).getVectorsNeighbors(perm[i]) : perm[i];
            child.setWeightVector(this.uPop.get(l).getWeightVector());
            child.setVectorsNeighbors(this.uPop.get(l).getVectorsNeighbors());
            if (!(this.tchebycheffApproach(child) <= this.tchebycheffApproach(this.uPop.get(l)))) continue;
            this.uPop.set(l, child.copy());
            ++c;
        }
        if (c > 0) {
            ++this.updatePop;
        }
    }

    private double tchebycheffApproach(Chromosome chr) {
        double g_max = chr.getWeightVector(0) * (Math.abs(this.Z[0] - chr.getObjective(0)) / (this.Z[0] - this.Z_min[0]));
        for (int i = 1; i < this.numObjectives; ++i) {
            double g = chr.getWeightVector(i) * (Math.abs(this.Z[i] - chr.getObjective(i)) / (this.Z[i] - this.Z_min[i]));
            if (!(g > g_max)) continue;
            g_max = g;
        }
        return g_max;
    }

    private boolean equalChromotoPop(Chromosome chromo, ArrayList<Chromosome> pop) {
        boolean value = false;
        for (int i = 0; !value && i < pop.size(); ++i) {
            Chromosome aux = pop.get(i);
            if (!chromo.equals(aux)) continue;
            value = true;
        }
        return value;
    }

    static double roundDouble(double number, int decimalPlace) {
        if (!Double.isInfinite(number) && !Double.isNaN(number)) {
            BigDecimal bd = new BigDecimal(number);
            bd = bd.setScale(decimalPlace, 0);
            double numberRound = bd.doubleValue();
            return numberRound;
        }
        return number;
    }

    public void saveReport(ArrayList<AssociationRule> rules, PrintWriter w) {
        int i;
        double avg_sup = 0.0;
        double avg_conf = 0.0;
        double avg_ant_length = 0.0;
        double avg_lift = 0.0;
        double avg_conv = 0.0;
        double avg_CF = 0.0;
        double avg_netConf = 0.0;
        double avg_yulesQ = 0.0;
        int[] covered = new int[this.nTrans];
        for (i = 0; i < this.nTrans; ++i) {
            covered[i] = 0;
        }
        for (int r = 0; r < rules.size(); ++r) {
            AssociationRule rule = rules.get(r);
            avg_sup += rule.getSupport();
            avg_conf += rule.getConfidence();
            avg_lift += rule.getLift();
            avg_ant_length += (double)(rule.getnAnts() + 1);
            avg_conv += rule.getConv();
            avg_CF += rule.getCF();
            avg_netConf += rule.getNetConf();
            avg_yulesQ += rule.getYulesQ();
            for (int j = 0; j < this.nTrans; ++j) {
                if (covered[j] >= 1 || !rule.isCovered(this.dataset.getExample(j))) continue;
                covered[j] = 1;
            }
        }
        int cnt_cov_rec = 0;
        for (i = 0; i < this.nTrans; ++i) {
            cnt_cov_rec += covered[i];
        }
        w.println("\nNumber of Frequent Itemsets found: -");
        System.out.println("\nNumber of Frequent Itemsets found: -");
        w.println("\nNumber of Association Rules generated: " + rules.size());
        System.out.println("Number of Association Rules generated: " + rules.size());
        if (!rules.isEmpty()) {
            w.println("Average Support: " + MOPNARProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            System.out.println("Average Support: " + MOPNARProcess.roundDouble(avg_sup / (double)rules.size(), 2));
            w.println("Average Confidence: " + MOPNARProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            System.out.println("Average Confidence: " + MOPNARProcess.roundDouble(avg_conf / (double)rules.size(), 2));
            w.println("Average Lift: " + MOPNARProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            System.out.println("Average Lift: " + MOPNARProcess.roundDouble(avg_lift / (double)rules.size(), 2));
            w.println("Average Conviction: " + MOPNARProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            System.out.println("Average Conviction: " + MOPNARProcess.roundDouble(avg_conv / (double)rules.size(), 2));
            w.println("Average Certain Factor: " + MOPNARProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            System.out.println("Average Certain Factor: " + MOPNARProcess.roundDouble(avg_CF / (double)rules.size(), 2));
            w.println("Average Netconf: " + MOPNARProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            System.out.println("Average Netconf: " + MOPNARProcess.roundDouble(avg_netConf / (double)rules.size(), 2));
            w.println("Average YulesQ: " + MOPNARProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            System.out.println("Average YulesQ: " + MOPNARProcess.roundDouble(avg_yulesQ / (double)rules.size(), 2));
            w.println("Average Number of Antecedents: " + MOPNARProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            System.out.println("Average Number of Antecedents: " + MOPNARProcess.roundDouble(avg_ant_length / (double)rules.size(), 2));
            w.println("Number of Covered Records (%): " + MOPNARProcess.roundDouble(100.0 * (double)cnt_cov_rec / (double)this.nTrans, 2));
            System.out.println("Number of Covered Records (%): " + MOPNARProcess.roundDouble(100.0 * (double)cnt_cov_rec / (double)this.nTrans, 2));
        }
    }

    public void removeRedundant(ArrayList<Chromosome> upop) {
        Collections.sort(upop);
        for (int i = 0; i < upop.size(); ++i) {
            boolean stop = false;
            for (int j = upop.size() - 1; j >= 0 && !stop; --j) {
                if (j == i) continue;
                Chromosome chromo1 = upop.get(i);
                Chromosome chromo2 = upop.get(j);
                if (chromo1.getnAnts() == chromo2.getnAnts()) {
                    if (!chromo1.isSubChromo(chromo2)) continue;
                    if (chromo1.getCF() >= chromo2.getCF()) {
                        upop.remove(j);
                        if (j >= i) continue;
                        --i;
                        continue;
                    }
                    upop.remove(i);
                    --i;
                    stop = true;
                    continue;
                }
                if (chromo1.getnAnts() <= chromo2.getnAnts()) continue;
                stop = true;
            }
        }
    }

    public void printPareto() {
        boolean stop = false;
        this.paretos = this.paretos + "";
        this.paretos = this.paretos + "Support\tantecedent_support\tconsequent_support\tConfidence\tLift\tConv\tCF\tNetConf\tYulesQ\tnAttributes\n";
        for (int i = 0; i < this.EP.size() && !stop; ++i) {
            Chromosome chromo = this.EP.get(i);
            this.paretos = this.paretos + "" + MOPNARProcess.roundDouble(chromo.getSupport(), 2) + "\t" + MOPNARProcess.roundDouble(chromo.getAntsSupport(), 2) + "\t" + MOPNARProcess.roundDouble(chromo.getConsSupport(), 2) + "\t" + MOPNARProcess.roundDouble(chromo.getConfidence(), 2) + "\t" + MOPNARProcess.roundDouble(chromo.getObjective(0), 2) + "\t" + MOPNARProcess.roundDouble(chromo.getConv(), 2) + "\t" + MOPNARProcess.roundDouble(chromo.getCF(), 2) + "\t" + MOPNARProcess.roundDouble(chromo.getNetConf(), 2) + "\t" + MOPNARProcess.roundDouble(chromo.getYulesQ(), 2) + "\t" + (chromo.getnAnts() + 1) + "\n";
        }
    }

    public ArrayList<AssociationRule> generateRulesPareto() {
        ArrayList<AssociationRule> rulesPareto = new ArrayList<AssociationRule>();
        for (int i = 0; i < this.EP.size(); ++i) {
            Chromosome chromo = this.EP.get(i);
            rulesPareto.add(new AssociationRule(chromo));
        }
        return rulesPareto;
    }

    public String getParetos() {
        return this.paretos;
    }

    private int check_dominance(Chromosome a, Chromosome b) {
        boolean flag1 = false;
        boolean flag2 = false;
        for (int i = 0; i < this.numObjectives; ++i) {
            if (a.getObjective(i) > b.getObjective(i)) {
                flag1 = true;
                continue;
            }
            if (!(a.getObjective(i) < b.getObjective(i))) continue;
            flag2 = true;
        }
        if (flag1 && !flag2) {
            return 1;
        }
        if (!flag1 && flag2) {
            return -1;
        }
        return 0;
    }
}

