/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.Segment;
import cc.mallet.fst.SumLattice;
import cc.mallet.fst.SumLatticeFactory;
import cc.mallet.fst.Transducer;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelVector;
import cc.mallet.types.MatrixOps;
import cc.mallet.types.Sequence;
import cc.mallet.util.MalletLogger;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SumLatticeBeam
implements SumLattice {
    boolean UseForwardBackwardBeam = false;
    protected static int beamWidth = 3;
    private double KLeps = 0.0;
    private double Rmin = 0.1;
    private double[] nstatesExpl;
    private int curIter = 0;
    int tctIter = 0;
    private double curAvgNstatesExpl;
    private static Logger logger = MalletLogger.getLogger(SumLatticeBeam.class.getName());
    Transducer t;
    double weight;
    Sequence input;
    Sequence output;
    LatticeNode[][] nodes;
    int latticeLength;
    int curBeamWidth;
    double[][] gammas;
    double[][][] xis;
    LabelVector[] labelings;

    public int getBeamWidth() {
        return beamWidth;
    }

    public void setBeamWidth(int beamWidth) {
        SumLatticeBeam.beamWidth = beamWidth;
    }

    public int getTctIter() {
        return this.tctIter;
    }

    public void setCurIter(int curIter) {
        this.curIter = curIter;
        this.tctIter = 0;
    }

    public void incIter() {
        ++this.tctIter;
    }

    public void setKLeps(double KLeps) {
        this.KLeps = KLeps;
    }

    public void setRmin(double Rmin) {
        this.Rmin = Rmin;
    }

    public double[] getNstatesExpl() {
        return this.nstatesExpl;
    }

    public boolean getUseForwardBackwardBeam() {
        return this.UseForwardBackwardBeam;
    }

    public void setUseForwardBackwardBeam(boolean state) {
        this.UseForwardBackwardBeam = state;
    }

    private LatticeNode getLatticeNode(int ip, int stateIndex) {
        if (this.nodes[ip][stateIndex] == null) {
            this.nodes[ip][stateIndex] = new LatticeNode(ip, this.t.getState(stateIndex));
        }
        return this.nodes[ip][stateIndex];
    }

    public SumLatticeBeam(Transducer t, Sequence input, Sequence output, Transducer.Incrementor incrementor) {
        this(t, input, output, incrementor, false, null);
    }

    public SumLatticeBeam(Transducer t, Sequence input, Sequence output, Transducer.Incrementor incrementor, boolean saveXis) {
        this(t, input, output, incrementor, saveXis, null);
    }

    public SumLatticeBeam(Transducer t, Sequence input, Sequence output, Transducer.Incrementor incrementor, boolean saveXis, LabelAlphabet outputAlphabet) {
        int i;
        int ip;
        this.t = t;
        this.input = input;
        this.output = output;
        this.latticeLength = input.size() + 1;
        int numStates = t.numStates();
        this.nodes = new LatticeNode[this.latticeLength][numStates];
        this.gammas = new double[this.latticeLength][numStates];
        if (saveXis) {
            this.xis = new double[this.latticeLength][numStates][numStates];
        }
        double[][] outputCounts = null;
        if (outputAlphabet != null) {
            outputCounts = new double[this.latticeLength][outputAlphabet.size()];
        }
        for (int i2 = 0; i2 < numStates; ++i2) {
            for (int ip2 = 0; ip2 < this.latticeLength; ++ip2) {
                this.gammas[ip2][i2] = Double.NEGATIVE_INFINITY;
            }
            if (!saveXis) continue;
            for (int j = 0; j < numStates; ++j) {
                for (int ip3 = 0; ip3 < this.latticeLength; ++ip3) {
                    this.xis[ip3][i2][j] = Double.NEGATIVE_INFINITY;
                }
            }
        }
        logger.fine("Starting Foward pass");
        boolean atLeastOneInitialState = false;
        for (int i3 = 0; i3 < numStates; ++i3) {
            double initialWeight = t.getState(i3).getInitialWeight();
            if (!(initialWeight < Double.NEGATIVE_INFINITY)) continue;
            this.getLatticeNode((int)0, (int)i3).alpha = initialWeight;
            atLeastOneInitialState = true;
        }
        if (!atLeastOneInitialState) {
            logger.warning("There are no starting states!");
        }
        NBestSlist[] slists = new NBestSlist[this.latticeLength];
        this.nstatesExpl = new double[this.latticeLength];
        this.curBeamWidth = this.curIter == 0 ? numStates : (this.tctIter > 1 && this.curIter != 0 ? beamWidth : beamWidth);
        for (ip = 0; ip < this.latticeLength - 1; ++ip) {
            slists[ip] = new NBestSlist(numStates);
            slists[ip].setKLMinE(this.curBeamWidth);
            slists[ip].setKLeps(this.KLeps);
            slists[ip].setRmin(this.Rmin);
            for (int i4 = 0; i4 < numStates; ++i4) {
                if (this.nodes[ip][i4] == null || this.nodes[ip][i4].alpha == Double.NEGATIVE_INFINITY) continue;
                NBForBackNode cnode = new NBForBackNode(this.nodes[ip][i4].alpha, i4);
                slists[ip].push(cnode);
            }
            int KLMaxPos = 1;
            int RminPos = 1;
            if (this.KLeps > 0.0) {
                KLMaxPos = slists[ip].getKLpos();
                this.nstatesExpl[ip] = KLMaxPos;
            } else if (this.KLeps == 0.0) {
                if (this.Rmin > 0.0) {
                    RminPos = slists[ip].getTHRpos();
                } else {
                    slists[ip].setRmin(-this.Rmin);
                    RminPos = slists[ip].getTHRposSTRAWMAN();
                }
                this.nstatesExpl[ip] = RminPos;
            } else {
                slists[ip].setKLeps(-this.KLeps);
                KLMaxPos = slists[ip].getKLpos();
                if (this.Rmin > 0.0) {
                    RminPos = slists[ip].getTHRpos();
                } else {
                    slists[ip].setRmin(-this.Rmin);
                    RminPos = slists[ip].getTHRposSTRAWMAN();
                }
                this.nstatesExpl[ip] = KLMaxPos > RminPos ? (double)KLMaxPos : (double)RminPos;
            }
            for (int i5 = (int)this.nstatesExpl[ip] + 1; i5 < slists[ip].size(); ++i5) {
                int tmppos = slists[ip].getPosByIndex(i5);
                this.nodes[ip][tmppos].alpha = Double.NEGATIVE_INFINITY;
                this.nodes[ip][tmppos] = null;
            }
            int jj = 0;
            while ((double)jj < this.nstatesExpl[ip]) {
                int i6 = slists[ip].getPosByIndex(jj);
                Transducer.State s = t.getState(i6);
                Transducer.TransitionIterator iter = s.transitionIterator(input, ip, output, ip);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" Starting Foward transition iteration from state " + s.getName() + " on input " + input.get(ip).toString() + " and output " + (output == null ? "(null)" : output.get(ip).toString()));
                }
                while (iter.hasNext()) {
                    Transducer.State destination = iter.nextState();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Forward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                    }
                    LatticeNode destinationNode = this.getLatticeNode(ip + 1, destination.getIndex());
                    destinationNode.output = iter.getOutput();
                    double transitionWeight = iter.getWeight();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("transitionWeight=" + transitionWeight + " nodes[" + ip + "][" + i6 + "].alpha=" + this.nodes[ip][i6].alpha + " destinationNode.alpha=" + destinationNode.alpha);
                    }
                    destinationNode.alpha = Transducer.sumLogProb(destinationNode.alpha, this.nodes[ip][i6].alpha + transitionWeight);
                }
                ++jj;
            }
        }
        this.curAvgNstatesExpl = MatrixOps.mean(this.nstatesExpl);
        this.weight = Double.NEGATIVE_INFINITY;
        for (i = 0; i < numStates; ++i) {
            if (this.nodes[this.latticeLength - 1][i] == null) continue;
            this.weight = Transducer.sumLogProb(this.weight, this.nodes[this.latticeLength - 1][i].alpha + t.getState(i).getFinalWeight());
        }
        if (this.weight == Double.NEGATIVE_INFINITY) {
            return;
        }
        for (i = 0; i < numStates; ++i) {
            if (this.nodes[this.latticeLength - 1][i] == null) continue;
            Transducer.State s = t.getState(i);
            this.nodes[this.latticeLength - 1][i].beta = s.getFinalWeight();
            this.gammas[this.latticeLength - 1][i] = this.nodes[this.latticeLength - 1][i].alpha + this.nodes[this.latticeLength - 1][i].beta - this.weight;
            if (incrementor == null) continue;
            double p = Math.exp(this.gammas[this.latticeLength - 1][i]);
            assert (p > Double.NEGATIVE_INFINITY && !Double.isNaN(p)) : "p=" + p + " gamma=" + this.gammas[this.latticeLength - 1][i];
            incrementor.incrementFinalState(s, p);
        }
        for (ip = this.latticeLength - 2; ip >= 0; --ip) {
            int i7;
            for (int i8 = 0; i8 < numStates; ++i8) {
                if (this.nodes[ip][i8] == null || this.nodes[ip][i8].alpha == Double.NEGATIVE_INFINITY) continue;
                Transducer.State s = t.getState(i8);
                Transducer.TransitionIterator iter = s.transitionIterator(input, ip, output, ip);
                while (iter.hasNext()) {
                    int j;
                    LatticeNode destinationNode;
                    Transducer.State destination = iter.nextState();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Backward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                    }
                    if ((destinationNode = this.nodes[ip + 1][j = destination.getIndex()]) == null) continue;
                    double transitionWeight = iter.getWeight();
                    assert (!Double.isNaN(transitionWeight));
                    double oldBeta = this.nodes[ip][i8].beta;
                    assert (!Double.isNaN(this.nodes[ip][i8].beta));
                    this.nodes[ip][i8].beta = Transducer.sumLogProb(this.nodes[ip][i8].beta, destinationNode.beta + transitionWeight);
                    assert (!Double.isNaN(this.nodes[ip][i8].beta)) : "dest.beta=" + destinationNode.beta + " trans=" + transitionWeight + " sum=" + (destinationNode.beta + transitionWeight) + " oldBeta=" + oldBeta;
                    double xi = this.nodes[ip][i8].alpha + transitionWeight + this.nodes[ip + 1][j].beta - this.weight;
                    if (saveXis) {
                        this.xis[ip][i8][j] = xi;
                    }
                    assert (!Double.isNaN(this.nodes[ip][i8].alpha));
                    assert (!Double.isNaN(transitionWeight));
                    assert (!Double.isNaN(this.nodes[ip + 1][j].beta));
                    assert (!Double.isNaN(this.weight));
                    if (incrementor == null && outputAlphabet == null) continue;
                    double p = Math.exp(xi);
                    assert (p > Double.NEGATIVE_INFINITY && !Double.isNaN(p)) : "xis[" + ip + "][" + i8 + "][" + j + "]=" + xi;
                    if (incrementor != null) {
                        incrementor.incrementTransition(iter, p);
                    }
                    if (outputAlphabet == null) continue;
                    int outputIndex = outputAlphabet.lookupIndex(iter.getOutput(), false);
                    assert (outputIndex >= 0);
                    double[] dArray = outputCounts[ip];
                    int n = outputIndex;
                    dArray[n] = dArray[n] + p;
                }
                this.gammas[ip][i8] = this.nodes[ip][i8].alpha + this.nodes[ip][i8].beta - this.weight;
            }
            double checknorm = Double.NEGATIVE_INFINITY;
            for (i7 = 0; i7 < numStates; ++i7) {
                if (this.nodes[ip][i7] == null) continue;
                checknorm = Transducer.sumLogProb(checknorm, this.gammas[ip][i7]);
            }
            for (i7 = 0; i7 < numStates; ++i7) {
                if (this.nodes[ip][i7] == null) continue;
                this.gammas[ip][i7] = this.gammas[ip][i7] - checknorm;
            }
        }
        if (incrementor != null) {
            for (i = 0; i < numStates; ++i) {
                double p = Math.exp(this.gammas[0][i]);
                assert (p > Double.NEGATIVE_INFINITY && !Double.isNaN(p));
                incrementor.incrementInitialState(t.getState(i), p);
            }
        }
        if (outputAlphabet != null) {
            this.labelings = new LabelVector[this.latticeLength];
            for (ip = this.latticeLength - 2; ip >= 0; --ip) {
                assert (Math.abs(1.0 - MatrixOps.sum(outputCounts[ip])) < 1.0E-6);
                this.labelings[ip] = new LabelVector(outputAlphabet, outputCounts[ip]);
            }
        }
    }

    @Override
    public Sequence getInput() {
        return this.input;
    }

    SumLatticeBeam(Transducer t, Sequence inputSequence, Sequence outputSequence, Segment requiredSegment, Sequence constrainedSequence) {
        this(t, inputSequence, outputSequence, (Transducer.Incrementor)null, null, SumLatticeBeam.makeConstraints(t, inputSequence, outputSequence, requiredSegment, constrainedSequence));
    }

    private static int[] makeConstraints(Transducer t, Sequence inputSequence, Sequence outputSequence, Segment requiredSegment, Sequence constrainedSequence) {
        if (constrainedSequence.size() != inputSequence.size()) {
            throw new IllegalArgumentException("constrainedSequence.size [" + constrainedSequence.size() + "] != inputSequence.size [" + inputSequence.size() + "]");
        }
        int[] constraints = new int[constrainedSequence.size() + 1];
        for (int c = 0; c < constraints.length; ++c) {
            constraints[c] = 0;
        }
        for (int i = requiredSegment.getStart(); i <= requiredSegment.getEnd(); ++i) {
            int si = t.stateIndexOfString((String)constrainedSequence.get(i));
            if (si == -1) {
                logger.warning("Could not find state " + constrainedSequence.get(i) + ". Check that state labels match startTages and inTags, and that all labels are seen in training data.");
            }
            constraints[i + 1] = si + 1;
        }
        if (requiredSegment.getEnd() + 2 < constraints.length) {
            String endTag = requiredSegment.getInTag().toString();
            int statei = t.stateIndexOfString(endTag);
            if (statei == -1) {
                throw new IllegalArgumentException("Could not find state " + endTag + ". Check that state labels match startTags and InTags.");
            }
            constraints[requiredSegment.getEnd() + 2] = -(statei + 1);
        }
        logger.fine("Segment:\n" + requiredSegment.sequenceToString() + "\nconstrainedSequence:\n" + constrainedSequence + "\nConstraints:\n");
        for (int i = 0; i < constraints.length; ++i) {
            logger.fine(constraints[i] + "\t");
        }
        logger.fine("");
        return constraints;
    }

    public SumLatticeBeam(Transducer t, Sequence input, Sequence output, Transducer.Incrementor incrementor, LabelAlphabet outputAlphabet, int[] constraints) {
        double transitionWeight;
        LatticeNode destinationNode;
        Transducer.State destination;
        Transducer.TransitionIterator iter;
        int i;
        int ip;
        this.t = t;
        this.input = input;
        this.output = output;
        this.latticeLength = input.size() + 1;
        int numStates = t.numStates();
        this.nodes = new LatticeNode[this.latticeLength][numStates];
        this.gammas = new double[this.latticeLength][numStates];
        double[][] outputCounts = null;
        if (outputAlphabet != null) {
            outputCounts = new double[this.latticeLength][outputAlphabet.size()];
        }
        for (int i2 = 0; i2 < numStates; ++i2) {
            for (ip = 0; ip < this.latticeLength; ++ip) {
                this.gammas[ip][i2] = Double.NEGATIVE_INFINITY;
            }
        }
        logger.fine("Starting Constrained Foward pass");
        boolean atLeastOneInitialState = false;
        for (i = 0; i < numStates; ++i) {
            double initialWeight = t.getState(i).getInitialWeight();
            if (!(initialWeight > Double.NEGATIVE_INFINITY)) continue;
            this.getLatticeNode((int)0, (int)i).alpha = initialWeight;
            atLeastOneInitialState = true;
        }
        if (!atLeastOneInitialState) {
            logger.warning("There are no starting states!");
        }
        for (ip = 0; ip < this.latticeLength - 1; ++ip) {
            for (int i3 = 0; i3 < numStates; ++i3) {
                logger.fine("ip=" + ip + ", i=" + i3);
                if (constraints[ip] > 0) {
                    if (constraints[ip] - 1 != i3) {
                        logger.fine("Current state does not match positive constraint. position=" + ip + ", constraint=" + (constraints[ip] - 1) + ", currState=" + i3);
                        continue;
                    }
                } else if (constraints[ip] < 0 && constraints[ip] + 1 == -i3) {
                    logger.fine("Current state does not match negative constraint. position=" + ip + ", constraint=" + (constraints[ip] + 1) + ", currState=" + i3);
                    continue;
                }
                if (this.nodes[ip][i3] == null || this.nodes[ip][i3].alpha == Double.NEGATIVE_INFINITY) {
                    if (this.nodes[ip][i3] == null) {
                        logger.fine("nodes[ip][i] is NULL");
                    } else if (this.nodes[ip][i3].alpha == Double.NEGATIVE_INFINITY) {
                        logger.fine("nodes[ip][i].alpha is Inf");
                    }
                    logger.fine("-INFINITE weight or NULL...skipping");
                    continue;
                }
                Transducer.State s = t.getState(i3);
                iter = s.transitionIterator(input, ip, output, ip);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine(" Starting Forward transition iteration from state " + s.getName() + " on input " + input.get(ip).toString() + " and output " + (output == null ? "(null)" : output.get(ip).toString()));
                }
                while (iter.hasNext()) {
                    destination = iter.nextState();
                    boolean legalTransition = true;
                    if (ip + 1 < constraints.length && constraints[ip + 1] > 0 && constraints[ip + 1] - 1 != destination.getIndex()) {
                        logger.fine("Destination state does not match positive constraint. Assigning -infinite weight. position=" + (ip + 1) + ", constraint=" + (constraints[ip + 1] - 1) + ", source =" + i3 + ", destination=" + destination.getIndex());
                        legalTransition = false;
                    } else if (ip + 1 < constraints.length && constraints[ip + 1] < 0 && -(constraints[ip + 1] + 1) == destination.getIndex()) {
                        logger.fine("Destination state does not match negative constraint. Assigning -infinite weight. position=" + (ip + 1) + ", constraint=" + (constraints[ip + 1] + 1) + ", destination=" + destination.getIndex());
                        legalTransition = false;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Forward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                    }
                    destinationNode = this.getLatticeNode(ip + 1, destination.getIndex());
                    destinationNode.output = iter.getOutput();
                    transitionWeight = iter.getWeight();
                    if (legalTransition) {
                        logger.fine("transitionWeight=" + transitionWeight + " nodes[" + ip + "][" + i3 + "].alpha=" + this.nodes[ip][i3].alpha + " destinationNode.alpha=" + destinationNode.alpha);
                        destinationNode.alpha = Transducer.sumLogProb(destinationNode.alpha, this.nodes[ip][i3].alpha + transitionWeight);
                        logger.fine("Set alpha of latticeNode at ip = " + (ip + 1) + " stateIndex = " + destination.getIndex() + ", destinationNode.alpha = " + destinationNode.alpha);
                        continue;
                    }
                    logger.fine("Illegal transition from state " + i3 + " to state " + destination.getIndex() + ". Setting alpha to Inf");
                }
            }
        }
        this.weight = Double.NEGATIVE_INFINITY;
        for (i = 0; i < numStates; ++i) {
            if (this.nodes[this.latticeLength - 1][i] == null || constraints[this.latticeLength - 1] > 0 && i != constraints[this.latticeLength - 1] - 1 || constraints[this.latticeLength - 1] < 0 && -i == constraints[this.latticeLength - 1] + 1) continue;
            logger.fine("Summing final lattice weight. state=" + i + ", alpha=" + this.nodes[this.latticeLength - 1][i].alpha + ", final weight = " + t.getState(i).getFinalWeight());
            this.weight = Transducer.sumLogProb(this.weight, this.nodes[this.latticeLength - 1][i].alpha + t.getState(i).getFinalWeight());
        }
        if (this.weight == Double.NEGATIVE_INFINITY) {
            return;
        }
        for (i = 0; i < numStates; ++i) {
            if (this.nodes[this.latticeLength - 1][i] == null) continue;
            Transducer.State s = t.getState(i);
            this.nodes[this.latticeLength - 1][i].beta = s.getFinalWeight();
            this.gammas[this.latticeLength - 1][i] = this.nodes[this.latticeLength - 1][i].alpha + this.nodes[this.latticeLength - 1][i].beta - this.weight;
            if (incrementor == null) continue;
            double p = Math.exp(this.gammas[this.latticeLength - 1][i]);
            assert (p >= 0.0 && p <= 1.0 && !Double.isNaN(p)) : "p=" + p + " gamma=" + this.gammas[this.latticeLength - 1][i];
            incrementor.incrementFinalState(s, p);
        }
        for (ip = this.latticeLength - 2; ip >= 0; --ip) {
            for (int i4 = 0; i4 < numStates; ++i4) {
                if (this.nodes[ip][i4] == null || this.nodes[ip][i4].alpha == Double.NEGATIVE_INFINITY) continue;
                Transducer.State s = t.getState(i4);
                iter = s.transitionIterator(input, ip, output, ip);
                while (iter.hasNext()) {
                    int j;
                    destination = iter.nextState();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Backward Lattice[inputPos=" + ip + "][source=" + s.getName() + "][dest=" + destination.getName() + "]");
                    }
                    if ((destinationNode = this.nodes[ip + 1][j = destination.getIndex()]) == null) continue;
                    transitionWeight = iter.getWeight();
                    assert (!Double.isNaN(transitionWeight));
                    double oldBeta = this.nodes[ip][i4].beta;
                    assert (!Double.isNaN(this.nodes[ip][i4].beta));
                    this.nodes[ip][i4].beta = Transducer.sumLogProb(this.nodes[ip][i4].beta, destinationNode.beta + transitionWeight);
                    assert (!Double.isNaN(this.nodes[ip][i4].beta)) : "dest.beta=" + destinationNode.beta + " trans=" + transitionWeight + " sum=" + (destinationNode.beta + transitionWeight) + " oldBeta=" + oldBeta;
                    assert (!Double.isNaN(this.nodes[ip][i4].alpha));
                    assert (!Double.isNaN(transitionWeight));
                    assert (!Double.isNaN(this.nodes[ip + 1][j].beta));
                    assert (!Double.isNaN(this.weight));
                    if (incrementor == null && outputAlphabet == null) continue;
                    double xi = this.nodes[ip][i4].alpha + transitionWeight + this.nodes[ip + 1][j].beta - this.weight;
                    double p = Math.exp(xi);
                    assert (p >= 0.0 && p <= 1.0 && !Double.isNaN(p)) : "xis[" + ip + "][" + i4 + "][" + j + "]=" + -xi;
                    if (incrementor != null) {
                        incrementor.incrementTransition(iter, p);
                    }
                    if (outputAlphabet == null) continue;
                    int outputIndex = outputAlphabet.lookupIndex(iter.getOutput(), false);
                    assert (outputIndex >= 0);
                    double[] dArray = outputCounts[ip];
                    int n = outputIndex;
                    dArray[n] = dArray[n] + p;
                }
                this.gammas[ip][i4] = this.nodes[ip][i4].alpha + this.nodes[ip][i4].beta - this.weight;
            }
        }
        if (incrementor != null) {
            for (i = 0; i < numStates; ++i) {
                double p = Math.exp(this.gammas[0][i]);
                assert (p >= 0.0 && p <= 1.0 && !Double.isNaN(p));
                incrementor.incrementInitialState(t.getState(i), p);
            }
        }
        if (outputAlphabet != null) {
            this.labelings = new LabelVector[this.latticeLength];
            for (ip = this.latticeLength - 2; ip >= 0; --ip) {
                assert (Math.abs(1.0 - MatrixOps.sum(outputCounts[ip])) < 1.0E-6);
                this.labelings[ip] = new LabelVector(outputAlphabet, outputCounts[ip]);
            }
        }
    }

    @Override
    public double getTotalWeight() {
        assert (!Double.isNaN(this.weight));
        return this.weight;
    }

    @Override
    public double getGammaWeight(int inputPosition, Transducer.State s) {
        return this.gammas[inputPosition][s.getIndex()];
    }

    @Override
    public double getGammaProbability(int inputPosition, Transducer.State s) {
        return Math.exp(this.gammas[inputPosition][s.getIndex()]);
    }

    @Override
    public double[][][] getXis() {
        return this.xis;
    }

    @Override
    public double[][] getGammas() {
        return this.gammas;
    }

    @Override
    public double getXiProbability(int ip, Transducer.State s1, Transducer.State s2) {
        if (this.xis == null) {
            throw new IllegalStateException("xis were not saved.");
        }
        int i = s1.getIndex();
        int j = s2.getIndex();
        return Math.exp(this.xis[ip][i][j]);
    }

    @Override
    public double getXiWeight(int ip, Transducer.State s1, Transducer.State s2) {
        if (this.xis == null) {
            throw new IllegalStateException("xis were not saved.");
        }
        int i = s1.getIndex();
        int j = s2.getIndex();
        return this.xis[ip][i][j];
    }

    @Override
    public int length() {
        return this.latticeLength;
    }

    @Override
    public double getAlpha(int ip, Transducer.State s) {
        LatticeNode node = this.getLatticeNode(ip, s.getIndex());
        return node.alpha;
    }

    @Override
    public double getBeta(int ip, Transducer.State s) {
        LatticeNode node = this.getLatticeNode(ip, s.getIndex());
        return node.beta;
    }

    @Override
    public LabelVector getLabelingAtPosition(int outputPosition) {
        if (this.labelings != null) {
            return this.labelings[outputPosition];
        }
        return null;
    }

    @Override
    public Transducer getTransducer() {
        return this.t;
    }

    public static class Factory
    extends SumLatticeFactory {
        int bw;

        public Factory(int beamWidth) {
            this.bw = beamWidth;
        }

        @Override
        public SumLattice newSumLattice(Transducer trans, Sequence input, Sequence output, Transducer.Incrementor incrementor, boolean saveXis, LabelAlphabet outputAlphabet) {
            return new SumLatticeBeam(trans, input, output, incrementor, saveXis, outputAlphabet){
                {
                    super(t, input, output, incrementor, saveXis, outputAlphabet);
                    beamWidth = bw;
                }
            };
        }
    }

    private class LatticeNode {
        int inputPosition;
        Transducer.State state;
        Object output;
        double alpha = Double.NEGATIVE_INFINITY;
        double beta = Double.NEGATIVE_INFINITY;

        LatticeNode(int inputPosition, Transducer.State state) {
            this.inputPosition = inputPosition;
            this.state = state;
            assert (this.alpha == Double.NEGATIVE_INFINITY);
        }
    }

    private class NBestSlist {
        ArrayList list = new ArrayList();
        int MaxElements;
        int KLMinElements;
        int KLMaxPos;
        double KLeps;
        double Rmin;

        NBestSlist(int MaxElements) {
            this.MaxElements = MaxElements;
        }

        boolean setKLMinE(int KLMinElements) {
            this.KLMinElements = KLMinElements;
            return true;
        }

        int size() {
            return this.list.size();
        }

        boolean empty() {
            return this.list.isEmpty();
        }

        Object pop() {
            return this.list.remove(0);
        }

        int getPosByIndex(int ii) {
            NBForBackNode tn = (NBForBackNode)this.list.get(ii);
            return tn.pos;
        }

        double getWeightByIndex(int ii) {
            NBForBackNode tn = (NBForBackNode)this.list.get(ii);
            return tn.weight;
        }

        void setKLeps(double KLeps) {
            this.KLeps = KLeps;
        }

        void setRmin(double Rmin) {
            this.Rmin = Rmin;
        }

        int getTHRpos() {
            NBForBackNode tn = (NBForBackNode)this.list.get(0);
            double lc1 = tn.weight;
            tn = (NBForBackNode)this.list.get(this.list.size() - 1);
            double lc2 = tn.weight;
            double minc = lc1 - lc2;
            double mincTHR = minc - minc * this.Rmin;
            for (int i = 1; i < this.list.size(); ++i) {
                tn = (NBForBackNode)this.list.get(i);
                lc1 = tn.weight - lc2;
                if (!(lc1 > mincTHR)) continue;
                return i + 1;
            }
            return this.list.size();
        }

        int getTHRposSTRAWMAN() {
            NBForBackNode tn = (NBForBackNode)this.list.get(0);
            double lc1 = tn.weight;
            double mincTHR = -lc1 * this.Rmin;
            for (int i = 1; i < this.list.size(); ++i) {
                tn = (NBForBackNode)this.list.get(i);
                lc1 = -tn.weight;
                if (!(lc1 < mincTHR)) continue;
                return i + 1;
            }
            return this.list.size();
        }

        int getKLpos() {
            int i;
            double[] CSNLP = new double[this.MaxElements];
            NBForBackNode tn = (NBForBackNode)this.list.get(this.list.size() - 1);
            double worstc = tn.weight;
            for (i = 0; i < this.list.size(); ++i) {
                tn = (NBForBackNode)this.list.get(i);
                double lc = tn.weight;
                CSNLP[i] = i == 0 ? lc : Transducer.sumLogProb(CSNLP[i - 1], lc);
            }
            for (i = 0; i < this.list.size(); ++i) {
                CSNLP[i] = CSNLP[i] - CSNLP[this.list.size() - 1];
                if (!(CSNLP[i] < this.KLeps)) continue;
                this.KLMaxPos = i + 1;
                if (this.KLMaxPos >= this.KLMinElements) {
                    return this.KLMaxPos;
                }
                if (this.list.size() < this.KLMinElements) continue;
                return this.KLMinElements;
            }
            this.KLMaxPos = this.list.size();
            return this.KLMaxPos;
        }

        ArrayList push(NBForBackNode vn) {
            double tc = vn.weight;
            boolean atEnd = true;
            for (int i = 0; i < this.list.size(); ++i) {
                NBForBackNode tn = (NBForBackNode)this.list.get(i);
                double lc = tn.weight;
                if (!(tc < lc)) continue;
                this.list.add(i, vn);
                atEnd = false;
                break;
            }
            if (atEnd) {
                this.list.add(vn);
            }
            if (this.list.size() > this.MaxElements) {
                this.list.remove(this.MaxElements);
            }
            return this.list;
        }
    }

    private class NBForBackNode {
        double weight;
        int pos;

        NBForBackNode(double weight, int pos) {
            this.weight = weight;
            this.pos = pos;
        }
    }
}

