/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractBinIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.BitSet;

public final class ModuloXYC2
extends AbstractBinIntSConstraint {
    protected final int m;

    public ModuloXYC2(IntDomainVar x0, IntDomainVar x1, int c) {
        super(x0, x1);
        this.m = c;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == 0) {
            if (this.v0.hasEnumeratedDomain()) {
                return 12;
            }
            return 11;
        }
        if (this.v1.hasEnumeratedDomain()) {
            return 12;
        }
        return 11;
    }

    @Override
    public void awake() throws ContradictionException {
        this.v0.setInf(0);
        this.v0.setSup(this.m - 1);
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        BitSet sup = this.searchSupports();
        if (this.v0.hasEnumeratedDomain()) {
            int j = sup.nextSetBit(0);
            while (j >= 0) {
                this.v0.removeVal(j, this, false);
                j = sup.nextSetBit(j + 1);
            }
        } else {
            int min;
            int max = min = sup.nextClearBit(0);
            int j = min;
            while (j >= 0 && j < this.m) {
                max = j;
                j = sup.nextClearBit(j + 1);
            }
            this.v0.updateSup(max, this, false);
            this.v0.updateInf(min, this, false);
        }
        if (this.v1.hasEnumeratedDomain()) {
            IntDomain dom = this.v1.getDomain();
            int val = dom.getInf();
            while (val <= dom.getSup()) {
                if (!this.v0.canBeInstantiatedTo(val % this.m)) {
                    this.v1.removeVal(val, this, false);
                }
                val = dom.getNextValue(val);
            }
        } else {
            this.v1.setInf(this.searchInfV1());
            this.v1.setSup(this.searchSupV1());
        }
    }

    public BitSet searchSupportsP() {
        BitSet bs = new BitSet();
        IntDomain dom = this.v1.getDomain();
        int val = dom.getInf();
        while (val <= dom.getSup() && bs.cardinality() < this.m) {
            bs.set(val % this.m);
            val = dom.getNextValue(val);
        }
        return bs;
    }

    public BitSet searchSupports() {
        BitSet bs = new BitSet();
        bs.set(0, this.m);
        IntDomain dom = this.v1.getDomain();
        int val = dom.getInf();
        while (val <= dom.getSup() && bs.cardinality() > 0) {
            if (bs.get(val % this.m)) {
                bs.clear(val % this.m);
            }
            val = dom.getNextValue(val);
        }
        return bs;
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx == 0) {
            this.reviseV1OnInf();
        } else if (idx == 1) {
            this.reviseV0OnInf(this.searchSupports());
        }
    }

    public void reviseV0OnInf(BitSet supports) throws ContradictionException {
        if (this.v0.hasEnumeratedDomain()) {
            int i = supports.nextSetBit(0);
            while (i >= 0) {
                this.v0.removeVal(i, this, false);
                i = supports.nextSetBit(i + 1);
            }
        } else {
            int min = supports.nextClearBit(0);
            this.v0.updateInf(min, this, false);
        }
    }

    public void reviseV1OnInf() throws ContradictionException {
        if (this.v1.hasEnumeratedDomain()) {
            IntDomain dom = this.v1.getDomain();
            int inf = this.v0.getInf();
            int val = dom.getInf();
            while (val <= dom.getSup()) {
                if (val % this.m < inf) {
                    this.v1.removeVal(val, this, false);
                }
                val = dom.getNextValue(val);
            }
        } else {
            this.v1.setInf(this.searchInfV1());
        }
    }

    public int searchInfV1() {
        int n = this.v1.getInf() / this.m * this.m;
        if (this.v1.getInf() % this.m > this.v0.getSup()) {
            return this.v0.getInf() + n + this.m;
        }
        if (this.v1.getInf() % this.m == this.v0.getSup()) {
            return this.v1.getInf();
        }
        if (this.v1.getInf() % this.m <= this.v0.getInf()) {
            return this.v0.getInf() + n;
        }
        IntDomain dom = this.v0.getDomain();
        int inf = dom.getNextValue(this.v1.getInf() % this.m - 1);
        return inf + n;
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == 0) {
            this.reviseV1OnSup();
        } else if (idx == 1) {
            this.reviseV0OnSup(this.searchSupports());
        }
    }

    public void reviseV0OnSup(BitSet supports) throws ContradictionException {
        if (this.v0.hasEnumeratedDomain()) {
            int i = supports.nextSetBit(0);
            while (i >= 0) {
                this.v0.removeVal(i, this, false);
                i = supports.nextSetBit(i + 1);
            }
        } else {
            int max;
            int j = max = supports.nextClearBit(0);
            while (j >= 0 && j < this.m) {
                max = j;
                j = supports.nextClearBit(j + 1);
            }
            this.v0.updateSup(max, this, false);
        }
    }

    public void reviseV1OnSup() throws ContradictionException {
        if (this.v1.hasEnumeratedDomain()) {
            IntDomain dom = this.v1.getDomain();
            int sup = this.v0.getSup();
            int val = dom.getInf();
            while (val <= dom.getSup()) {
                if (val % this.m > sup) {
                    this.v1.removeVal(val, this, false);
                }
                val = dom.getNextValue(val);
            }
        } else {
            this.v1.setSup(this.searchSupV1());
        }
    }

    public int searchSupV1() {
        int n = this.v1.getSup() / this.m * this.m;
        if (this.v1.getSup() % this.m >= this.v0.getSup()) {
            return this.v0.getSup() + n;
        }
        if (this.v1.getSup() % this.m < this.v0.getInf()) {
            return this.v0.getSup() + n - this.m;
        }
        if (this.v1.getSup() % this.m == this.v0.getInf()) {
            return this.v1.getSup();
        }
        IntDomain dom = this.v0.getDomain();
        int sup = dom.getPrevValue(this.v1.getSup() % this.m + 1);
        return sup + n;
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            this.reviseV1OnInst(this.v0.getVal());
        } else if (idx == 1) {
            this.reviseV0OnInst(this.v1.getVal());
        }
    }

    public void reviseV0OnInst(int inst) throws ContradictionException {
        this.v0.instantiate(inst % this.m, this, false);
    }

    public void reviseV1OnInst(int inst) throws ContradictionException {
        if (this.v1.hasEnumeratedDomain()) {
            IntDomain dom = this.v1.getDomain();
            int val = dom.getInf();
            while (val <= dom.getSup()) {
                if (val % this.m != inst) {
                    this.v1.removeVal(val, this, false);
                }
                val = dom.getNextValue(val);
            }
        } else {
            this.v1.setInf(this.searchInfV1());
            this.v1.setSup(this.searchSupV1());
        }
    }

    @Override
    public void awakeOnRem(int idx, int valeur) throws ContradictionException {
        if (idx == 0) {
            this.reviseV1OnRem(valeur);
        } else if (idx == 1) {
            this.reviseV0OnRem(this.searchSupports(), valeur);
        }
    }

    public void reviseV0OnRem(BitSet supports, int valeur) throws ContradictionException {
        if (this.v0.hasEnumeratedDomain()) {
            if (supports.get(valeur % this.m)) {
                this.v0.removeVal(valeur % this.m, this, false);
            }
        } else {
            int min;
            int max = min = supports.nextClearBit(0);
            int j = min;
            while (j >= 0 && j < this.m) {
                max = j;
                j = supports.nextClearBit(j + 1);
            }
            this.v0.updateInf(min, this, false);
            this.v0.updateSup(max, this, false);
        }
    }

    public void reviseV1OnRem(int valeur) throws ContradictionException {
        if (this.v1.hasEnumeratedDomain()) {
            IntDomain dom = this.v1.getDomain();
            for (int q = dom.getInf() / this.m; q <= dom.getSup() / this.m; ++q) {
                this.v1.removeVal(valeur + q * this.m, this, false);
            }
        } else {
            this.v1.setInf(this.searchInfV1());
            this.v1.setSup(this.searchSupV1());
        }
    }

    @Override
    public boolean isSatisfied() {
        return this.v0.getVal() == this.v1.getVal() % this.m;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[0] == tuple[1] % this.m;
    }

    @Override
    public String pretty() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.v0.toString());
        sb.append(" = ");
        sb.append(this.v1.toString());
        sb.append(" % ");
        return sb.toString();
    }
}

