/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupKey;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.smiles.BeamToCDK;
import org.openscience.cdk.smiles.CxSmilesParser;
import org.openscience.cdk.smiles.CxSmilesState;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import org.openscience.cdk.tools.manipulator.ReactionSetManipulator;
import uk.ac.ebi.beam.Graph;

public final class SmilesParser {
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(SmilesParser.class);
    private final IChemObjectBuilder builder;
    private final BeamToCDK beamToCDK;
    private boolean kekulise = true;
    private boolean strict = false;

    public SmilesParser(IChemObjectBuilder builder) {
        this.builder = builder;
        this.beamToCDK = new BeamToCDK(builder);
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public IReaction parseReactionSmiles(String smiles) throws InvalidSmilesException {
        int i;
        if (!smiles.contains(">")) {
            throw new InvalidSmilesException("Not a reaction SMILES: " + smiles);
        }
        int first = smiles.indexOf(62);
        int second = smiles.indexOf(62, first + 1);
        if (second < 0) {
            throw new InvalidSmilesException("Invalid reaction SMILES:" + smiles);
        }
        String reactants = smiles.substring(0, first);
        String agents = smiles.substring(first + 1, second);
        String products = smiles.substring(second + 1, smiles.length());
        IReaction reaction = (IReaction)this.builder.newInstance(IReaction.class, new Object[0]);
        if (!reactants.isEmpty()) {
            IAtomContainer reactantContainer = this.parseSmiles(reactants, true);
            IAtomContainerSet reactantSet = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)reactantContainer);
            for (i = 0; i < reactantSet.getAtomContainerCount(); ++i) {
                reaction.addReactant(reactantSet.getAtomContainer(i));
            }
        }
        if (!agents.isEmpty()) {
            IAtomContainer agentContainer = this.parseSmiles(agents, true);
            IAtomContainerSet agentSet = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)agentContainer);
            for (i = 0; i < agentSet.getAtomContainerCount(); ++i) {
                reaction.addAgent(agentSet.getAtomContainer(i));
            }
        }
        String title = null;
        if (!products.isEmpty()) {
            IAtomContainer productContainer = this.parseSmiles(products, true);
            IAtomContainerSet productSet = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)productContainer);
            for (int i2 = 0; i2 < productSet.getAtomContainerCount(); ++i2) {
                reaction.addProduct(productSet.getAtomContainer(i2));
            }
            title = (String)productContainer.getProperty((Object)"cdk:Title");
            reaction.setProperty((Object)"cdk:Title", (Object)title);
        }
        try {
            IReactionSet rset = (IReactionSet)reaction.getBuilder().newInstance(IReactionSet.class, new Object[0]);
            rset.addReaction(reaction);
            this.parseRxnCXSMILES(title, rset);
            reaction.setProperty((Object)"cdk:Title", rset.getProperty((Object)"cdk:Title"));
        }
        catch (Exception e) {
            throw new InvalidSmilesException("Error parsing CXSMILES", e);
        }
        return reaction;
    }

    public IReactionSet parseReactionSetSmiles(String smiles) throws InvalidSmilesException {
        int delim = smiles.length();
        for (int i = smiles.lastIndexOf(62); i < smiles.length(); ++i) {
            if (smiles.charAt(i) != ' ' && smiles.charAt(i) != '\t') continue;
            delim = i;
            break;
        }
        String[] parts = smiles.substring(0, delim).split(">", -1);
        String title = smiles.substring(delim).trim();
        if (parts.length < 3 || parts.length % 2 == 0) {
            throw new IllegalArgumentException("Unexpected number of parts: " + parts.length + ", should be 3,5,7,..");
        }
        IReactionSet reactions = (IReactionSet)this.builder.newInstance(IReactionSet.class, new Object[0]);
        IReaction reaction = this.builder.newReaction();
        for (int i = 0; i < parts.length; ++i) {
            IAtomContainer mol = this.parseSmiles(parts[i], true);
            IAtomContainerSet mols = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)mol);
            if (i == 0) {
                for (IAtomContainer container : mols.atomContainers()) {
                    reaction.addReactant(container);
                }
                continue;
            }
            if (i == 1) {
                for (IAtomContainer container : mols.atomContainers()) {
                    reaction.addAgent(container);
                }
                continue;
            }
            if (i % 2 == 0) {
                for (IAtomContainer container : mols.atomContainers()) {
                    reaction.addProduct(container);
                }
                reactions.addReaction(reaction);
                continue;
            }
            IReaction nextReaction = this.builder.newReaction();
            for (IAtomContainer container : reaction.getProducts().atomContainers()) {
                nextReaction.addReactant(container);
            }
            reaction = nextReaction;
            for (IAtomContainer container : mols.atomContainers()) {
                reaction.addAgent(container);
            }
        }
        try {
            this.parseRxnCXSMILES(title, reactions);
        }
        catch (Exception e) {
            throw new InvalidSmilesException("Error parsing CXSMILES", e);
        }
        return reactions;
    }

    public IAtomContainer parseSmiles(String smiles) throws InvalidSmilesException {
        return this.parseSmiles(smiles, false);
    }

    private IAtomContainer parseSmiles(String smiles, boolean isRxnPart) throws InvalidSmilesException {
        try {
            HashSet warnings = new HashSet();
            Graph g = Graph.parse((String)smiles, (boolean)this.strict, warnings);
            for (String warning : warnings) {
                this.logger.warn((Object)warning);
            }
            IAtomContainer mol = this.beamToCDK.toAtomContainer(this.kekulise ? g.kekule() : g, this.kekulise);
            if (!isRxnPart) {
                try {
                    this.parseMolCXSMILES(g.getTitle(), mol);
                }
                catch (Exception e) {
                    throw new InvalidSmilesException("Error parsing CXSMILES", e);
                }
            }
            return mol;
        }
        catch (IOException e) {
            throw new InvalidSmilesException("could not parse '" + smiles + "', " + e.getMessage());
        }
        catch (Exception e) {
            throw new InvalidSmilesException("could not parse '" + smiles + "'");
        }
    }

    private int parseIntSafe(String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void parseMolCXSMILES(String title, IAtomContainer mol) throws InvalidSmilesException {
        CxSmilesState cxstate;
        int pos;
        if (title != null && title.startsWith("|") && (pos = CxSmilesParser.processCx(title, cxstate = new CxSmilesState())) >= 0) {
            mol.setTitle(title.substring(pos));
            HashMap<IAtom, IAtomContainer> atomToMol = new HashMap<IAtom, IAtomContainer>(2 * mol.getAtomCount());
            ArrayList<IAtom> atoms = new ArrayList<IAtom>(mol.getAtomCount());
            for (IAtom atom : mol.atoms()) {
                atoms.add(atom);
                atomToMol.put(atom, mol);
            }
            this.assignCxSmilesInfo(mol.getBuilder(), (IChemObject)mol, atoms, atomToMol, cxstate);
        }
    }

    private void parseRxnCXSMILES(String title, IReactionSet rxns) throws InvalidSmilesException {
        if (title != null && title.startsWith("|")) {
            String arrowType;
            CxSmilesState cxstate = new CxSmilesState();
            int pos = CxSmilesParser.processCx(title, cxstate);
            if (pos >= 0) {
                rxns.setProperty((Object)"cdk:Title", (Object)title.substring(pos));
                HashMap<IAtom, IAtomContainer> atomToMol = new HashMap<IAtom, IAtomContainer>(100);
                ArrayList<IAtom> atoms = new ArrayList<IAtom>();
                HashSet<IAtomContainer> uniqueMolecules = new HashSet<IAtomContainer>();
                for (IAtomContainer mol : ReactionSetManipulator.getAllAtomContainers((IReactionSet)rxns)) {
                    if (!uniqueMolecules.add(mol)) continue;
                    for (IAtom atom : mol.atoms()) {
                        atoms.add(atom);
                    }
                }
                this.handleFragmentGrouping(rxns, cxstate);
                for (IAtomContainer mol : ReactionSetManipulator.getAllAtomContainers((IReactionSet)rxns)) {
                    for (IAtom atom : mol.atoms()) {
                        atomToMol.put(atom, mol);
                    }
                }
                this.assignCxSmilesInfo(rxns.getBuilder(), (IChemObject)rxns, atoms, atomToMol, cxstate);
            }
            if ((arrowType = (String)rxns.getProperty((Object)"cdk:Arrow")) != null && !arrowType.isEmpty()) {
                for (IReaction rxn : rxns.reactions()) {
                    switch (arrowType) {
                        case "RES": {
                            rxn.setDirection(IReaction.Direction.RESONANCE);
                            break;
                        }
                        case "EQU": {
                            rxn.setDirection(IReaction.Direction.BIDIRECTIONAL);
                            break;
                        }
                        case "RET": {
                            rxn.setDirection(IReaction.Direction.RETRO_SYNTHETIC);
                            break;
                        }
                        case "NGO": {
                            rxn.setDirection(IReaction.Direction.NO_GO);
                        }
                    }
                }
            }
        }
    }

    private void handleFragmentGrouping(IReactionSet rxns, CxSmilesState cxstate) {
        if (cxstate.fragGroups == null && cxstate.racemicFrags == null) {
            return;
        }
        boolean reactant = true;
        int agent = 2;
        int product = 3;
        HashSet<IAtomContainer> unique = new HashSet<IAtomContainer>();
        ArrayList<IAtomContainer> fragments = new ArrayList<IAtomContainer>();
        HashMap roleMap = new HashMap();
        HashMap<IAtomContainer, List> molToReaction = new HashMap<IAtomContainer, List>();
        for (IReaction reaction : rxns.reactions()) {
            for (IAtomContainer iAtomContainer : ReactionManipulator.getAllAtomContainers((IReaction)reaction)) {
                molToReaction.computeIfAbsent(iAtomContainer, k -> new ArrayList()).add(reaction);
                if (!unique.add(iAtomContainer)) continue;
                fragments.add(iAtomContainer);
            }
            for (IAtomContainer iAtomContainer : reaction.getReactants().atomContainers()) {
                roleMap.computeIfAbsent(iAtomContainer, k -> new ArrayList()).add(1);
            }
            for (IAtomContainer iAtomContainer : reaction.getAgents().atomContainers()) {
                roleMap.computeIfAbsent(iAtomContainer, k -> new ArrayList()).add(2);
            }
            for (IAtomContainer iAtomContainer : reaction.getProducts().atomContainers()) {
                roleMap.computeIfAbsent(iAtomContainer, k -> new ArrayList()).add(3);
            }
        }
        if (cxstate.racemicFrags != null) {
            for (Integer grp : cxstate.racemicFrags) {
                IAtomContainer mol;
                if (grp >= fragments.size() || (mol = (IAtomContainer)fragments.get(grp)) == null) continue;
                for (IStereoElement e : mol.stereoElements()) {
                    if (e.getConfigClass() != 16896) continue;
                    e.setGroupInfo(327680);
                }
            }
        }
        if (cxstate.fragGroups != null) {
            boolean invalid = false;
            HashSet<Integer> visit = new HashSet<Integer>();
            for (List list : cxstate.fragGroups) {
                IAtomContainer dest;
                if ((Integer)list.get(0) >= fragments.size() || (dest = (IAtomContainer)fragments.get((Integer)list.get(0))) == null) continue;
                if (!visit.add((Integer)list.get(0))) {
                    invalid = true;
                }
                for (int i = 1; i < list.size(); ++i) {
                    IAtomContainer src;
                    if (!visit.add((Integer)list.get(i))) {
                        invalid = true;
                    }
                    if ((Integer)list.get(i) >= fragments.size() || (src = (IAtomContainer)fragments.get((Integer)list.get(i))) == null) continue;
                    dest.add(src);
                    roleMap.put(src, Collections.emptyList());
                }
            }
            if (!invalid) {
                for (IReaction iReaction : rxns.reactions()) {
                    iReaction.getReactants().removeAllAtomContainers();
                    iReaction.getAgents().removeAllAtomContainers();
                    iReaction.getProducts().removeAllAtomContainers();
                }
                for (IAtomContainer iAtomContainer : fragments) {
                    List reactions = (List)molToReaction.get(iAtomContainer);
                    List roles = (List)roleMap.get(iAtomContainer);
                    if (roles.isEmpty()) continue;
                    block16: for (int i = 0; i < reactions.size(); ++i) {
                        IReaction rxn = (IReaction)reactions.get(i);
                        int role = (Integer)roles.get(i);
                        switch (role) {
                            case 1: {
                                rxn.getReactants().addAtomContainer(iAtomContainer);
                                continue block16;
                            }
                            case 3: {
                                rxn.getProducts().addAtomContainer(iAtomContainer);
                                continue block16;
                            }
                            case 2: {
                                rxn.getAgents().addAtomContainer(iAtomContainer);
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void assignCxSmilesInfo(IChemObjectBuilder bldr, IChemObject chemObj, List<IAtom> atoms, Map<IAtom, IAtomContainer> atomToMol, CxSmilesState cxstate) throws InvalidSmilesException {
        Object object;
        List bonds;
        IAtomContainer mol;
        IAtom beg;
        Sgroup sgroup;
        if (cxstate.atomLabels != null) {
            for (Map.Entry<Integer, String> e : cxstate.atomLabels.entrySet()) {
                IPseudoAtom pseudo;
                if (e.getKey() >= atoms.size()) continue;
                IAtom old = atoms.get(e.getKey());
                if (old instanceof IPseudoAtom) {
                    pseudo = (IPseudoAtom)old;
                } else {
                    pseudo = (IPseudoAtom)bldr.newInstance(IPseudoAtom.class, new Object[0]);
                    IAtomContainer mol2 = atomToMol.get(old);
                    AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)mol2, (IAtom)old, (IAtom)pseudo);
                    atomToMol.put((IAtom)pseudo, mol2);
                    atoms.set(e.getKey(), mol2.getAtom(old.getIndex()));
                }
                String val = e.getValue();
                if (val.endsWith("_p")) {
                    val = val.substring(0, val.length() - 2);
                } else if (val.startsWith("_AP")) {
                    pseudo.setAttachPointNum(this.parseIntSafe(val.substring(3)));
                }
                pseudo.setLabel(val);
                pseudo.setAtomicNumber(Integer.valueOf(0));
                pseudo.setImplicitHydrogenCount(Integer.valueOf(0));
            }
        }
        if (cxstate.atomValues != null) {
            for (Map.Entry<Integer, String> e : cxstate.atomValues.entrySet()) {
                atoms.get(e.getKey()).setProperty((Object)"cdk:Comment", (Object)e.getValue());
            }
        }
        if (cxstate.atomCoords != null) {
            int numAtoms = atoms.size();
            int numCoords = cxstate.atomCoords.size();
            int lim = Math.min(numAtoms, numCoords);
            if (cxstate.coordFlag) {
                for (int i = 0; i < lim; ++i) {
                    atoms.get(i).setPoint3d(new Point3d(cxstate.atomCoords.get(i)));
                }
            } else {
                for (int i = 0; i < lim; ++i) {
                    atoms.get(i).setPoint2d(new Point2d(cxstate.atomCoords.get(i)));
                }
            }
        }
        if (cxstate.atomRads != null) {
            for (Map.Entry<Integer, CxSmilesState.Radical> e : cxstate.atomRads.entrySet()) {
                if (e.getKey() >= atoms.size()) continue;
                int count = 0;
                switch (e.getValue()) {
                    case Monovalent: {
                        count = 1;
                        break;
                    }
                    case Divalent: 
                    case DivalentSinglet: 
                    case DivalentTriplet: {
                        count = 2;
                        break;
                    }
                    case Trivalent: 
                    case TrivalentDoublet: 
                    case TrivalentQuartet: {
                        count = 3;
                    }
                }
                IAtom atom = atoms.get(e.getKey());
                IAtomContainer mol2 = atomToMol.get(atom);
                while (count-- > 0) {
                    mol2.addSingleElectron((ISingleElectron)bldr.newInstance(ISingleElectron.class, new Object[]{atom}));
                }
            }
        }
        HashMap<IAtomContainer, List> sgroupMap = new HashMap<IAtomContainer, List>();
        HashMap<CxSmilesState.CxSgroup, Sgroup> sgroupRemap = new HashMap<CxSmilesState.CxSgroup, Sgroup>();
        if (cxstate.positionVar != null) {
            for (Map.Entry<Integer, List<Integer>> e : cxstate.positionVar.entrySet()) {
                sgroup = new Sgroup();
                sgroup.setType(SgroupType.ExtMulticenter);
                beg = atoms.get(e.getKey());
                mol = atomToMol.get(beg);
                bonds = mol.getConnectedBondsList(beg);
                if (bonds.isEmpty()) continue;
                sgroup.addAtom(beg);
                sgroup.addBond((IBond)bonds.get(0));
                for (Integer n : e.getValue()) {
                    sgroup.addAtom(atoms.get(n));
                }
                sgroupMap.computeIfAbsent(mol, k -> new ArrayList()).add(sgroup);
            }
        }
        if (cxstate.ligandOrdering != null) {
            for (Map.Entry<Integer, List<Integer>> e : cxstate.ligandOrdering.entrySet()) {
                sgroup = new Sgroup();
                sgroup.setType(SgroupType.ExtAttachOrdering);
                beg = atoms.get(e.getKey());
                mol = atomToMol.get(beg);
                bonds = mol.getConnectedBondsList(beg);
                if (bonds.isEmpty()) {
                    throw new InvalidSmilesException("CXSMILES LO: no bonds to order");
                }
                if (bonds.size() != e.getValue().size()) {
                    throw new InvalidSmilesException("CXSMILES LO: bond count and ordering count was different");
                }
                sgroup.addAtom(beg);
                for (Integer n : e.getValue()) {
                    IBond bond = beg.getBond(atoms.get(n));
                    if (bond == null) {
                        throw new InvalidSmilesException("CXSMILES LO: defined ordering to non-existant bond");
                    }
                    sgroup.addBond(bond);
                }
                sgroupMap.computeIfAbsent(mol, k -> new ArrayList()).add(sgroup);
            }
        }
        if (cxstate.mysgroups != null) {
            block49: for (CxSmilesState.CxSgroup cxsgroup : cxstate.mysgroups) {
                void var15_66;
                if (!(cxsgroup instanceof CxSmilesState.CxPolymerSgroup)) continue;
                CxSmilesState.CxPolymerSgroup psgroup = (CxSmilesState.CxPolymerSgroup)cxsgroup;
                Sgroup sgroup2 = new Sgroup();
                HashSet<Object> atomset = new HashSet<Object>();
                IAtomContainer mol3 = null;
                for (Integer n : psgroup.atoms) {
                    if (n >= atoms.size()) continue;
                    IAtom atom = atoms.get(n);
                    IAtomContainer amol = atomToMol.get(atom);
                    if (mol3 == null) {
                        mol3 = amol;
                    } else if (amol != mol3) continue block49;
                    atomset.add(atom);
                }
                if (mol3 == null) continue;
                for (IAtom iAtom : atomset) {
                    for (IBond bond : mol3.getConnectedBondsList(iAtom)) {
                        List<Integer> ends;
                        IAtom nbor = bond.getOther(iAtom);
                        if (atomset.contains(nbor)) continue;
                        boolean crossing = true;
                        if (cxstate.positionVar != null && (ends = cxstate.positionVar.get(mol3.indexOf(nbor))) != null) {
                            for (Integer end : ends) {
                                if (!atomset.contains(mol3.getAtom(end.intValue()))) continue;
                                crossing = false;
                            }
                        }
                        if (!crossing) continue;
                        sgroup2.addBond(bond);
                    }
                    sgroup2.addAtom(iAtom);
                }
                sgroup2.setSubscript(psgroup.subscript);
                sgroup2.putValue(SgroupKey.CtabConnectivity, (Object)psgroup.supscript);
                object = psgroup.type;
                int n = -1;
                switch (((String)object).hashCode()) {
                    case 110: {
                        if (!((String)object).equals("n")) break;
                        boolean bl = false;
                        break;
                    }
                    case 108300: {
                        if (!((String)object).equals("mon")) break;
                        boolean bl = true;
                        break;
                    }
                    case 107994: {
                        if (!((String)object).equals("mer")) break;
                        int n2 = 2;
                        break;
                    }
                    case 3180: {
                        if (!((String)object).equals("co")) break;
                        int n3 = 3;
                        break;
                    }
                    case 3828: {
                        if (!((String)object).equals("xl")) break;
                        int n4 = 4;
                        break;
                    }
                    case 108290: {
                        if (!((String)object).equals("mod")) break;
                        int n5 = 5;
                        break;
                    }
                    case 108124: {
                        if (!((String)object).equals("mix")) break;
                        int n6 = 6;
                        break;
                    }
                    case 102: {
                        if (!((String)object).equals("f")) break;
                        int n7 = 7;
                        break;
                    }
                    case 96748: {
                        if (!((String)object).equals("any")) break;
                        int n8 = 8;
                        break;
                    }
                    case 102224: {
                        if (!((String)object).equals("gen")) break;
                        int n9 = 9;
                        break;
                    }
                    case 99: {
                        if (!((String)object).equals("c")) break;
                        int n10 = 10;
                        break;
                    }
                    case 102619: {
                        if (!((String)object).equals("grf")) break;
                        int n11 = 11;
                        break;
                    }
                    case 96681: {
                        if (!((String)object).equals("alt")) break;
                        int n12 = 12;
                        break;
                    }
                    case 112671: {
                        if (!((String)object).equals("ran")) break;
                        int n13 = 13;
                        break;
                    }
                    case 97633: {
                        if (!((String)object).equals("blk")) break;
                        int n14 = 14;
                    }
                }
                switch (var15_66) {
                    case 0: {
                        sgroup2.setType(SgroupType.CtabStructureRepeatUnit);
                        break;
                    }
                    case 1: {
                        sgroup2.setType(SgroupType.CtabMonomer);
                        break;
                    }
                    case 2: {
                        sgroup2.setType(SgroupType.CtabMer);
                        break;
                    }
                    case 3: {
                        sgroup2.setType(SgroupType.CtabCopolymer);
                        break;
                    }
                    case 4: {
                        sgroup2.setType(SgroupType.CtabCrossLink);
                        break;
                    }
                    case 5: {
                        sgroup2.setType(SgroupType.CtabModified);
                        break;
                    }
                    case 6: {
                        sgroup2.setType(SgroupType.CtabMixture);
                        break;
                    }
                    case 7: {
                        sgroup2.setType(SgroupType.CtabFormulation);
                        break;
                    }
                    case 8: {
                        sgroup2.setType(SgroupType.CtabAnyPolymer);
                        break;
                    }
                    case 9: {
                        sgroup2.setType(SgroupType.CtabGeneric);
                        break;
                    }
                    case 10: {
                        sgroup2.setType(SgroupType.CtabComponent);
                        break;
                    }
                    case 11: {
                        sgroup2.setType(SgroupType.CtabGraft);
                        break;
                    }
                    case 12: {
                        sgroup2.setType(SgroupType.CtabCopolymer);
                        sgroup2.putValue(SgroupKey.CtabSubType, (Object)"ALT");
                        break;
                    }
                    case 13: {
                        sgroup2.setType(SgroupType.CtabCopolymer);
                        sgroup2.putValue(SgroupKey.CtabSubType, (Object)"RAN");
                        break;
                    }
                    case 14: {
                        sgroup2.setType(SgroupType.CtabCopolymer);
                        sgroup2.putValue(SgroupKey.CtabSubType, (Object)"BLO");
                    }
                }
                sgroupMap.computeIfAbsent(mol3, k -> new ArrayList()).add(sgroup2);
                sgroupRemap.put(psgroup, sgroup2);
            }
        }
        if (cxstate.mysgroups != null) {
            block54: for (CxSmilesState.CxSgroup cxsgroup : cxstate.mysgroups) {
                if (!(cxsgroup instanceof CxSmilesState.CxDataSgroup)) continue;
                CxSmilesState.CxDataSgroup dsgroup = (CxSmilesState.CxDataSgroup)cxsgroup;
                HashSet atomset = new HashSet();
                mol = null;
                for (Integer idx : dsgroup.atoms) {
                    if (idx >= atoms.size()) continue;
                    IAtom iAtom = atoms.get(idx);
                    IAtomContainer amol = atomToMol.get(iAtom);
                    if (mol == null) {
                        mol = amol;
                    } else if (amol != mol) continue block54;
                    atomset.add(iAtom);
                }
                if (dsgroup.field != null && dsgroup.field.startsWith("cdk:")) {
                    chemObj.setProperty((Object)dsgroup.field, (Object)dsgroup.value);
                    continue;
                }
                Sgroup cdkSgroup = new Sgroup();
                cdkSgroup.setType(SgroupType.CtabData);
                object = atomset.iterator();
                while (object.hasNext()) {
                    IAtom iAtom = (IAtom)object.next();
                    cdkSgroup.addAtom(iAtom);
                }
                cdkSgroup.putValue(SgroupKey.DataFieldName, (Object)dsgroup.field);
                cdkSgroup.putValue(SgroupKey.DataFieldUnits, (Object)dsgroup.unit);
                cdkSgroup.putValue(SgroupKey.Data, (Object)dsgroup.value);
                sgroupRemap.put(dsgroup, cdkSgroup);
                if (mol != null) {
                    sgroupMap.computeIfAbsent(mol, k -> new ArrayList()).add(cdkSgroup);
                    continue;
                }
                if (!(chemObj instanceof IAtomContainer)) continue;
                sgroupMap.computeIfAbsent((IAtomContainer)chemObj, k -> new ArrayList()).add(cdkSgroup);
            }
        }
        if (cxstate.mysgroups != null) {
            for (CxSmilesState.CxSgroup parent : cxstate.mysgroups) {
                Sgroup cdkParent = (Sgroup)sgroupRemap.get(parent);
                if (cdkParent == null) continue;
                for (CxSmilesState.CxSgroup child : parent.children) {
                    Sgroup cdkChild = (Sgroup)sgroupRemap.get(child);
                    if (cdkChild == null) continue;
                    cdkChild.addParent(cdkParent);
                }
            }
        }
        if (cxstate.racemic) {
            if (chemObj instanceof IAtomContainer) {
                for (IStereoElement e : ((IAtomContainer)chemObj).stereoElements()) {
                    if (e.getConfigClass() != 16896) continue;
                    e.setGroupInfo(327680);
                }
            } else if (chemObj instanceof IReaction) {
                for (IAtomContainer mol4 : ReactionManipulator.getAllAtomContainers((IReaction)((IReaction)chemObj))) {
                    for (IStereoElement e : mol4.stereoElements()) {
                        if (e.getConfigClass() != 16896) continue;
                        e.setGroupInfo(327680);
                    }
                }
            }
        }
        if (cxstate.stereoGrps != null) {
            for (Map.Entry<Integer, Integer> e : cxstate.stereoGrps.entrySet()) {
                IAtom atm = atoms.get(e.getKey());
                IAtomContainer mol5 = atomToMol.get(atm);
                for (IStereoElement stereo : mol5.stereoElements()) {
                    if (stereo.getConfigClass() != 16896 || !stereo.getFocus().equals(atm)) continue;
                    stereo.setGroupInfo(e.getValue().intValue());
                }
            }
        }
        for (Map.Entry e : sgroupMap.entrySet()) {
            ((IAtomContainer)e.getKey()).setProperty((Object)"cdk:CtabSgroups", new ArrayList((Collection)e.getValue()));
        }
    }

    @Deprecated
    public void setPreservingAromaticity(boolean preservingAromaticity) {
        this.kekulise = !preservingAromaticity;
    }

    @Deprecated
    public boolean isPreservingAromaticity() {
        return !this.kekulise;
    }

    public void kekulise(boolean kekulise) {
        this.kekulise = kekulise;
    }
}

