/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.xpdl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.data.creators.DataFactory;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGSets;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.NumericTarget;
import org.vikamine.kernel.subgroup.target.SGTarget;
import org.vikamine.kernel.subgroup.target.SelectorTarget;
import org.vikamine.kernel.xpdl.DatasetProvider;
import org.vikamine.kernel.xpdl.XMLException;

public class PatternsetToSGSet {
    private final Document doc;
    private Ontology ont;

    public PatternsetToSGSet(DatasetProvider prov, File patternSet) {
        this.doc = this.buildDoc(patternSet);
        String datasetName = this.doc.getRootElement().getAttributeValue("dataset");
        datasetName = datasetName.substring(datasetName.indexOf("object=") + 7);
        datasetName = datasetName.replace("]", "");
        if (!prov.providesDataset(datasetName)) {
            throw new XMLException("Dataset does not exist!");
        }
        this.ont = prov.getDataset(datasetName);
    }

    public PatternsetToSGSet(File patternSet, String repositoryLocation) throws IOException {
        this.doc = this.buildDoc(patternSet);
        String fileName = String.valueOf(repositoryLocation) + this.getDatasetName();
        File file = new File(fileName);
        if (!file.exists()) {
            throw new IllegalArgumentException("data file does not exist!");
        }
        this.ont = DataFactory.createOntology(file);
        this.getSet();
    }

    public PatternsetToSGSet(File patternSet, DatasetProvider prov) {
        this.doc = this.buildDoc(patternSet);
        if (!prov.providesDataset(this.getDatasetName())) {
            throw new XMLException("Dataset does not exist!");
        }
        this.ont = prov.getDataset(this.getDatasetName());
    }

    private List<Element> getSGs() {
        return this.doc.getRootElement().getChildren("subgroupPattern");
    }

    private IDataRecordSet getDataset() {
        return this.ont.getDataView().dataset();
    }

    private SGTarget getTarget(Element sg) {
        Element target = sg.getChild("target");
        DefaultSGSelector sel = null;
        String targetType = target.getAttributeValue("type");
        Element EAttribute = this.getAttributes(target).get(0);
        if (this.getDataset().getAttribute(EAttribute.getAttributeValue("name")) == null) {
            throw new XMLException("Attribute " + EAttribute.getAttributeValue("name") + " doesn't exist");
        }
        if (targetType.equals("boolean")) {
            Attribute attribute = this.getDataset().getAttribute(EAttribute.getAttributeValue("name"));
            if (attribute instanceof NominalAttribute) {
                NominalAttribute nominalAttribute = (NominalAttribute)attribute;
                Iterator<Value> it = nominalAttribute.allValuesIterator();
                while (it.hasNext()) {
                    Value val = it.next();
                    for (Element k : this.getValues(EAttribute)) {
                        if (!val.getDescription().equals(k.getValue())) continue;
                        sel = new DefaultSGSelector(attribute, val);
                    }
                }
            } else {
                throw new IllegalStateException("not a nominal attribute!");
            }
            return new SelectorTarget(sel);
        }
        Attribute att = this.getDataset().getAttribute(EAttribute.getAttributeValue("name"));
        if (att.isNumeric()) {
            NumericAttribute nAtt = (NumericAttribute)att;
            return new NumericTarget(nAtt);
        }
        throw new IllegalStateException("not a numeric attribute!");
    }

    private String getDatasetName() {
        return this.doc.getRootElement().getAttributeValue("dataset");
    }

    private Element getRestrictions() {
        return this.doc.getRootElement().getChild("dataset").getChild("restrictions");
    }

    private Iterator<Value> getValueIterator(Attribute attribute) {
        if (attribute instanceof NominalAttribute) {
            return ((NominalAttribute)attribute).allValuesIterator();
        }
        return attribute.usedValuesIterator(this.getDataset());
    }

    private void setPopulation() {
        DefaultSGSelector sel = null;
        ArrayList<SGSelector> selectors = new ArrayList<SGSelector>();
        if (this.getRestrictions() != null) {
            for (Element a : this.getAttributes(this.getRestrictions())) {
                HashSet<Value> values = new HashSet<Value>();
                if (this.getDataset().getAttribute(a.getAttributeValue("name")) == null) {
                    throw new XMLException("Attribute " + a.getAttributeValue("name") + " does not exist");
                }
                Iterator<Value> it = this.getValueIterator(this.ont.getAttribute(a.getAttributeValue("name")));
                while (it.hasNext()) {
                    Value val = it.next();
                    for (Element k : this.getValues(a)) {
                        if (k.getName().equals("includeValue")) {
                            if (!val.getDescription().equals(k.getValue())) continue;
                            values.add(val);
                            continue;
                        }
                        if (val.getDescription().equals(k.getValue())) continue;
                        values.add(val);
                    }
                }
                sel = new DefaultSGSelector(this.getDataset().getAttribute(a.getAttributeValue("name")), values);
                selectors.add(sel);
            }
            this.ont.refinePopulation(selectors);
        }
    }

    private Element getDescription(Element sg) {
        return sg.getChild("description");
    }

    public SGSet getSet() {
        this.setPopulation();
        SGSet set = SGSets.createSGSet();
        for (Element e : this.getSGs()) {
            SG sg = new SG(this.ont.getDataView(), this.getTarget(e));
            DefaultSGSelector sel = null;
            Element description = this.getDescription(e);
            if (description != null) {
                for (Element a : this.getAttributes(description.getChild("operator"))) {
                    HashSet<Value> values = new HashSet<Value>();
                    if (this.getDataset().getAttribute(a.getAttributeValue("name")) == null) {
                        throw new XMLException("Attribute " + a.getAttributeValue("name") + " doesn't exist");
                    }
                    Iterator<Value> it = this.getValueIterator(this.getDataset().getAttribute(a.getAttributeValue("name")));
                    while (it.hasNext()) {
                        Value val = it.next();
                        for (Element k : this.getValues(a)) {
                            if (k.getName().equals("includeValue")) {
                                if (!val.getDescription().equals(k.getValue())) continue;
                                values.add(val);
                                continue;
                            }
                            if (val.getDescription().equals(k.getValue())) continue;
                            values.add(val);
                        }
                    }
                    sel = new DefaultSGSelector(this.getDataset().getAttribute(a.getAttributeValue("name")), values);
                    sg.getSGDescription().add(sel);
                }
                sg.createStatistics(null);
            } else {
                sg.createStatistics(null);
            }
            set.add(sg);
        }
        return set;
    }

    private List<Element> getAttributes(Element t) {
        return t.getChildren("attribute");
    }

    private List<Element> getValues(Element attribute) {
        return attribute.getChildren();
    }

    private Document buildDoc(File toBuild) {
        SAXBuilder sax = new SAXBuilder();
        try {
            return sax.build(toBuild);
        }
        catch (JDOMException e) {
            throw new XMLException("Eingabe-datei nicht valide");
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }
}

