/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.partitions;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.partitions.PartitionRegionImpl;
import com.simba.athena.amazonaws.partitions.model.Partition;
import com.simba.athena.amazonaws.partitions.model.Region;
import com.simba.athena.amazonaws.regions.AbstractRegionMetadataProvider;
import com.simba.athena.amazonaws.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SdkInternalApi
public class PartitionMetadataProvider
extends AbstractRegionMetadataProvider {
    private final Map<String, Partition> partitionMap = new HashMap<String, Partition>();
    private final Map<String, com.simba.athena.amazonaws.regions.Region> regionCache = new ConcurrentHashMap<String, com.simba.athena.amazonaws.regions.Region>();

    public PartitionMetadataProvider(List<Partition> partitions) {
        ValidationUtils.assertNotNull(partitions, "partitions");
        for (Partition p : partitions) {
            this.partitionMap.put(p.getPartition(), p);
        }
    }

    @Override
    public List<com.simba.athena.amazonaws.regions.Region> getRegions() {
        ArrayList<com.simba.athena.amazonaws.regions.Region> regions = new ArrayList<com.simba.athena.amazonaws.regions.Region>();
        for (Partition p : this.partitionMap.values()) {
            for (Map.Entry<String, Region> entry : p.getRegions().entrySet()) {
                regions.add(new com.simba.athena.amazonaws.regions.Region(new PartitionRegionImpl(entry.getKey(), p)));
            }
        }
        return Collections.unmodifiableList(regions);
    }

    @Override
    public com.simba.athena.amazonaws.regions.Region getRegion(String regionName) {
        if (regionName == null) {
            return null;
        }
        com.simba.athena.amazonaws.regions.Region regionFromCache = this.getRegionFromCache(regionName);
        if (regionFromCache != null) {
            return regionFromCache;
        }
        return this.createNewRegion(regionName);
    }

    private com.simba.athena.amazonaws.regions.Region createNewRegion(String regionName) {
        for (Partition p : this.partitionMap.values()) {
            if (!p.hasRegion(regionName)) continue;
            return this.cacheRegion(new PartitionRegionImpl(regionName, p));
        }
        Partition awsPartition = this.partitionMap.get("aws");
        if (awsPartition != null) {
            return this.cacheRegion(new PartitionRegionImpl(regionName, awsPartition));
        }
        return null;
    }

    private com.simba.athena.amazonaws.regions.Region getRegionFromCache(String regionName) {
        return this.regionCache.get(regionName);
    }

    private com.simba.athena.amazonaws.regions.Region cacheRegion(PartitionRegionImpl regionImpl) {
        com.simba.athena.amazonaws.regions.Region region = new com.simba.athena.amazonaws.regions.Region(regionImpl);
        this.regionCache.put(region.getName(), region);
        return region;
    }

    @Override
    public List<com.simba.athena.amazonaws.regions.Region> getRegionsForService(String serviceName) {
        List<com.simba.athena.amazonaws.regions.Region> allRegions = this.getRegions();
        ArrayList<com.simba.athena.amazonaws.regions.Region> serviceSupportedRegions = new ArrayList<com.simba.athena.amazonaws.regions.Region>();
        for (com.simba.athena.amazonaws.regions.Region r : allRegions) {
            if (!r.isServiceSupported(serviceName)) continue;
            serviceSupportedRegions.add(r);
        }
        return serviceSupportedRegions;
    }
}

