/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic.phyloclustering.statistics;

import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.LinkedList;

public class ActiveIndicatorsStatistic
extends Statistic.Abstract
implements VariableListener {
    private LinkedList<Double> activeNodes = new LinkedList();
    private int max_dim;
    public static final String ACTIVE_INDICATORS_STATISTIC = "activeIndicatorsStatistic";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String INDICATORS = "indicators";
        public static final String MAXDIMSTR = "maxDim";
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("indicators", Parameter.class), AttributeRule.newDoubleRule("maxDim", true, "the variance of mu")};

        @Override
        public String getParserName() {
            return ActiveIndicatorsStatistic.ACTIVE_INDICATORS_STATISTIC;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(INDICATORS);
            int n = 30;
            if (xMLObject.hasAttribute(MAXDIMSTR)) {
                n = xMLObject.getIntegerAttribute(MAXDIMSTR);
            }
            return new ActiveIndicatorsStatistic(parameter, n);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a statistic that shifts a matrix of locations by location drift in the first dimension.";
        }

        @Override
        public Class getReturnType() {
            return ActiveIndicatorsStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private Parameter indicatorsParameter;

    public ActiveIndicatorsStatistic(Parameter parameter, int n) {
        this.indicatorsParameter = parameter;
        this.indicatorsParameter.addParameterListener(this);
        this.max_dim = n;
    }

    @Override
    public int getDimension() {
        return this.max_dim;
    }

    @Override
    public double getStatisticValue(int n) {
        if (n == 0) {
            this.activeNodes = new LinkedList();
            for (int i = 0; i < this.indicatorsParameter.getDimension(); ++i) {
                if ((int)this.indicatorsParameter.getParameterValue(i) != 1) continue;
                this.activeNodes.addLast(new Double(i));
            }
        }
        double d = -1.0;
        if (n < this.activeNodes.size()) {
            d = this.activeNodes.get(n);
        }
        if (n == this.max_dim - 1 && this.activeNodes.size() > this.max_dim) {
            d = -9999999.0;
        }
        return d;
    }

    @Override
    public String getDimensionName(int n) {
        String string = "on_" + (n + 1);
        return string;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }
}

